/*
 * Decompiled with CFR 0.152.
 */
package phex.upload.handler;

import java.io.IOException;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.file.ManagedFileException;
import phex.http.HTTPHeader;
import phex.http.HTTPRangeSet;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.Range;
import phex.servent.Servent;
import phex.share.PartialShareFile;
import phex.share.ShareFile;
import phex.share.SharedFilesService;
import phex.thex.ShareFileThexData;
import phex.upload.UploadState;
import phex.upload.handler.AbstractUploadHandler;
import phex.upload.response.ShareFileUploadResponse;
import phex.upload.response.UploadResponse;
import phex.utils.URLUtil;

public class FileUploadHandler
extends AbstractUploadHandler {
    private final Servent servent;
    private Range uploadRangeEntry;
    private long startOffset;
    private long endOffset;

    public FileUploadHandler(SharedFilesService sharedFilesService, Servent servent) {
        super(sharedFilesService);
        this.servent = servent;
    }

    protected UploadResponse determineFailFastResponse(HTTPRequest httpRequest, UploadState uploadState, ShareFile requestedFile) {
        HTTPRangeSet uploadRange = null;
        HTTPHeader rangeHeader = httpRequest.getHeader("Range");
        if (rangeHeader != null) {
            uploadRange = HTTPRangeSet.parseHTTPRangeSet(rangeHeader.getValue(), true);
            if (uploadRange == null) {
                return UploadResponse.get500RangeNotParseable(requestedFile, uploadState);
            }
        } else {
            uploadRange = new HTTPRangeSet(0L, -1L);
        }
        this.uploadRangeEntry = uploadRange.getFirstRange();
        Range.RangeAvailability rangeAvail = requestedFile.getRangeAvailableStatus(this.uploadRangeEntry);
        if (rangeAvail != Range.RangeAvailability.RANGE_AVAILABLE) {
            HTTPResponse httpResponse = rangeAvail == Range.RangeAvailability.RANGE_NOT_AVAILABLE ? new HTTPResponse(503, "Requested Range Not Available", true) : new HTTPResponse(416, "Requested Range Not Satisfiable", true);
            if (requestedFile instanceof PartialShareFile) {
                PartialShareFile pShareFile = (PartialShareFile)requestedFile;
                httpResponse.addHeader(new HTTPHeader("X-Available-Ranges", pShareFile.buildXAvailableRangesString()));
            }
            UploadResponse uploadResponse = new UploadResponse(httpResponse);
            UploadResponse.appendAltLocs(uploadResponse, requestedFile, uploadState);
            return uploadResponse;
        }
        return null;
    }

    public UploadResponse finalizeUploadResponse(HTTPRequest httpRequest, UploadState uploadState, ShareFile requestedFile) throws IOException {
        ShareFileUploadResponse response;
        HTTPHeader availRangesHeader = null;
        if (requestedFile instanceof PartialShareFile) {
            PartialShareFile pShareFile = (PartialShareFile)requestedFile;
            pShareFile.findFittingPartForRange(this.uploadRangeEntry);
            availRangesHeader = new HTTPHeader("X-Available-Ranges", pShareFile.buildXAvailableRangesString());
        }
        this.startOffset = this.uploadRangeEntry.getStartOffset(requestedFile.getFileSize());
        this.endOffset = this.uploadRangeEntry.getEndOffset(requestedFile.getFileSize());
        long contentLength = this.endOffset - this.startOffset + 1L;
        URN sharedFileURN = requestedFile.getURN();
        uploadState.update(requestedFile.getFileName(), sharedFileURN, contentLength);
        try {
            response = new ShareFileUploadResponse(requestedFile, this.startOffset, contentLength);
        }
        catch (ManagedFileException exp) {
            IOException ioExp = new IOException("ManagedFileException: " + exp.getMessage());
            ioExp.initCause(exp);
            throw ioExp;
        }
        if (availRangesHeader != null) {
            response.addHttpHeader(availRangesHeader);
        }
        response.addHttpHeader(new HTTPHeader("Content-Type", "application/binary"));
        response.addHttpHeader(new HTTPHeader("Content-Length", String.valueOf(contentLength)));
        response.addHttpHeader(new HTTPHeader("Content-Range", "bytes " + this.startOffset + "-" + this.endOffset + "/" + requestedFile.getFileSize()));
        response.addHttpHeader(new HTTPHeader("Connection", "Keep-Alive"));
        if (sharedFileURN != null) {
            response.addHttpHeader(new HTTPHeader("X-Gnutella-Content-URN", sharedFileURN.getAsString()));
        }
        UploadResponse.appendAltLocs(response, requestedFile, uploadState);
        DestAddress[] pushProxies = this.servent.getHostService().getNetworkHostsContainer().getPushProxies();
        UploadResponse.addPushProxyResponseHeader(pushProxies, response);
        if (sharedFileURN != null) {
            this.handleAltLocRequestHeader(httpRequest, uploadState, requestedFile, sharedFileURN, this.servent.getSecurityService());
            ShareFileThexData thexData = requestedFile.getThexData(this.sharedFilesService);
            if (thexData != null) {
                String thexRootHash = thexData.getRootHash();
                HTTPHeader thexHeader = new HTTPHeader("X-Thex-URI", URLUtil.buildName2ResThexURL(sharedFileURN, thexRootHash));
                response.addHttpHeader(thexHeader);
            }
        }
        return response;
    }
}

