/*
 * Decompiled with CFR 0.152.
 */
package phex.upload.response;

import com.onionnetworks.dime.DimeGenerator;
import com.onionnetworks.dime.DimeRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import phex.http.HTTPResponse;
import phex.io.buffer.ByteBuffer;
import phex.share.ShareFile;
import phex.thex.FileHashCalculationHandler;
import phex.thex.ShareFileThexData;
import phex.upload.response.UploadResponse;
import phex.utils.StringUtils;
import phex.xml.thex.ThexHashTree;
import phex.xml.thex.ThexHashTreeCodec;

public class ThexUploadResponse
extends UploadResponse {
    private byte[] dimeData;
    private int offset;

    public ThexUploadResponse(ShareFile shareFile, FileHashCalculationHandler fileHashCalcQueue) throws IOException {
        super(new HTTPResponse(200, "OK", true));
        ShareFileThexData thexData = shareFile.getThexData(fileHashCalcQueue);
        String uuidStr = StringUtils.generateRandomUUIDString();
        ThexHashTree hashTree = new ThexHashTree();
        hashTree.setFileSize(String.valueOf(shareFile.getFileSize()));
        hashTree.setFileSegmentSize("1024");
        hashTree.setDigestAlgorithm("http://open-content.net/spec/digest/tiger");
        hashTree.setDigestOutputSize("24");
        hashTree.setSerializedTreeDepth(String.valueOf(thexData.getTreeDepth()));
        hashTree.setSerializedTreeType("http://open-content.net/spec/thex/breadthfirst");
        hashTree.setSerializedTreeUri("uuid:" + uuidStr);
        String type = "http://open-content.net/spec/thex/breadthfirst";
        byte[] metadata = ThexHashTreeCodec.generateThexHashTreeXML(hashTree);
        byte[] serialization = thexData.getSerializedTreeNodes();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(metadata.length + serialization.length + 1024);
        DimeGenerator dg = new DimeGenerator(outputStream);
        DimeRecord dr = new DimeRecord(metadata, DimeRecord.TypeNameFormat.MEDIA_TYPE, type, null);
        dg.addRecord(dr, false);
        DimeRecord dr2 = new DimeRecord(serialization, DimeRecord.TypeNameFormat.URI, type, "uuid:" + uuidStr);
        dg.addRecord(dr2, true);
        this.dimeData = outputStream.toByteArray();
        this.offset = 0;
    }

    public int remainingBody() {
        return this.dimeData.length - this.offset;
    }

    public int fillBody(ByteBuffer directBuffer) throws IOException {
        int remaining = directBuffer.remaining();
        directBuffer.put(this.dimeData, this.offset, remaining);
        this.offset += remaining;
        return remaining;
    }

    public void countUpload() {
    }

    public void close() {
        this.dimeData = null;
    }
}

