/*
 * Decompiled with CFR 0.152.
 */
package phex.upload.response;

import java.io.IOException;
import phex.common.AltLocContainer;
import phex.common.address.DestAddress;
import phex.http.HTTPHeader;
import phex.http.HTTPResponse;
import phex.http.XQueueParameters;
import phex.io.buffer.ByteBuffer;
import phex.share.ShareFile;
import phex.upload.UploadState;

public class UploadResponse {
    protected HTTPResponse httpResponse;

    public UploadResponse(HTTPResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    protected UploadResponse() {
    }

    public int fillBody(ByteBuffer byteBuffer) throws IOException {
        throw new UnsupportedOperationException("No Data.");
    }

    public int remainingBody() {
        return 0;
    }

    public void countUpload() {
    }

    public void close() {
    }

    public void addHttpHeader(HTTPHeader header) {
        this.httpResponse.addHeader(header);
    }

    public String buildHTTPResponseString() {
        return this.httpResponse.buildHTTPResponseString();
    }

    public static final UploadResponse get404FileNotFound() {
        HTTPResponse response = new HTTPResponse(404, "File not found", true);
        return new UploadResponse(response);
    }

    public static final UploadResponse get500RangeNotParseable(ShareFile shareFile, UploadState uploadState) {
        HTTPResponse response = new HTTPResponse(500, "Requested Range Not Parseable", true);
        UploadResponse uploadResponse = new UploadResponse(response);
        UploadResponse.appendAltLocs(uploadResponse, shareFile, uploadState);
        return new UploadResponse(response);
    }

    public static final UploadResponse get503Queued(int queuePosition, int queueLength, int uploadLimit, int pollMin, int pollMax, ShareFile shareFile, UploadState uploadState) {
        HTTPResponse response = new HTTPResponse(503, "Remotely Queued", true);
        XQueueParameters xQueueParas = new XQueueParameters(queuePosition + 1, queueLength, uploadLimit, pollMin, pollMax);
        response.addHeader(new HTTPHeader("X-Queue", xQueueParas.buildHTTPString()));
        UploadResponse uploadResponse = new UploadResponse(response);
        UploadResponse.appendAltLocs(uploadResponse, shareFile, uploadState);
        return new UploadResponse(response);
    }

    public static final UploadResponse get503UploadLimitReachedForIP() {
        HTTPResponse response = new HTTPResponse(503, "Upload Limit Reached for IP", true);
        return new UploadResponse(response);
    }

    public static UploadResponse get503UploadLimitReached(ShareFile shareFile, UploadState uploadState) {
        HTTPResponse response = new HTTPResponse(503, "Upload Limit Reached", true);
        UploadResponse uploadResponse = new UploadResponse(response);
        UploadResponse.appendAltLocs(uploadResponse, shareFile, uploadState);
        return uploadResponse;
    }

    public static void appendAltLocs(UploadResponse response, ShareFile shareFile, UploadState uploadState) {
        if (shareFile.getAltLocCount() == 0) {
            return;
        }
        AltLocContainer altLocContainer = shareFile.getAltLocContainer();
        HTTPHeader header = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", uploadState.getHostAddress(), uploadState.getSendAltLocSet());
        if (header != null) {
            response.addHttpHeader(header);
        }
    }

    public static void addPushProxyResponseHeader(DestAddress[] pushProxyAddresses, UploadResponse response) {
        if (pushProxyAddresses == null) {
            return;
        }
        StringBuffer headerValue = new StringBuffer();
        int count = Math.min(4, pushProxyAddresses.length);
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                headerValue.append(",");
            }
            headerValue.append(pushProxyAddresses[i].getFullHostName());
        }
        if (headerValue.length() > 0) {
            HTTPHeader header = new HTTPHeader("X-Push-Proxy", headerValue.toString());
            response.addHttpHeader(header);
        }
    }
}

