/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import phex.host.Host;
import phex.msg.GUID;

public class GUIDRoutingTable {
    private static final int MAX_ROUTE_TABLE_SIZE = 50000;
    protected Map<GUID, Entry> currentMap;
    protected Map<GUID, Entry> lastMap;
    protected Map<Integer, Host> idToHostMap;
    protected Map<Host, Integer> hostToIdMap;
    private long lifetime;
    private long nextReplaceTime;
    private int nextId;

    public GUIDRoutingTable(long lifetime) {
        this.lifetime = lifetime;
        this.nextId = 0;
        this.currentMap = new TreeMap<GUID, Entry>(new GUID.GUIDComparator());
        this.lastMap = new TreeMap<GUID, Entry>(new GUID.GUIDComparator());
        this.idToHostMap = new HashMap<Integer, Host>();
        this.hostToIdMap = new HashMap<Host, Integer>();
    }

    public synchronized void addRouting(GUID guid, Host host) {
        this.checkForSwitch();
        if (!host.isConnected()) {
            return;
        }
        Integer id = this.getIdForHost(host);
        Entry entry = this.currentMap.remove(guid);
        if (entry == null && (entry = this.lastMap.remove(guid)) == null) {
            entry = this.createNewEntry();
        }
        entry.hostId = id;
        this.currentMap.put(guid, entry);
    }

    public synchronized boolean checkAndAddRouting(GUID guid, Host host) {
        this.checkForSwitch();
        if (!host.isConnected()) {
            return false;
        }
        if (!this.currentMap.containsKey(guid) && !this.lastMap.containsKey(guid)) {
            Integer id = this.getIdForHost(host);
            Entry entry = this.createNewEntry();
            entry.hostId = id;
            this.currentMap.put(guid, entry);
            return true;
        }
        return false;
    }

    public synchronized void removeHost(Host host) {
        Integer id = this.hostToIdMap.get(host);
        if (id != null) {
            this.idToHostMap.remove(id);
            this.hostToIdMap.remove(host);
        }
    }

    public synchronized Host findRouting(GUID guid) {
        Entry entry = this.currentMap.get(guid);
        if (entry == null) {
            entry = this.lastMap.get(guid);
        }
        if (entry != null) {
            return this.idToHostMap.get(entry.hostId);
        }
        return null;
    }

    protected void checkForSwitch() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextReplaceTime && this.currentMap.size() < 50000) {
            return;
        }
        this.lastMap.clear();
        Map<GUID, Entry> temp = this.lastMap;
        this.lastMap = this.currentMap;
        this.currentMap = temp;
        this.nextReplaceTime = currentTime + this.lifetime;
    }

    protected Integer getIdForHost(Host host) {
        Integer id = this.hostToIdMap.get(host);
        if (id != null) {
            return id;
        }
        id = this.nextId++;
        while (this.idToHostMap.get(id) != null) {
            id = this.nextId++;
        }
        this.idToHostMap.put(id, host);
        this.hostToIdMap.put(host, id);
        return id;
    }

    protected Entry createNewEntry() {
        return new Entry();
    }

    protected static class Entry {
        protected Integer hostId;

        protected Entry() {
        }
    }
}

