/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.Arrays;

public class SearchEngine {
    private static final int SKIP_TABLE_SIZE = 128;
    private char[] text;
    private char[] pattern;
    private int[] skipTable = new int[128];
    private int patternLength;
    private int textLength;

    public void setText(String aText, boolean isLowerCase) {
        this.textLength = aText.length();
        if (!isLowerCase) {
            this.text = new char[this.textLength];
            for (int i = 0; i < this.textLength; ++i) {
                this.text[i] = Character.toLowerCase(aText.charAt(i));
            }
        } else {
            this.text = aText.toCharArray();
        }
    }

    public void setText(char[] textArr, boolean isLowerCase) {
        this.textLength = textArr.length;
        if (!isLowerCase) {
            this.text = new char[this.textLength];
            for (int i = 0; i < this.textLength; ++i) {
                this.text[i] = Character.toLowerCase(textArr[i]);
            }
        } else {
            this.text = textArr;
        }
    }

    public void setPattern(String aPattern, boolean isLowerCase) {
        this.patternLength = aPattern.length();
        if (!isLowerCase) {
            this.pattern = new char[this.patternLength];
            for (int i = 0; i < this.patternLength; ++i) {
                this.pattern[i] = Character.toLowerCase(aPattern.charAt(i));
            }
        } else {
            this.pattern = aPattern.toCharArray();
        }
        this.initSkipTable();
    }

    private void initSkipTable() {
        Arrays.fill(this.skipTable, this.patternLength);
        for (int i = 0; i < this.patternLength - 1; ++i) {
            char patternChar = this.pattern[i];
            int val = this.patternLength - i - 1;
            int idx = patternChar % 128;
            this.skipTable[idx] = val;
        }
    }

    public boolean match() {
        int searchIndex;
        boolean found = false;
        int textIndex = searchIndex = this.patternLength - 1;
        block0: while (searchIndex >= 0 && textIndex < this.textLength) {
            searchIndex = this.patternLength - 1;
            int compareIndex = textIndex;
            while (true) {
                if (searchIndex < 0) {
                    found = true;
                    continue block0;
                }
                char patternChar = this.pattern[searchIndex];
                char textChar = this.text[compareIndex];
                if (patternChar != textChar) {
                    int skipTblIndex = this.text[textIndex] % 128;
                    textIndex += this.skipTable[skipTblIndex];
                    continue block0;
                }
                --searchIndex;
                --compareIndex;
            }
        }
        return found;
    }
}

