/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.Environment;
import phex.common.log.NLogger;
import phex.event.PhexEventService;
import phex.prefs.core.SubscriptionPrefs;
import phex.servent.Servent;
import phex.share.FileRescanRunner;
import phex.utils.IOUtil;

public class SubscriptionDownloader
extends TimerTask {
    public SubscriptionDownloader() {
        Environment.getInstance().scheduleTimerTask(this, 0L, 1209600000L);
    }

    public void run() {
        List subscriptionMagnets = this.loadSubscriptionList();
        Iterator iterator = subscriptionMagnets.iterator();
        FileRescanRunner.sync();
        while (iterator.hasNext()) {
            String uriStr = (String)iterator.next();
            if (SubscriptionPrefs.DownloadSilently.get().booleanValue()) {
                try {
                    this.createDownload(uriStr);
                }
                catch (URIException exp) {
                    NLogger.error(SubscriptionDownloader.class, exp.getMessage(), exp);
                }
                continue;
            }
            PhexEventService eventService = Servent.getInstance().getEventService();
            eventService.publish("phex:incoming/uri", uriStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadSubscriptionList() {
        String name = "/subscription.list";
        InputStream stream = SubscriptionDownloader.class.getResourceAsStream(name);
        if (stream == null) {
            List<String> subscriptionMagnets = SubscriptionPrefs.SubscriptionMagnets.get();
            List<String> list = SubscriptionPrefs.SubscriptionMagnets.get();
            if (subscriptionMagnets != null && SubscriptionPrefs.default_subscriptionMagnets != null) {
                subscriptionMagnets.add(SubscriptionPrefs.default_subscriptionMagnets);
            }
            return list;
        }
        try {
            InputStreamReader input = new InputStreamReader(stream);
            BufferedReader reader = new BufferedReader(input);
            ArrayList<String> list = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                list.add(line);
                line = reader.readLine();
            }
            List<String> oldSubscriptionMagnets = SubscriptionPrefs.SubscriptionMagnets.get();
            list.addAll(oldSubscriptionMagnets);
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (IOException exp) {
            NLogger.warn(SubscriptionDownloader.class, exp);
        }
        finally {
            IOUtil.closeQuietly(stream);
        }
        return Collections.EMPTY_LIST;
    }

    public void createDownload(String uriStr) throws URIException {
        if (uriStr.length() == 0) {
            return;
        }
        URI uri = new URI(uriStr, true);
        Servent.getInstance().getDownloadService().addFileToDownload(uri, true);
    }
}

