/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.File;
import java.io.IOException;
import java.security.Security;
import org.apache.commons.lang.SystemUtils;
import phex.common.Environment;
import phex.common.log.NLogger;
import phex.prefs.core.ProxyPrefs;
import phex.utils.FileUtils;
import phex.utils.StringUtils;

public class SystemProperties {
    public static final String PHEX_CONFIG_PATH_SYSPROP = "phex.config.path";
    private static volatile File phexConfigRoot;

    public static void updateProxyProperties() {
        System.setProperty("http.agent", Environment.getInstance().getPhexVendor());
        if (ProxyPrefs.UseHttp.get().booleanValue()) {
            System.setProperty("http.proxyHost", ProxyPrefs.HttpHost.get());
            System.setProperty("http.proxyPort", ProxyPrefs.HttpPort.get().toString());
        } else {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
        }
        System.setProperty("networkaddress.cache.ttl", "1800");
        Security.setProperty("networkaddress.cache.ttl", "1800");
    }

    @Deprecated
    private static File getOldPhexConfigRoot() {
        StringBuffer path = new StringBuffer(20);
        path.append(System.getProperty("user.home"));
        path.append(File.separator);
        if (File.separatorChar == '/') {
            path.append('.');
        }
        path.append("phex");
        File configRoot = new File(path.toString());
        return configRoot;
    }

    @Deprecated
    public static void migratePhexConfigRoot() {
        File oldRoot = SystemProperties.getOldPhexConfigRoot();
        if (oldRoot.exists()) {
            try {
                File newRoot = SystemProperties.getPhexConfigRoot();
                if (!oldRoot.equals(newRoot)) {
                    FileUtils.copyDirectory(oldRoot, newRoot, true);
                    FileUtils.deleteDirectory(oldRoot);
                }
            }
            catch (IOException exp) {
                NLogger.error(SystemProperties.class, exp, exp);
            }
        }
    }

    public static File getPhexConfigRoot() {
        if (phexConfigRoot == null) {
            phexConfigRoot = SystemProperties.initPhexConfigRoot();
        }
        if (phexConfigRoot.exists()) {
            if (!phexConfigRoot.isDirectory()) {
                throw new RuntimeException("Config location is not a directory: " + phexConfigRoot.getAbsolutePath());
            }
        } else {
            try {
                FileUtils.forceMkdir(phexConfigRoot);
            }
            catch (IOException exp) {
                throw new RuntimeException("Failed creating config directory: " + phexConfigRoot.getAbsolutePath());
            }
        }
        return phexConfigRoot;
    }

    private static File initPhexConfigRoot() {
        String tmpUserPath = System.getProperty(PHEX_CONFIG_PATH_SYSPROP);
        if (StringUtils.isEmpty(tmpUserPath)) {
            if (SystemUtils.IS_OS_WINDOWS) {
                String appDataEnv = System.getenv("APPDATA");
                if (StringUtils.isEmpty(appDataEnv)) {
                    tmpUserPath = System.getProperty("user.home") + File.separator + "Application Data";
                }
                tmpUserPath = appDataEnv + File.separator + "Phex" + File.separator;
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                tmpUserPath = System.getProperty("user.home") + File.separator + "Library" + File.separator + "Application Support";
                tmpUserPath = tmpUserPath + File.separator + "Phex" + File.separator;
            } else {
                tmpUserPath = System.getProperty("user.home") + File.separator + ".phex" + File.separator;
            }
        } else if (!tmpUserPath.endsWith(File.separator)) {
            tmpUserPath = tmpUserPath + File.separator;
        }
        File dir = new File(tmpUserPath);
        return dir;
    }
}

