/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import phex.utils.IOUtil;
import phex.utils.Localizer;

public class VendorCodes {
    public static final String UNKNOWN = "?";
    private static HashMap<String, String> vendorNames;

    public static String getVendorName(String vendorCode) {
        String name;
        if (vendorNames == null) {
            VendorCodes.initVendorNames();
        }
        if ((name = vendorNames.get(vendorCode)) == null) {
            return vendorCode;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initVendorNames() {
        HashMap<String, String> hashMap = vendorNames = new HashMap();
        synchronized (hashMap) {
            InputStream stream = Localizer.class.getResourceAsStream("/phex/resources/VendorCodes.properties");
            if (stream == null) {
                return;
            }
            stream = new BufferedInputStream(stream);
            Properties props = new Properties();
            try {
                props.load(stream);
                vendorNames.putAll(props);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtil.closeQuietly(stream);
            }
            return;
        }
    }
}

