/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.common.log.NLogger;
import phex.xml.sax.DPhex;
import phex.xml.sax.parser.PhexSAXHandler;

public class PhexXmlSaxParser {
    public static DPhex parsePhexXml(InputStream inStream) throws IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = spf.newSAXParser();
            DPhex dPhex = new DPhex();
            saxParser.parse(new InputSource(inStream), (DefaultHandler)new PhexSAXHandler(dPhex, saxParser));
            return dPhex;
        }
        catch (ParserConfigurationException exp) {
            NLogger.error(PhexXmlSaxParser.class, exp, exp);
            throw new IOException("Parsing Phex XML failed.");
        }
        catch (SAXException exp) {
            NLogger.error(PhexXmlSaxParser.class, exp, exp);
            throw new IOException("Parsing Phex XML failed.");
        }
    }
}

