/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.downloads;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.common.log.NLogger;
import phex.xml.sax.downloads.DDownloadCandidate;

public class DownloadCandidateHandler
extends DefaultHandler {
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DDownloadCandidate downloadCandidate;
    private DefaultHandler parent;

    public DownloadCandidateHandler(DDownloadCandidate downloadCandidate, DefaultHandler parent, SAXParser parser) {
        this.downloadCandidate = downloadCandidate;
        this.parser = parser;
        this.parent = parent;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("guid")) {
            this.downloadCandidate.setGuid(this.text.toString());
        } else if (qName.equals("fileindex")) {
            try {
                this.downloadCandidate.setFileIndex(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadCandidateHandler.class, exp, exp);
            }
        } else if (qName.equals("last-connect")) {
            try {
                this.downloadCandidate.setLastConnectionTime(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadCandidateHandler.class, exp, exp);
            }
        } else if (qName.equals("filename")) {
            this.downloadCandidate.setFileName(this.text.toString());
        } else if (qName.equals("download-uri")) {
            this.downloadCandidate.setDownloadUri(this.text.toString());
        } else if (qName.equals("resource-urn")) {
            this.downloadCandidate.setResourceUrn(this.text.toString());
        } else if (qName.equals("remotehost")) {
            this.downloadCandidate.setRemoteHost(this.text.toString());
        } else if (qName.equals("connectionFailedRepetition")) {
            try {
                this.downloadCandidate.setConnectionFailedRepetition(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadCandidateHandler.class, exp, exp);
            }
        } else if (qName.equals("vendor")) {
            this.downloadCandidate.setVendor(this.text.toString());
        } else if (qName.equals("isPushNeeded")) {
            this.downloadCandidate.setPushNeeded(Boolean.getBoolean(this.text.toString()));
        } else if (qName.equals("isThexSupported")) {
            this.downloadCandidate.setThexSupported(Boolean.getBoolean(this.text.toString()));
        } else if (qName.equals("isChatSupported")) {
            this.downloadCandidate.setChatSupported(Boolean.getBoolean(this.text.toString()));
        } else if (qName.equals("candidate")) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

