/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.rules;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.xml.sax.parser.rules.AndConcatConditionHandler;
import phex.xml.sax.parser.rules.ConsequencesListHandler;
import phex.xml.sax.rules.DAndConcatCondition;
import phex.xml.sax.rules.DConsequencesList;
import phex.xml.sax.rules.DSearchRule;

public class SearchRuleHandler
extends DefaultHandler {
    public static final String ELEMENT_NAME = "search-rule";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DSearchRule searchRule;
    private DefaultHandler parent;

    public SearchRuleHandler(DSearchRule searchRule, Attributes attributes, DefaultHandler parent, SAXParser parser) {
        this.searchRule = searchRule;
        this.parser = parser;
        this.parent = parent;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
        if (qName.equals("and-condition")) {
            DAndConcatCondition condition = new DAndConcatCondition();
            this.searchRule.setAndConcatCondition(condition);
            AndConcatConditionHandler handler = new AndConcatConditionHandler(condition, attributes, (DefaultHandler)this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("consequences-list")) {
            DConsequencesList consequencesList = new DConsequencesList();
            this.searchRule.setConsequencesList(consequencesList);
            ConsequencesListHandler handler = new ConsequencesListHandler(consequencesList, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("name")) {
            this.searchRule.setName(this.text.toString());
        } else if (qName.equals("description")) {
            this.searchRule.setDescription(this.text.toString());
        } else if (qName.equals("id")) {
            this.searchRule.setId(this.text.toString());
        } else if (qName.equals("permanently-enabled")) {
            this.searchRule.setPermanentlyEnabled(Boolean.valueOf(this.text.toString()));
        } else if (qName.equals(ELEMENT_NAME)) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

