/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.Strings;

public class PGPSignatureGenerator {
    private int keyAlgorithm;
    private int hashAlgorithm;
    private PGPPrivateKey privKey;
    private Signature sig;
    private MessageDigest dig;
    private int signatureType;
    private byte lastb;
    SignatureSubpacket[] unhashed = new SignatureSubpacket[0];
    SignatureSubpacket[] hashed = new SignatureSubpacket[0];

    public PGPSignatureGenerator(int n, int n2, String string) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this(n, string, n2, string);
    }

    public PGPSignatureGenerator(int n, String string, int n2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, PGPException {
        this.keyAlgorithm = n;
        this.hashAlgorithm = n2;
        this.dig = PGPUtil.getDigestInstance(PGPUtil.getDigestName(n2), string2);
        this.sig = Signature.getInstance(PGPUtil.getSignatureName(n, n2), string);
    }

    public void initSign(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        this.initSign(n, pGPPrivateKey, null);
    }

    public void initSign(int n, PGPPrivateKey pGPPrivateKey, SecureRandom secureRandom) throws PGPException {
        this.privKey = pGPPrivateKey;
        this.signatureType = n;
        try {
            if (secureRandom == null) {
                this.sig.initSign(pGPPrivateKey.getKey());
            } else {
                this.sig.initSign(pGPPrivateKey.getKey(), secureRandom);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("invalid key.", invalidKeyException);
        }
        this.dig.reset();
        this.lastb = 0;
    }

    public void update(byte by) throws SignatureException {
        if (this.signatureType == 1) {
            if (by == 13) {
                this.sig.update((byte)13);
                this.sig.update((byte)10);
                this.dig.update((byte)13);
                this.dig.update((byte)10);
            } else if (by == 10) {
                if (this.lastb != 13) {
                    this.sig.update((byte)13);
                    this.sig.update((byte)10);
                    this.dig.update((byte)13);
                    this.dig.update((byte)10);
                }
            } else {
                this.sig.update(by);
                this.dig.update(by);
            }
            this.lastb = by;
        } else {
            this.sig.update(by);
            this.dig.update(by);
        }
    }

    public void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.signatureType == 1) {
            int n3 = n + n2;
            for (int i = n; i != n3; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.sig.update(byArray, n, n2);
            this.dig.update(byArray, n, n2);
        }
    }

    public void setHashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.hashed = new SignatureSubpacket[0];
            return;
        }
        this.hashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public void setUnhashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.unhashed = new SignatureSubpacket[0];
            return;
        }
        this.unhashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public PGPOnePassSignature generateOnePassVersion(boolean bl) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.signatureType, this.hashAlgorithm, this.keyAlgorithm, this.privKey.getKeyID(), bl));
    }

    public PGPSignature generate() throws PGPException, SignatureException {
        byte[] byArray;
        Object object;
        int n = 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SignatureSubpacket[] signatureSubpacketArray = !this.packetPresent(this.hashed, 2) ? this.insertSubpacket(this.hashed, new SignatureCreationTime(false, new Date())) : this.hashed;
        SignatureSubpacket[] signatureSubpacketArray2 = !this.packetPresent(this.hashed, 16) && !this.packetPresent(this.unhashed, 16) ? this.insertSubpacket(this.unhashed, new IssuerKeyID(false, this.privKey.getKeyID())) : this.unhashed;
        try {
            byteArrayOutputStream.write((byte)n);
            byteArrayOutputStream.write((byte)this.signatureType);
            byteArrayOutputStream.write((byte)this.keyAlgorithm);
            byteArrayOutputStream.write((byte)this.hashAlgorithm);
            object = new ByteArrayOutputStream();
            for (int i = 0; i != signatureSubpacketArray.length; ++i) {
                signatureSubpacketArray[i].encode((OutputStream)object);
            }
            byArray = ((ByteArrayOutputStream)object).toByteArray();
            byteArrayOutputStream.write((byte)(byArray.length >> 8));
            byteArrayOutputStream.write((byte)byArray.length);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new PGPException("exception encoding hashed data.", iOException);
        }
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.write((byte)n);
        byteArrayOutputStream.write(-1);
        byteArrayOutputStream.write((byte)(((Object)object).length >> 24));
        byteArrayOutputStream.write((byte)(((Object)object).length >> 16));
        byteArrayOutputStream.write((byte)(((Object)object).length >> 8));
        byteArrayOutputStream.write((byte)((Object)object).length);
        byArray = byteArrayOutputStream.toByteArray();
        this.sig.update(byArray);
        this.dig.update(byArray);
        MPInteger[] mPIntegerArray = this.keyAlgorithm == 3 || this.keyAlgorithm == 1 ? new MPInteger[]{new MPInteger(new BigInteger(1, this.sig.sign()))} : PGPUtil.dsaSigToMpi(this.sig.sign());
        byte[] byArray2 = this.dig.digest();
        byte[] byArray3 = new byte[]{byArray2[0], byArray2[1]};
        return new PGPSignature(new SignaturePacket(this.signatureType, this.privKey.getKeyID(), this.keyAlgorithm, this.hashAlgorithm, signatureSubpacketArray, signatureSubpacketArray2, byArray3, mPIntegerArray));
    }

    public PGPSignature generateCertification(String string, PGPPublicKey pGPPublicKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithIdData(180, Strings.toByteArray((String)string));
        return this.generate();
    }

    public PGPSignature generateCertification(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPPublicKey pGPPublicKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            UserAttributeSubpacket[] userAttributeSubpacketArray = pGPUserAttributeSubpacketVector.toSubpacketArray();
            for (int i = 0; i != userAttributeSubpacketArray.length; ++i) {
                userAttributeSubpacketArray[i].encode(byteArrayOutputStream);
            }
            this.updateWithIdData(209, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new PGPException("cannot encode subpacket array", iOException);
        }
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws SignatureException, PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithPublicKey(pGPPublicKey2);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey) throws SignatureException, PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        return this.generate();
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        byte[] byArray;
        try {
            byArray = pGPPublicKey.publicPk.getEncodedContents();
        }
        catch (IOException iOException) {
            throw new PGPException("exception preparing key.", iOException);
        }
        return byArray;
    }

    private boolean packetPresent(SignatureSubpacket[] signatureSubpacketArray, int n) {
        for (int i = 0; i != signatureSubpacketArray.length; ++i) {
            if (signatureSubpacketArray[i].getType() != n) continue;
            return true;
        }
        return false;
    }

    private SignatureSubpacket[] insertSubpacket(SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket signatureSubpacket) {
        SignatureSubpacket[] signatureSubpacketArray2 = new SignatureSubpacket[signatureSubpacketArray.length + 1];
        signatureSubpacketArray2[0] = signatureSubpacket;
        System.arraycopy(signatureSubpacketArray, 0, signatureSubpacketArray2, 1, signatureSubpacketArray.length);
        return signatureSubpacketArray2;
    }

    private void updateWithIdData(int n, byte[] byArray) throws SignatureException {
        this.update((byte)n);
        this.update((byte)(byArray.length >> 24));
        this.update((byte)(byArray.length >> 16));
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
    }

    private void updateWithPublicKey(PGPPublicKey pGPPublicKey) throws PGPException, SignatureException {
        byte[] byArray = this.getEncodedPublicKey(pGPPublicKey);
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
    }
}

