/*  PhysCalc header file
    Copyright (C) 1990  Marty White

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

	/*----- DEFINES -----*/

#ifdef __TINY__
#error This program requires more memory than the tiny model allows!
#endif

#define VERSION "2.4"       /* Version number */
#define TRACE

#define NAMELEN		60		/* standard maximum name length */
#define SMALLBUF	(2*80)	/* standard small buffer size */
#define LARGEBUF	(4*80)	/* standard large buffer size */

#define MAXDIM		15	/* Maximum number of dimensions */

#define MTHERR	1	/* division by 0, square root of (-1) */
#define PARERR	2	/* unbalanced parenthesis */
#define SYNERR	3	/* syntax error */
#define UFNERR	4	/* unknown function */
#define UVRERR	5	/* unknown/uncalculable variable */
#define TYPERR	6	/* Wrong type */
#define MEMERR	7	/* Non-fatal out of memory */

#define SNODE 1 /* String node */
#define INODE 2 /* long Integer node */
#define FNODE 3 /* Fraction node */
#define DNODE 4 /* Double node */
#define NNODE 5 /* Dimensional Number node */
#define LNODE 6 /* List (function) node */

#define OPS   17	/* number of operators */
#define FUNCS 10	/* number of functions */
#define OPLEN 5		/* max length + \0 of operators */
#define FNLEN 11	/* max length + \0 of built in function names */
#define FUNCS2 3

	/*--- Taken from MSTD.H (my standard header file) ---*/
#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif
#define isname(c)		(isalnum(c) || c=='_' || c=='.')
#define skipspc(s)		while (isspace(*(s))) (s)++

#define LOCAL static
#define IMPORT extern
#define EXPORT

	/*----- STRUCTURE DECLARATIONS -----*/

typedef struct d_num {		/* Structure for holding a dimensional number */
	double num;			/* scalar value */
	int di[ MAXDIM ];	/* dimensions */
} DNUM;

struct fractstruct {		/* Fraction structure */
	int numer,denom;
};

typedef struct nodestruct {	/* Holds multiple var types */
	int type;
	union {
		char str[1];				/* String */
		double dbl;					/* double number */
		long lng;					/* long integer */
		struct fractstruct frt;		/* Fraction */
		struct d_num dmn;
		struct nodestruct *list[1];	/* List of ptrs to nodes */
	} *data;	/* Pointer to the above union */
} NODE,*NODEP;	/* sizeof(NODE) should be 4 bytes */

struct dimstruct {		/* Holds a dimension definition */
	struct dimstruct *next;		/* ptr to next in list */
	char *name;					/* dimension name */
	int dimension[ MAXDIM ];	/* dimensionality */
};

struct varstruct {	/* Holds a user-variable */
	struct varstruct *next;
	char *name;
	NODEP value;
	int rflag;		/* flag to prevent infinite recursion */
};

struct ufstruct {	/* Holds a user-function */
	struct ufstruct *next;
	char *name;
	NODEP dummy;	/* List-node of dummy strings */
	NODEP value;
};
