/*  PhysCalc header file
    Declares variables and functions

    Copyright (C) 1990  Marty White

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

	/*--- Taken from MARTYLIB.H (my library of c routines) ---*/

#ifndef __TURBOC__
IMPORT void		trimspc(),scan_symbol();
#else
IMPORT void trimspc(char *s),scan_symbol(char const **s,char *t);
#endif

	/*----- STRUCTURE DECLARATIONS -----*/

IMPORT struct dimstruct *dimension_list, *last_fund_dim, *last_compound_dim;
IMPORT struct varstruct *var;
IMPORT struct ufstruct *userfunc;

	/*----- GLOBAL VARIABLES -----*/

IMPORT char *helptext;			/* pointer to help text */
IMPORT int error;		/* global error flag (values listed above) */
IMPORT int echo;
IMPORT int nodecount;	/* Count of allocated nodes */
IMPORT int defaultbase;
#ifdef TRACE
IMPORT int trace;		/* Tracing flag: 0=no trace, 1=educational trace */
#endif


	/* Built in Operator/Function arrays */
#ifndef __PROTOTYPES__
IMPORT double (*do_funct[FUNCS])();		/* array of ptrs to built in func's */
#else
IMPORT double (*do_funct[FUNCS])(double parm);
#endif
IMPORT char const functions[FUNCS][FNLEN];	/* array of built in function names */
IMPORT char const operator[OPS][OPLEN];		/* array of built in operator names */
IMPORT int const priority[OPS];				/* priority of built in operators */
IMPORT int const optype[OPS];				/* prefix/infix/postfix indicator */
IMPORT NODEP (*do_op[OPS])();				/* array of ptrs to operators */
IMPORT char const functions2[FUNCS2][FNLEN];
IMPORT NODEP (*do_funct2[FUNCS2])();

	/*----- FUNCTION DECLARATIONS -----*/

#ifndef __TURBOC__
/* Main */
IMPORT void do_cmd();
IMPORT int pause_for_user();
IMPORT NODEP solve();
IMPORT void output_list();

/* Solv */
IMPORT NODEP parse(),evaluate();
IMPORT void printexpr(),fprintexpr();
IMPORT void fraction_cmd();

/* Conv */
IMPORT void erasednum(),copydnum(),querry(),
			showdims(),showunits(),show_all_units(),generate_unit(),
			printanswer(),define_dimension(),define_unit(),save_data(),
			load_data(),remember_old();
IMPORT int evaldim(),has_dims(),check_equ_dim();
IMPORT struct dimstruct *dimension_number();

/* Node */
IMPORT NODEP allocsnode(),allocdnode(),alloclnode(),
	allocinode(),allocfnode(),allocnnode(),linknode(),unlinknode(),
	copynode(),alloclnode1(),alloclnode2();
IMPORT char *reallocnode();
IMPORT void initnodes(),deallocnode(),bytecopy();
IMPORT int cmpnode(),nodesize();
IMPORT void out_of_memory();

/* Oper */
IMPORT int number();
IMPORT void simplify_frt(),force_same_type(),factor();

#else		/* use prototypes to improve error checking */

/* Main */
IMPORT void do_cmd(char *buf);
IMPORT int pause_for_user(void);
IMPORT NODEP solve(char const **s);
IMPORT void printerror(void);
IMPORT void output_list(
	FILE *fp,
	struct varstruct const *vars,
	struct ufstruct const *funcs,
	int verbose);

/* Solv */
IMPORT NODEP parse(char const **s), evaluate(NODEP n);
IMPORT void printexpr(NODEP n),fprintexpr(FILE *fp, NODEP n);
IMPORT void fraction_cmd(const char *s);

/* Conv */
IMPORT void load_data(char const *s),
			erasednum(DNUM *n),
			copydnum(DNUM *d, DNUM const *s),
			querry(char const *s),
			showdims(DNUM const *n),
			showunits(DNUM const *n),
			show_all_units(void),
			generate_unit(DNUM const *n, char *s),
			printanswer(NODEP n, char const *s),
			define_dimension(char const *s),
			define_unit(char const *s),
			save_data(char const *fname, int all),
			remember_old(void);
IMPORT int	evaldim(char const **s, int io, DNUM *n),
			has_dims(DNUM const *n),
			check_equ_dim(DNUM const *a, DNUM const *b);
IMPORT struct dimstruct *dimension_number(int i);

/* Node */
IMPORT NODEP	allocsnode(char const *s),
				allocdnode(double x),
				alloclnode(int t),
				allocinode(long i),
				allocfnode(int num, int den),
				allocnnode(void),
				linknode(NODEP n1, NODEP n2),
				unlinknode(NODEP n1, NODEP n2),
				copynode(NODEP n),
				alloclnode1(int t, NODEP n1),
				alloclnode2(int t, NODEP n1, NODEP n2);
IMPORT char *	reallocnode(NODEP n, int t, int bytes);
IMPORT void 	initnodes(void),
				deallocnode(NODEP n),
				bytecopy(VOID *dst, VOID const *src, int bytes);
IMPORT int		cmpnode(NODEP n1, NODEP n2),
				nodesize(NODEP n);
IMPORT void 	out_of_memory(char const *s);

/* Oper */
IMPORT int number(NODEP n);
IMPORT void simplify_frt(NODEP n),
	force_same_type(NODEP x, NODEP y),
	factor(char const *s);

#endif
