/*  Taken from my library of C functions
    Copyright (C) 1990  Marty White

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdio.h>
#include "compiler.h"

#ifdef __STDHEADERS__
#include <ctype.h>
#include <string.h>
#endif

#include "physcalc.h"
#include "physdecl.h"

/* Convert CR,LF,FF & tab to spaces, remove leading & trailing whitespace,
and eliminate multiple whitespaces. The passed string is altered. */

EXPORT void trimspc(s)
char *s;
{
	char *t,*u;

	t = u = s;
	while (*u) {
		while (isspace(*u) && *u)
			u++;
		while (!isspace(*u) && *u)
			*(t++) = *(u++);
		if (*u)
			*(t++) = ' ';
	}
	*t='\0';
	while ( ((--t) >= s) && isspace(*t))
		*t = '\0';
}

EXPORT void scan_symbol(s,t)	/* copy symbol or name at *s into t, advance *s */
char const **s;
char *t;
{
	char c;

	skipspc(*s);
	if (**s) {
		c = *t++ = *(*s)++;
		if (isname(c))
			while (isname(**s))
				*t++ = *(*s)++;
	}
	*t = '\0';
}

#ifdef __GNUC__

void strupr(s)
char *s;
{
    while (*s) {
        *s = toupper(*s);
        ++s;
    }
}

#endif

