/*
 * ProgressBar.java
 */

package pipe.gui.widgets;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 *
 * @author  Pere
 */
public class ProgressBar 
        extends javax.swing.JFrame 
        implements Runnable {
   
   private boolean end = false;
   
   
   /** Creates new form NewJFrame */
   private ProgressBar() {
      super();
      initComponents();
      setLocation(500, 500);
      addMouseListener(new MouseAdapter() {
         public void mousePressed(MouseEvent e) {
            setVisible(false);
            dispose();
            end = true;
         }
      });
      setVisible(true);
      
   }
   
   
   public ProgressBar(String name) {
      this();
      label.setText("Loading " + name + "..." );
      progressBar.setIndeterminate(true);
   }
   
   
   public ProgressBar(String name, int max) {
      this();
      label.setText("Loading " + name + "..." );
      progressBar.setIndeterminate(false);
      progressBar.setMaximum(max);
   }   
   
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
   private void initComponents() {
      java.awt.GridBagConstraints gridBagConstraints;

      progressBar = new javax.swing.JProgressBar();
      label = new javax.swing.JLabel();

      getContentPane().setLayout(new java.awt.GridBagLayout());

      setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
      setTitle("Loading Petri Net");
      setAlwaysOnTop(true);
      setResizable(false);
      setUndecorated(true);
      progressBar.setFocusable(false);
      progressBar.setMaximumSize(new java.awt.Dimension(400, 20));
      progressBar.setMinimumSize(new java.awt.Dimension(400, 20));
      progressBar.setPreferredSize(new java.awt.Dimension(400, 20));
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.insets = new java.awt.Insets(0, 13, 13, 13);
      getContentPane().add(progressBar, gridBagConstraints);

      label.setText("Loading...");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.insets = new java.awt.Insets(8, 13, 0, 14);
      getContentPane().add(label, gridBagConstraints);

      pack();
   }// </editor-fold>//GEN-END:initComponents

   
   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JLabel label;
   private javax.swing.JProgressBar progressBar;
   // End of variables declaration//GEN-END:variables
   private int i = 0;
   
   public void setProgressBar(int max) {
      progressBar.setIndeterminate(false);
      progressBar.setMaximum(max);
   }
   
   
   public void step() {
      progressBar.setValue(++i);
      if (i >= progressBar.getMaximum()) {
         end = true;
      }
   }

   
   public void exit() {
      setVisible(false);
      dispose();  
      end = true;
   }

   
   public void run() {
      this.setVisible(true);
      Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
      
      do {
         //System.out.println("running");
         
      } while (!end);
        System.out.println("fora");
      try {
         Thread.currentThread().sleep(300);      
      } catch (InterruptedException ex) {
         ex.printStackTrace();
      }      
      exit();
   }

}
