package pipe.gui.widgets;

import java.awt.Color;
import javax.swing.JRootPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import pipe.dataLayer.DataLayer;
import pipe.dataLayer.MarkingParameter;
import pipe.dataLayer.Place;
import pipe.gui.GuiView;

/**
 *
 * @author  pere
 */
public class PlaceEditorPanel 
        extends javax.swing.JPanel {
   
   Place place;
   Boolean attributesVisible;
   Integer capacity;
   Integer marking;
   String name;
   MarkingParameter mParameter;
   DataLayer pnmlData;
   GuiView view;
   JRootPane rootPane;
   
   
   /**
    * Creates new form PlaceEditor
    */
   public PlaceEditorPanel(JRootPane _rootPane, Place _place, 
           DataLayer _pnmlData, GuiView _view) {
      place = _place;
      pnmlData = _pnmlData;
      view = _view;
      attributesVisible = place.getAttributesVisible();
      capacity = place.getCapacity();
      marking = place.getCurrentMarking();
      name = place.getName();
      mParameter = place.getMarkingParameter();
      rootPane = _rootPane;
      
      initComponents();
      rootPane.setDefaultButton(okButton);

      MarkingParameter[] markings = pnmlData.getMarkingParameters();
      if (markings.length > 0) {
         markingComboBox.addItem("");
         for (int i = 0; i < markings.length; i++) {
            markingComboBox.addItem(markings[i]);
         }
      } else {
         markingComboBox.setEnabled(false);
      }  
      
      if (mParameter != null){
         for (int i = 1; i < markingComboBox.getItemCount(); i++) {
            if (mParameter == (MarkingParameter)markingComboBox.getItemAt(i)){
               markingComboBox.setSelectedIndex(i);
            }
         }
      }
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
   private void initComponents() {
      java.awt.GridBagConstraints gridBagConstraints;

      placeEditorPanel = new javax.swing.JPanel();
      nameLabel = new javax.swing.JLabel();
      nameTextField = new javax.swing.JTextField();
      markingLabel = new javax.swing.JLabel();
      capacityLabel = new javax.swing.JLabel();
      markingSpinner = new javax.swing.JSpinner();
      markingSpinner.setModel(new SpinnerNumberModel(place.getCurrentMarking(),0,Integer.MAX_VALUE,1));

      capacitySpinner = new javax.swing.JSpinner();
      capacitySpinner.setModel(new SpinnerNumberModel(place.getCapacity(),0,Integer.MAX_VALUE,1));
      attributesCheckBox = new javax.swing.JCheckBox();
      markingComboBox = new javax.swing.JComboBox();
      capacity0Label = new javax.swing.JLabel();
      buttonPanel = new javax.swing.JPanel();
      okButton = new javax.swing.JButton();
      cancelButton = new javax.swing.JButton();

      setLayout(new java.awt.GridBagLayout());

      placeEditorPanel.setLayout(new java.awt.GridBagLayout());

      placeEditorPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Place Editor"));
      nameLabel.setText("Name:");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      placeEditorPanel.add(nameLabel, gridBagConstraints);

      nameTextField.setText(place.getName());
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      placeEditorPanel.add(nameTextField, gridBagConstraints);

      markingLabel.setText("Marking:");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      placeEditorPanel.add(markingLabel, gridBagConstraints);

      capacityLabel.setText("Capacity:");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 2;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      placeEditorPanel.add(capacityLabel, gridBagConstraints);

      markingSpinner.setMinimumSize(new java.awt.Dimension(50, 20));
      markingSpinner.setPreferredSize(new java.awt.Dimension(50, 20));
      markingSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
         public void stateChanged(javax.swing.event.ChangeEvent evt) {
            markingSpinnerStateChanged(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      placeEditorPanel.add(markingSpinner, gridBagConstraints);

      capacitySpinner.setMinimumSize(new java.awt.Dimension(50, 20));
      capacitySpinner.setPreferredSize(new java.awt.Dimension(50, 20));
      capacitySpinner.addChangeListener(new javax.swing.event.ChangeListener() {
         public void stateChanged(javax.swing.event.ChangeEvent evt) {
            capacitySpinnerStateChanged(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 2;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      placeEditorPanel.add(capacitySpinner, gridBagConstraints);

      attributesCheckBox.setSelected(place.getAttributesVisible());
      attributesCheckBox.setText("Show place attributes");
      attributesCheckBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
      attributesCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 3;
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      placeEditorPanel.add(attributesCheckBox, gridBagConstraints);

      markingComboBox.setMaximumSize(new java.awt.Dimension(162, 22));
      markingComboBox.setMinimumSize(new java.awt.Dimension(162, 22));
      markingComboBox.setPreferredSize(new java.awt.Dimension(162, 22));
      markingComboBox.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            markingComboBoxActionPerformed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      placeEditorPanel.add(markingComboBox, gridBagConstraints);

      capacity0Label.setText("(no capacity restriction)    ");
      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 2;
      gridBagConstraints.gridy = 2;
      gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
      placeEditorPanel.add(capacity0Label, gridBagConstraints);

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridwidth = 2;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
      gridBagConstraints.insets = new java.awt.Insets(5, 8, 5, 8);
      add(placeEditorPanel, gridBagConstraints);

      buttonPanel.setLayout(new java.awt.GridBagLayout());

      okButton.setText("OK");
      okButton.setMaximumSize(new java.awt.Dimension(75, 25));
      okButton.setMinimumSize(new java.awt.Dimension(75, 25));
      okButton.setPreferredSize(new java.awt.Dimension(75, 25));
      okButton.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            okButtonHandler(evt);
         }
      });
      okButton.addKeyListener(new java.awt.event.KeyAdapter() {
         public void keyPressed(java.awt.event.KeyEvent evt) {
            okButtonKeyPressed(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 0;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
      gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 9);
      buttonPanel.add(okButton, gridBagConstraints);

      cancelButton.setText("Cancel");
      cancelButton.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            cancelButtonHandler(evt);
         }
      });

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 0;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
      gridBagConstraints.insets = new java.awt.Insets(8, 0, 8, 10);
      buttonPanel.add(cancelButton, gridBagConstraints);

      gridBagConstraints = new java.awt.GridBagConstraints();
      gridBagConstraints.gridx = 1;
      gridBagConstraints.gridy = 1;
      gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
      add(buttonPanel, gridBagConstraints);

   }// </editor-fold>//GEN-END:initComponents

   private void markingSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_markingSpinnerStateChanged
      Integer capacity = (Integer)capacitySpinner.getValue();

      if (capacity > 0) {
         if ((Integer)markingSpinner.getValue() > capacity) {
            markingSpinner.setValue(capacity);
         }
      }
      if ((markingComboBox.getSelectedIndex() > 0) &&
         (((MarkingParameter)markingComboBox.getSelectedItem()).getValue() 
                 != markingSpinner.getValue())){
         markingComboBox.setSelectedIndex(0);
      }
   }//GEN-LAST:event_markingSpinnerStateChanged
   
   ChangeListener changeListener = new javax.swing.event.ChangeListener() {
      public void stateChanged(javax.swing.event.ChangeEvent evt) {
         JSpinner spinner = (JSpinner)evt.getSource();
         JSpinner.NumberEditor numberEditor =
                 ((JSpinner.NumberEditor)spinner.getEditor());
         numberEditor.getTextField().setBackground(new Color(255,255,255));
         spinner.removeChangeListener(this);
      }
   };   

   
   private void markingComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_markingComboBoxActionPerformed
      Integer index = markingComboBox.getSelectedIndex();

      if (index > 0){
         Integer value = ((MarkingParameter)markingComboBox.getItemAt(index)).getValue();
         markingSpinner.setValue(value);
      } 
   }//GEN-LAST:event_markingComboBoxActionPerformed

   
   private void okButtonKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_okButtonKeyPressed
      if (evt.getKeyCode() == java.awt.event.KeyEvent.VK_ENTER) {
         doOK();
      }
   }//GEN-LAST:event_okButtonKeyPressed

   private void doOK(){
      Integer newCapacity = capacity;

      try {
         newCapacity = (Integer)capacitySpinner.getValue();
      } catch (Exception e) {
         JSpinner.NumberEditor numberEditor =
                 ((JSpinner.NumberEditor)capacitySpinner.getEditor());
         numberEditor.getTextField().setBackground(new Color(255,0,0));
         capacitySpinner.addChangeListener(changeListener);
         capacitySpinner.requestFocusInWindow();
         return;
      }
      
      Integer newMarking = marking;
      try {
         newMarking = (Integer)markingSpinner.getValue();
      } catch (Exception e){
         JSpinner.NumberEditor numberEditor =
                 ((JSpinner.NumberEditor)markingSpinner.getEditor());
         numberEditor.getTextField().setBackground(new Color(255,0,0));
         markingSpinner.addChangeListener(changeListener);
         markingSpinner.requestFocusInWindow();
         return;
      }      
      
      ///
      if ((newCapacity > 0) && (newCapacity < newMarking)){
         System.out.println("problema!");
         return;
      }
      
      view.getUndoManager().newEdit(); // new "transaction""
      
      String newName = nameTextField.getText();
      if (!newName.equals(name)){
         view.getUndoManager().addEdit(place.setPNObjectName(newName));
      }
      
      if (newCapacity != capacity) {
         view.getUndoManager().addEdit(place.setCapacity(newCapacity));
      }        
      
      if (markingComboBox.getSelectedIndex() >0) {
         // There's a marking parameter selected
         MarkingParameter parameter = 
                 (MarkingParameter)markingComboBox.getSelectedItem() ;
         if (parameter != mParameter){

            if (mParameter != null) {
               // The marking parameter has been changed
               view.getUndoManager().addEdit(place.changeMarkingParameter(
                        (MarkingParameter)markingComboBox.getSelectedItem()));
            } else {
               //The marking parameter has been changed
               view.getUndoManager().addEdit(place.setMarkingParameter(
                       (MarkingParameter)markingComboBox.getSelectedItem()));
            }
         }
      } else {
         // There is no marking parameter selected
         if (mParameter != null) {
            // The rate parameter has been changed
            view.getUndoManager().addEdit(place.clearMarkingParameter());
         }
         if (newMarking != marking) {
            view.getUndoManager().addEdit(place.setCurrentMarking(newMarking));            
         }
      }
      
      if (attributesVisible != attributesCheckBox.isSelected()){
         place.toggleAttributesVisible();
      }    
      place.repaint();
      exit();
   }
   
   
   private void okButtonHandler(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonHandler
      doOK();
   }//GEN-LAST:event_okButtonHandler

   
   private void exit() {
      rootPane.getParent().setVisible(false);
   }
   
   
   private void cancelButtonHandler(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonHandler
      exit();
   }//GEN-LAST:event_cancelButtonHandler

   
   private void capacitySpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_capacitySpinnerStateChanged
      Integer marking = (Integer)markingSpinner.getValue();
      Integer capacity = (Integer)capacitySpinner.getValue();
      
      if (capacity > 0) {
         capacity0Label.setVisible(false);
         if (marking > capacity) {
            markingSpinner.setValue(capacity);
         }
      } else {
         capacity0Label.setVisible(true);
      }
   }//GEN-LAST:event_capacitySpinnerStateChanged
      
   
   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JCheckBox attributesCheckBox;
   private javax.swing.JPanel buttonPanel;
   private javax.swing.JButton cancelButton;
   private javax.swing.JLabel capacity0Label;
   private javax.swing.JLabel capacityLabel;
   private javax.swing.JSpinner capacitySpinner;
   private javax.swing.JComboBox markingComboBox;
   private javax.swing.JLabel markingLabel;
   private javax.swing.JSpinner markingSpinner;
   private javax.swing.JLabel nameLabel;
   private javax.swing.JTextField nameTextField;
   private javax.swing.JButton okButton;
   private javax.swing.JPanel placeEditorPanel;
   // End of variables declaration//GEN-END:variables

}
