<?php
// &Egrave;esky (Czech) (UTF-8)

//the above line is needed so that pivot knows how to display it in the user info.
//it also needs to be on the 2rd line.

// Czech translation of Pivot lang file
// Created by Adam Covex Přibyl (covex@lowlevel.cz)
// and Josef Klimosz <ok2wo@atlas.cz>
// http://www.pivotlog.net

// version: 1.3 covex
// version: 1.3.2 ok2wo
// version: 1.3.3 covex update to 1.14beta
// version: 1.4 covex update to 1.20b3
// version: 1.5 covex update to 1.22
// version: 1.6 covex update to 1.40

//
// Latest Update: Pivot (www.pivotlog.net) 06.10.2006
//
// allow for different encoding for non-western languages
$encoding="utf8";
$langname="cs";


//        General        \\
$lang['general'] = array (
    'yes' => 'Ano',    //affirmative
    'no' => 'Ne',        //negative
    'go' => 'Proveď!',    //proceed

    'minlevel' => 'Nemáte oprávnění ke vstupu do této oblasti Pivotu',
    'email' => 'Email',
    'url' => 'URL',
    'further_options' => "Další nastavení",
    'basic_view' => "Základní pohled",
    'basic_view_desc' => "Prohlížení nejobvyklejších polí",
    'extended_view' => "Rozšířený pohled",
    'extended_view_desc' => "Prohlížení všech editovatelných polí",
    'select' => "Vybrat",
    'cancel' => "Zrušit",
    'delete' => 'Smazat',
    'welcome' => "Vítejte v %build%.",
    'write' => "Zápis",
    'write_open_error' => "Chyba zápisu. Nemohu otevřít soubor pro zápis",
    'write_write_error' => "Chyba zápisu. Nemohu zapisovat do souboru",
    'done' => "Hotovo!",
    'shortcuts' => "Zkratky",
    'cantdelete' => "Není vám dovoleno mazat záznam %title%!",
    'cantdothat' => "Není vám dovoleno toto provádět se záznamem %title%!",
    'continue' => "Pokračovat",
    'toggle_view' => "Přepnout mezi základním a rozšířeným pohledem",
    'approve' => "Potvrdit",
    'edit' => "Editovat",
    'cantdeletelast' => "Nemůžete smazat poslední záznam. Nejdříve přidejte nový záznam.",
    'more' => "více",
);


$lang['userlevels'] = array (
        'Superadmin', 'Administrátor', 'Pokročilý', 'Běžný', 'Moblogger'
        //  this one might be a bit hard to translate, but basically it's an order of
        //  power or trust.  Superadmin would be the person in charge - no one can do
        //  anything about his decisions. Admin is only regulated by the Superadmin,
        //  Advanced by the Admin and Superadmin, etc..
        //  Just get the idea of it.
);


$lang['numbers'] = array (
    'žádný', 'jeden', 'dva', 'tři', 'čtyři', 'pět', 'šest', 'sedm', 'osm', 'devět', 'deset', 'jedenáct', 'dvanáct', 'třináct', 'čtrnáct', 'patnáct', 'šestnáct'
);


$lang['months'] = array (
    'Leden', 'Únor', 'Březen', 'Duben', 'Květen', 'Červen', 'Červenec', 'Srpen', 'Září', 'Říjen', 'Listopad', 'Prosinec'
);


$lang['months_abbr'] = array (
    'Led', 'Úno', 'Bře', 'Dub', 'Kvě', 'Čer', 'Čec', 'Srp', 'Zář', 'Říj', 'Lis', 'Pro'
);


$lang['days'] = array (
    'Neděle', 'Pondělí', 'Úterý', 'Středa', 'Čtvrtek', 'Pátek', 'Sobota'
);


$lang['days_abbr'] = array (
    'Ne', 'Po', 'Út', 'St', 'Čt', 'Pá', 'So'
);


$lang['days_calendar'] = array (
        'N', 'P', 'Ú', 'S', 'Č', 'Á', 'S'
);


$lang['datetime_words'] = array (
    'Rok', 'Měsíc', 'Týden', 'Den', 'Hodina', 'Minuta', 'Sekunda'    //the actual words for them.
);


//        Login Page        \\
$lang['login'] = array (
    'title' => 'Přihlášení',
    'name' => 'Uživatelské jméno',
    'pass' => 'Heslo',
    'remember' => 'Zapamatovat',
    'rchoice' => array (
        '0' => 'Nic',
        '1' => 'Moje jméno a heslo',
        '2' => 'Chci zůstat přihlášen'
    ),
    'delete_cookies_desc' => 'Pokud jste si jist, že používáte správné jméno a heslo, <br />ale stále máte problémy s přihlášením, zkuste smazat cookies domény weblogu.',
    'delete_cookies' => 'Smazat cookies',
    'retry' => 'Špatné jméno/heslo',
    'banned' => 'Desetkrát se vám nepodařilo přihlásit. IP adresa, ze které byly tyto pokusy vedeny, bude 12 hod. zablokována.',

);


//        Main Bar        \\
$lang['userbar'] = array (
    'main' => 'Přehled',
    'entries' => 'Záznamy',
    'submit' => 'Nový záznam',
    'comments' => 'Komentáře',
    'modify' => 'Změnit záznamy',
    'userinfo' => 'Moje info',
    'u_settings' => 'Moje nastavení',
    'u_marklet' => 'Bookmarklety',
    'files' => 'Správa médií',
    'upload' => 'Upload',
    'stats' => 'Statistiky',
    'admin' => 'Administrace',

    'main_title' => 'Globální přehled Pivotu',
    'entries_title' => 'Přehled záznamů',
    'submit_title' => 'Nový záznam',
    'comments_title' => 'Editace nebo mazání komentáře',
    'modify_title' => 'Změna záznamu',
    'userinfo_title' => 'Prohlížení osobních informací',
    'u_settings_title' => 'Editace osobních nastavení',
    'u_marklet_title' => 'Vytvoření bookmarkletu',
    'files_title' => 'Správa a upload médií',
    'upload_title' => 'Upload souborů',
    'uploaded_success' => 'Soubor byl uploadován',
    'stats_title' => 'Prohlížení logů a statistik',
    'updatetitles_title' => 'Prohlížení logů a statistik',
    'admin_title' => 'Přehled administrace',
    'recent_entries' => 'Poslední záznamy',
    'recent_comments' => 'Poslední komentáře',

    'trackbacks' => "Trackbacky",
    'trackbacks_title' => "Editovace nebo Smazání trackbacků",
    'moderate_comments' => "Moderovat komentáře",
    'moderate_comments_desc' => "Na vaše potvrzení čeká %1 komentář(ů).",
    'moderate_nocomments_desc' => "Na vaše potvrzení nečekají žádné komentáře.",
    'moderate_autoapprove' => "Okamžitě potvrzovat v budoucnu komentáře těchto registrovaných uživatelů.",
);


$lang['adminbar'] = array (
    //        Admin Bar        \\
    //'trebuild' => 'Rebuild all Files', rolled into maintenance
    'seeusers' => 'Uživatelé',
    'seeconfig' => 'Konfigurace',
    'filemappings' => 'Mapování souborů',
    'templates' => 'Šablony',
    'maintenance' => 'Údržba',
    'regen' => 'Sestavit všechny soubory',
    'blogs' => 'Weblogy',
    'categories' => 'Kategorie',
    'verifydb' => 'Zkontroluj databázi',
    'buildindex' => 'Sestavit index',
    'buildsearchindex' => 'Sestavit prohledávací index',
    'buildfrontpage' => 'Sestavit úvodní stránku(y)',
    'sendping' => 'Poslat pingy',


    'backup' => 'Záloha',
    'description' => 'Popis',
    'conversion' => 'Konverze',
    'seeusers_title' => 'Vytvoření, editace a mazání uživatelů',
    'userfields' => 'Informace o uživateli',
    'userfields_title' => 'Vytvoření, editace a mazání informací o uživateli',
    'seeconfig_title' => 'Editace konfiguračních souborů',
    'filemappings_title' => 'Přehled souborů, vytvořených Pivotem pro weblogy na tomto webu',
    'templates_title' => 'Vytvoření, editace a mazání šablon',
    'maintenance_title' => 'Provedení běžné údržby souborů Pivotu',
    'regen_title' => 'Sestavení souborů a archivů generovaných Pivotem',
    'blogs_title' => 'Vytvoření, editace a mazání weblogů',
    'blogs_edit_title' => 'Editace nastavení weblogu ',
    'categories_title' => 'Vytvoření, editace a mazání kategorií',
    'verifydb_title' => 'Kontrola integrity databáze',
    'buildindex_title' => 'Sestavení indexu databáze',
    'buildsearchindex_title' => 'Sestavení indexu pro prohledávání záznamů',
    'buildfrontpage_title' => 'Sestavení úvodní stránky, posledního archivu a RSS pro všechny weblogy.',
    'backup_title' => 'Vytvoření zálohy vašich záznamů',
	'backup_config' => 'Vytvoření zálohy konfiguračních souborů',
	'backup_config_desc' => 'Umožní vám stáhnout si zip archiv obsahující vaše konfigurační soubory',
    'ipblocks' => 'Blokované IP',
    'ipblocks_title' => 'Prohlížení a editace blokovaných IP adres',
    'ipblocks_stored' => 'IP-adresa byla uložena.',
    'ipblocks_store' => 'Uložit tyto IP adresy',
	'ignoreddomains' => 'Ignorované domény',
	'ignoreddomains_title' => 'Prohlížení a editace ignorovaných domén.',
	'ignoreddomains_stored' => 'Ignorované domény byly uloženy.',
	'ignoreddomains_store' => 'Uložit tyto ignorované domény',
    'fileexplore' => 'Prohlížeč souborů',
    'fileexplore_title' => 'Prohlížení souborů (textových i databázových)',
    'sendping_title' => 'Posílání pingů pro obnovení stopování.',
    'buildindex_start' => 'Vytvářím index. Může to chvilku trvat, nepřerušujte tento proces.',
    'buildsearchindex_start' => 'Vytvářím prohledávací index. Může to chvilku trvat, nepřerušujte tento proces.',
    'buildindex_finished' => 'Dokončeno! Vytvoření indexu trvalo %num% sekund',

    'filemappings_desc' => 'Níže můžete vidět přehled všech weblogů této instalace Pivotu společně se soubory a šablonami, použitými Pivotem k jejich vytvoření. Velmi užitečné pro hledání přesného místa vzniku problémů při vytváření souborů.',

    'seecommusers' => "Registrovaní návštěvníci",
    'seecommusers_title' => "Prohlížení a editace registrovaných návštěvníků",
    'backup_db' => "Zazálohovat databázy",
    'backup_db_desc' => "Umožní vám stáhnout zip soubor obsahující databázy se všemi příspěvnky.",
    'ignoreddomains_asterisk' => "Položky označené hvězdičkou ( * ) budou použity k blokování odkazujících stránek. Ostatní budou použity k blokování odkazů, komentářů i trackbacků.",
    'ignoreddomains_global' => "Globálně blokované fráze.",
    'ignoreddomains_global_desc' => "Kromě blokování frází s předchozího seznamu můžete použít i aktualizovaný i seznam který Pivot získá ze serveru pivotlog.net. Momentálně tento seznam obsahuje:",
    'ignoreddomains_global_empty' => "Seznam globálních frází je prázdný",
    'ignoreddomains_global_update' => "Aktualizovat seznam frází z pivotlog.net",
    'ignoreddomains_global_delete' => "Odstranit seznam globálních frází",
    'ignoreddomains_global_success' => "Globální fráze byly uloženy",
    'ignoreddomains_global_failed' => "Seznam globálních frází nemůže být uložen, prosím zkuste to později znovu.",
    'ignoreddomains_global_deleted' => "Globální fráze byly vymazány.",
    'debug' => "Otevřít debugovací okno",
    'latest_pivot_news' => "Poslední novinky Pivotu",
    'remove_setup_header' => "Nalezen instalační skript Pivotu",
    'remove_setup' => "Instalační skript Pivotu 'pivot-setup.php' je stále v nadřazeném adresáři. Upozorňujeme, že se jedná o potenciální bezpečností riziko. Doporučujeme ho odstranit nebo přejmenovat, aby nemohl být zneužit lidmi se špatnými úmysly.",
    'magic_quotes_header' => "Magic quotes povoleny",
    'magic_quotes' => "Váš PHP server má povoleny 'Magic quotes'. To může způsobovat že Pivot nepoběží optimálne. Podívejte se na <a href='http://www.pivotlog.net/docs/doku.php?id=servers_with_magic_quotes'>tuto stránku</a> k objasnění situace.",
    'register_globals_header' => "Register Globals povoleny",
    'register_globals' => "Váš PHP server má povoleny 'register globals'. To je potenciálně nebezpečné nastavení, proto byste měli žádat nápravu. K objasnení situace navštivte <a href='http://www.pivotlog.net/docs/doku.php?id=servers_with_register_globals'>tuto stránku</a>.",
    'spamprotection' => "Ochrana proti spamu",
    'spamprotection_title' => "Přehled různých nástrojů umožňujících zbavit váš weblog spamu.",
    'spamconfig' => "Konfigurace spamu",
    'spamconfig_title' => "Konfigurace nástrojů pro ochranu před spamem (HashCash, SpamQuiz apod.).",
    'seespamconfig_title' => "Konfigurace nástrojů ochrany proti spamu",
    'spamwasher' => "Čistič spamu",
    'spamwasher_title' => "Vyhledání a odstraní spamu ze všech záznamů a trackbacků.",
    'spamlog' => "Záznamy o Spam",
    'spamlog_title' => "Prohlížení vyčištění záznamů o spamu.",
    'viewspamlog_title' => "Zobrazení záznamů o spamu.",

);


$lang['templates'] = array (
    'rollback' => 'Vrátit zpět',
    'create_template' => 'Vytvořit šablonu',
    'create_template_info' => 'Vytvoření šablony Pivotu od začátku',
    'no_comment' => 'Bez komentáře',
    'comment' => 'Komentář*',
    'comment_note' => '(*Pozn.: Komentáře mohou být uloženy pouze při <b>prvním</b> uložení změn nebo při vytvoření)',
    'create' => 'Vytvořit šablonu',
    'editing' => 'Editace',
    'filename' => 'Jméno souboru',
    'save_changes' => 'Uložit změny!',
    'save_template' => 'Uložit šablonu!',
    'aux_template' => "Pomocná šablona",
    'sub_template' => "Podřazená šablona",
    'standard_template' => "Normální šablona",
    'feed_template' => "Šablona Feed",
    'css_template' => "CSS soubor",
    'txt_template' => "Textový soubor",
    'php_template' => "PHP soubor",
);


$lang['spam'] = array (
    'hc_options' => "Nastavení HashCash",
    'hc' => "Používat HashCash",
    'hc_desc' => "HashCash je jedna z nejlepších a zcela neviditelných ochran proti spamu, které jsou dostupné. Požaduje u klienta povolený javascript. Pokud je to pro vás nepřijatelné, nezapínejte ji.",
    'sq_options' => "Nastavení SpamQuiz",
    'sq' => "Používat SpamQuiz",
    'sq_desc' => "Před odesláním komentáře musí každý uživatel správně odpovědět na jednoduchou otázku, na kterou každý zná odpověď. To kompletně zmate spamovací roboty, protože každý blogger může použít vlasní otázku.",
    'sq_question' => "Otázka",
    'sq_question_desc' => "Příklad: Jaká jsou dvě první písmena slova 'spam'?",
    'sq_answer' => "Odpověď",
    'sq_answer_desc' => "Příklad: <b>sp</b>",
    'sq_explain' => "Vysvětlení",
    'sq_explain_desc' => "Příklad: K ověření že nejste spamovací robot potřebujeteme abyste odpovědeli na tuto jednoduchou otázku.",
    'sq_days' => "Limit stáří",
    'sq_days_desc' => "Povolit SpamQuiz pouze pro záznamy starší tento počet dní. Běžně se komentářový spam objevuje jen u starších příspěvků. Není tedy potřeba obtěžovat běžné uživatele, kteří odpovídají například během týdne po zveřejnení.",
    'ht_options' => "Zocelená ochrana trackbacků",
    'ht' => "Používat zocelený trackback",
    'ht_desc' => "Zocelený trackback je účinná ochrana proti spamu v trackbacích. Vyžaduje povolený javascript u klienta. Pokud je to pro vás nepřijatelné, nezapínejte jej.",
    'tburl_gen' => "Klikněte pro vygenerování trackback url",
    'tburl_gen_note' => "Pozn.: vygenerované url je platné jen 15 minut a vyžaduje javascript.",
    'tburl_gen_javascript' => "Prosím povolte javascript aby se dalo trackback url vygenerovat",
    'enable_js_comm' => "Prosím, abyste mohli přidat komentář, povolte javascript (a obnovte stránku).",
    'empty_log' => "Záznamy o spamu jsou prázdné",
    'reset_log' => "Vymazat záznamy o spamu",
    'reset_log_done' => "Záznamy o spamu byly vymazány",
);    


//        Admin            \\
// bob notes: Mark made these, i think they should be replaced by the 'adminbar']['xxx_title'] ones
$lang['admin'] = array (
    'seeusers' => 'Vytvoření, editace a mazání uživatelů',
    'seeconfig' => 'Editace konfiguračních souborů',
    'templates' => 'Vytvoření, editace a mazání šablon',
    'maintenance' => 'Provedení běžné údržby souborů Pivotu, jako \'Sestavení souborů\', \'Ověření databáze\', \'Sestavení indexu\' a \'Zálohování\'.',
    'regen' => 'Sestavit všechny stránky generované Pivotem',
    'blogs' => 'Vytvoření, editace a mazání weblogů publikovaných Pivotem',
);


//        Maintenace        \\
$lang['maint'] = array (
    'title' => 'Údržba',
    'gen_arc_title' => 'Generování archivu', /* bob notes: redundant, see 'regen' */
    'gen_arc_text' => 'Regenerace všech vašich archivů', /* bob notes: redundant, see 'regen' */
    'xml_title' => 'Kontrola XML souborů', /* bob notes: replace with more general 'Verify DB' */
    'xml_text' => 'Kontrola (a pokud je to nutné i oprava) integrity XML souborů', /* bob notes: replace with more general 'Verify DB' */
    'backup_title' => 'Zálohování',
    'backup_text' => 'Vytvoření zálohy všech důležitých souborů Pivotu',
);


//        Stats and referers        \\
$lang['stats'] = array (
    'show_last' => "Ukaž posledních",
    '20ref' => "20 odkazů",
    '50ref' => "50 odkazů",
    'allref' => "všechny odkazy",
    'updateref' => "Aktualizace mapování titulků na odkazy",
	'showall' => "oboje, jak blokované tak neblokované řádky",
	'updateref' => "Aktualizace mapování odkazů na titulky",
    'hostaddress' => 'Hostitelské adresy (IP)',
    'whichpage' => 'Jaká stránka',

    'getting' => 'Získej nové titulky',
    'awhile' => 'Může to chvíli trvat, nepřerušujte tento proces.',
    'firstpass' => 'První průchod',
    'secondpass' => 'Druhý průchod',
    'nowuptodate' => 'Vaše mapování odkaz-titulek je aktualizováno.',
    'finished' => 'Ukončeno',
    
    'showunblocked' => "Pouze neblokované řádky",
);


//        User Info        \\
$lang['userinfo'] = array (
    'editfields' => 'Editovat položky uživatele',
    'desc_editfields' => 'Editace položek pro popis uživatelů',
    'username' => 'Uživatelské jméno',
    'pass1' => 'Heslo',
    'pass2' => 'Heslo (potvrzení)',
    'email' => 'Email',
    'userlevel' => 'Úroveň uživatele',
    'userlevel_desc' => 'Úroveň uživatele určuje, jaké akce bude mít uživatel povoleny.',
    'language' => 'Jazyk',
	'lastlogin' => 'Poslední přihlášení',
    'edituser' => 'Editovat uživatele',  //the link to.. well, edit the user (also the title)
    'edituserinfo' => 'Editovat informace o uživateli',
    'newuser' => 'Vytvořit nového uživatele',
    'desc_newuser' => 'Vytvoření nového účtu v Pivotu, umožňujícího přispívat do weblogu.',
    'newuser_button' => 'Vytvořit',
    'edituser_button' => 'Změnit',
    'pass_too_short' => 'Heslo musí být minimálně 6 znaků dlouhé.',
	'pass_equal_name' => 'Heslo nesmí být stejné jako uživatelské jméno.',
    'pass_dont_match' => 'Hesla se neshodují',
    'username_in_use' => 'Uživatelské jméno již existuje',
    'username_too_short' => 'Jméno musí mít alespoň 3 znaky.',
    'username_not_valid' => 'Uživatelské jméno může obsahovat pouze alfanumerické znaky (A-Z, 0-9) a podtržítko (_).',
    'not_good_email' => 'Neplatná emailová adresa',
    'c_admin_title' => 'Potvrďte vytvoření aministrátora',
    'c_admin_message' => 'Uživatel '.$lang['userlevels']['1'].' má plný přistup k Pivotu, může editovat všechny nové položky, komentáře a měnit nastavení. Jste si jist, že chcete aby %s byl '.$lang['userlevels']['1'].'?',

    'nickname' => "Přezdívka",
    'url' => "URL",
    'verified' => "Ověřeno",
    'verified_desc' => "Ověřit uživatelský účet tohoto návštěvníka.",
    'disabled' => "Zakázáno",
    'disabled_desc' => "Zakázat účet tohoto návštěvníka (pod tímto jménem nemohou být přidány žádné komentáře).",
    'users' => "Uživatelé",
    'commusers' => "Registrovaní návštěvníci",
    'editcommuser' => "Editovat registrované návštěvníky",
    'selfreg' => "Samo-registrace",
    
);


//        Config Page        \\
$lang['config'] = array (
    'save' => 'Uložit nastavení',

    'sitename' => 'Jméno webu',
    'defaultlanguage' => 'Předvolený jazyk',
	'defaultencoding' => 'Použij kódování',
	'defaultencoding_desc' => 'Definuje použité kódování (jako utf-8 nebo iso-8859-1). Pokud si nejste jisti k čemu volba je, ponechte toto pole prázdné. V tom případě se použije kódování podle zvoleného jazyka.',
    'siteurl' => 'URL webu',
    'header_fileinfo' => 'Soubor informací',
    'localpath' => 'Místní cesta',
    'debug_options' => 'Možnost debugovat',
    'debug' => 'Mód debugování',
    'debug_desc' => 'Ukaž sem tam náhodné debugovací informace..',
    'log' => 'Logovací soubory',
    'log_desc' => 'Uchovávej logy různých aktivit',

    'unlink' => 'Mazání souborů',
    'unlink_desc' => 'Některé servery, používající safe_mode, mohou vyžadovat použití tohoto nastavení. Na většině serverů však nebude potřeba žádná změna.',// dal jsem použití
    'chmod' => 'Změň práva souborů na',
    'chmod_desc' => 'Některé servery vyžadují změnit práva vytvářených souborů na určitou hodnotu. Obvyklé hodnoty jsou \'0644\' a \'0755\'. Neměňte tyto hodnoty pokud si nejste jist, co děláte.',
    'header_uploads' => 'Nastavení pro upload',
    'upload_path' => 'Cesta k uploadovaným souborům',
    'upload_accept' => 'Přijímané typy',
    'upload_extension' => 'Předvolená přípona',
    'upload_save_mode' => 'Přepisovat',
    'make_safe' => 'Vyčistit jméno souboru',
    'c_upload_save_mode' => 'Číslování souborů',
    'max_filesize' => 'Maximální velikost souboru',
    'header_datetime' => 'Datum/čas',
    'timeoffset_unit' => 'Jednotka časového posunu',
    'timeoffset' => 'Časový posun',
    'header_extra' => 'Další nastavení',
    'wysiwyg' => 'Používat WYSIWYG editor',
    'wysiwyg_desc' => 'Určuje, zda je předvolený editor WYSIWYG. Jednotliví uživatelé si toto nastavení mohou změnit v nastavení \'Moje informace\'.',
	'basic_view' => 'Použij základní pohled',
	'basic_view_desc' => 'Určuje zda se \'Nový záznam\' otevře v základním nebo rozšířeném pohledu.',
    'def_text_processing' => 'Předvolený způsob zpracování textu',
    'text_processing' => 'Zpracování textu',
    'text_processing_desc' => 'Určuje způsob zpracování textu při nepoužití WYSIWYG editoru. \'Konvertovat konce řádků\' nedělá nic jiného, než že mění konce řádků na  &lt;br&gt;-tag. <a href="http://www.textism.com/tools/textile/" target="_blank">Textile</a> je kvalitní, ale snadno ovladatelný značkovací styl.',
    'none' => 'Nic',
    'convert_br' => 'Konvertuj konce řádek na &lt;br /&gt;',
    'textile' => 'Textile',

	'allowed_cats' => 'Povolené kategorie',
	'allowed_cats_desc' => 'Uživateli je povoleno přidávat příspěvky do vybrané kategorie',
	'delete_user' => "Smazat uživatele",
	'delete_user_desc' => "Pokud chete můžete tohoto uživatele smazat. Všechny jeho příspěvky zůstanou, pouze se uživatel nadále nebude moci přihlásit",
	'delete_user_confirm' => 'Chystáte se oderat přístup pro %s. Jste si tím jist?',

    'setup_ping' => 'Nastavení pingu',
    'ping_use' => 'Aktualizace stopování pingu',
    'ping_use_desc' => 'Určuje, zda stopovače jako weblogs.com budou automaticky informovány Pivotem, pokud přidáte nový příspěvek. Služby jako blogrolling.com jsou na tom přímo závislé.',
    'ping_urls' => 'URL kam pingat',
    'ping_urls_desc' => 'Zde můžete zadat několik adres, na které se bude posílat ping. Nevkládejte řetězec http://, jinak to nebude fungovat. Pouze vložte adresu - na každý řádek jednu, nebo je oddělte znakem roury (|). Některé oblíbené servery:<br /><b>rpc.weblogs.com/RPC2</b> (weblogs.com ping, jeden z nejpoužívanějších)<br /><b>pivotlog.net/pinger</b> (pivotlog ping, ještě nefunkční)<br /><b>rcs.datashed.net/RPC2</b> (euro.weblogs.com ping)<br /><b>ping.blo.gs</b> (blo.gs pinger)<br />',

	'setup_tb' => 'Nastavení stopování',
	'tb_password' => 'Heslo',
	'tb_password_desc' => 'Heslo je použito pro přihlášení k mazání stopování. Pokud není nastaveno, mazání stopování je vypnuto.',
	'tb_email' => 'Email',
	'tb_email_desc' => 'Na tuto adresu bude odeslána zpráva pokud je přidáno stopování.',
	'tb_rss' => 'Vytvořit RSS pro stopování',

    'new_window' => 'Otevírat linky v nových oknech',
    'emoticons' => 'Používat emotikony',
    'javascript_email' => 'Kódovat emailové adresy?',
    'new_window_desc' => 'Určuje, zda všechny linky v záznamech budou otevírat nové okno prohlížeče.',

    'mod_rewrite' => 'Porovnávej soubory',
    'mod_rewrite_desc' => 'Pokud používáte porovnávání souborů z Apache, Pivot vytvoří URL jako www.mysite.com/archive/2003/05/30/nice_weather, místo www.mysite.com/pivot/entry.php?id=134. Ne všechny servery to podporují. Podívejte se do manuálu.',

    'search_index' => 'Automaticky aktualizovat prohledávací index',
    'search_index_desc' => 'Určuje, zda prohledávací index bude aktualizován pokaždé, když vložíte nový záznam nebo změníte existující.',

        'default_allow_comments' => 'Vždy povolit komentáře',
        'default_allow_comments_desc' => 'Určuje zda je povoleno k záznamům vkládat komentáře.',

  'maxhrefs' => 'Počet odkazů',
  'maxhrefs_desc' => 'Maximální počet odkazů povolených v komentáři. Užitečný způsob jak se zbavit obtěžujících komentářů s odkazy. Nastavte na 0 pro neomezeně.',
  'rebuild_threshold' => 'Práh sestavení',
  'rebuild_threshold_desc' => 'Počet sekund, které trvá sestavení, než Pivot obnoví stránku. Nastaveno je 28, pokud ale máte problém se sestavováním, zkuste hodnotu snížit na 10.',
    'default_introduction' => 'Předvolený úvod/tělo',
    'default_introduction_desc' => 'Určuje předvolený obsah úvodu a těla záznamu. Normálně je to prázdný odstavec.',

    'upload_autothumb'    => 'Automaticky vytvářet náhledy',
    'upload_thumb_width' => 'Šířka náhledu',
    'upload_thumb_height' => 'Výška náhledu',
    'upload_thumb_remote' => 'Externí ořezávací skript',
    'upload_thumb_remote_desc' => 'Pokud váš server nemá potřebné knihovny pro ořezávání obrázků, můžete použít externí skript.',

	'extensions_header' => 'Adresář pro rozšíření',
	'extensions_desc'   => 'Adresář pro \'rozšíření\' je místo kde se budou ukládat vaše přídavky k Pivotu.
	        Zavedení tohoto adresáře výrazně zjednoduší přechod na nové verze. Více informací v dokumentaci.',
	'extensions_path'   => 'Cesta k adresáři s rozšířeními',

    'defaulttheme' => "Téma vzhledu",
    'selfreg' => "Povolit samo-registraci",
    'selfreg_desc' => "Nastavení na Ano umožňí uživatelům registrovate se jako normální uživatel a přídávat záznamy. (Toto nejsou 'komentářový' uživatelé.)",
    'xmlrpc' => "Povolit XML-RPC",
    'xmlrpc_desc' => "Nastavení na Ano vám umožní přidávat záznamy na weblog z desktopové aplikace (využívající MetaWeblog API).",
    'markdown' => "Markdown",
    'markdown_smartypants' => "Markdown a Smartypants",
    'delete_commuser' => "Smazat registrovaného návštěvníka",
    'delete_commuser_desc' => "Pokud chcete, můžete smazat tohoto registrovaného návštěvníka. Všechny jeho komentáře zůstanou zachovány.",
    'delete_commuser_confirm' => "Chystáte se odebrat účet %s. JSte si jisti, že to chcete udělat?",
    'mod_rewrite_1' => "Ano, jako /archive/2005/04/28/titulek_záznamu",
    'mod_rewrite_2' => "Ano, jako /archive/2005-04-28/titulek_záznamu",
    'mod_rewrite_3' => "Ano, jako /zaznam/1234",
    'mod_rewrite_4' => "Ano, jako /zaznam/1234/titulek_záznamu",
    'moderate_comments' => "Moderovat komentáře",
    'moderate_comments_desc' => "Určuje zda mají být komentáře potvrzeny před tím, než jsou viditelné na webu.",
    
);


//        Weblog Config    \\
$lang['weblog_config'] = array (
    'edit_weblog' => 'Editovat weblog',
    'edit_blog' => 'Editovat blog',
    'new_weblog' => 'Nový weblog',
    'new_weblog_desc' => 'Přidat nový weblog',
    'del_weblog' => 'Smazat weblog',
    'del_this_weblog' => 'Smazat tento weblog.',
    'create_new' => 'Vytvořit nový weblog',
    'subw_heading' => 'Pro každý založený subweblog můžete nastavit použitou šablonu stejně jako kategorii, ve které má být publikován',
    'create' => 'Dokončit',

    'create_1' => 'Vytvoření / editace weblogu, krok 1 z 3',
    'create_2' => 'Vytvoření / editace weblogu, krok 2 z 3',
    'create_3' => 'Vytvoření / editace weblogu, krok 3 z 3',

    'name' => 'Jméno weblogu',
    'payoff' => 'Přínos',
    'payoff_desc' => 'Přínos může být použit jako podtitulek nebo krátký popis weblogu',
    'url' => 'URL weblogu',
    'url_desc' => 'Pokud necháte políčko prázdné, Pivot sám určí URL weblogu. Pokud používáte weblog jako součást rámců, nebo jako serverside include, použijte toto nastavení.',
    'index_name' => 'Úvodní stránka (Index)',
    'index_name_desc' => 'Jméno index souboru. Obvykle je to něco jako \'index.html\' nebo \'index.php\'.',

    'ssi_prefix' => 'Prefix SSI',
    'ssi_prefix_desc' => 'Pokud váš webolog používá SSI (což není doporučeno), použijte nastavení prefixu jmen souborů Pivotu pro SSI. Např. \'index.shtml?p=\'. Pokud nevíte k čemu nastavení je, nechte ho prázdné.',

    'front_path' => 'Cesta k úvodní stránce',
    'front_path_desc' => 'Relativní nebo absolutní cesta, kde Pivot vytvoří úvodní stránku weblogu.',
    'file_format' => 'Jméno souboru',
    'entry_heading' => 'Nastavení záznamů',
    'entry_path' => 'Cesta k záznamům',
    'entry_path_desc' => 'Relativní nebo absolutní cesta, kde Pivot vytvoří záznam stránky, pokud nepoužijete  \'živé vstupy\'.',
    'live_comments' => 'Živé vstupy',
    'live_comments_desc' => 'Pokud používáte \'živé vstupy\', Pivot nebude vytvářet soubory pro jednotlivé záznamy. Preferované nastavení.',
    'readmore' => '\'Více...\'',
    'readmore_desc' => 'Text použitý k upozornění na pokračování textu záznamu. Pokud necháte nastavení nevyplněné, Pivot použije nastavení z příslušného jazyka.',

    'arc_heading' => 'Nastavení archivu',
    'arc_index' => 'Soubor indexu',
    'arc_path' => 'Cesta k archivům',
    'archive_amount' => 'Počet archivů',
    'archive_unit' => 'Typ archivů',
    'archive_format' => 'Formát archivu',
    'archive_none' => 'Žádné archivy',
    'archive_weekly' => 'Týdenní archivy',
    'archive_monthly' => 'Měsíční archivy',
	'archive_yearly' => 'Roční archivy',

    'archive_link' => 'Odkaz na archiv',
    'archive_linkfile' => 'Formát seznamu archivů',
    'archive_order' => 'Pořadí archivů',
    'archive_ascending' => 'Vzestupně (nejstarší první)',
    'archive_descending' => 'Sestupně (nejnovější první)',

    'templates_heading' => 'Šablony',
    'frontpage_template' => 'Šablony úvodní stránky',
    'frontpage_template_desc' => 'Šablona určující vzhled úvodní stránky weblogu.',
    'archivepage_template' => 'Šablona stránky s archivy',
    'archivepage_template_desc' => 'Šablona určující vzhled archivů. Může být stejná jako \'Šablona úvodní stránky\'.',
    'entrypage_template' => 'Šablona záznamu',
    'entrypage_template_desc' => 'Šablona určující vzhled jednotlivých záznamů.',
    'extrapage_template' => 'Další šablony',
    'extrapage_template_desc' => 'Šablona určující vzhled stránky pro prohledávání archivu.',

    'shortentry_template' => 'Šablona zkráceného záznamu',
    'shortentry_template_desc' => 'Šablona určující vzhled zkráceného záznamu pro weblog a archiv.',
    'num_entries' => 'Počet záznamů',
    'num_entries_desc' => 'Počet záznamů subweblogu na úvodní stránce.',
    'offset' => 'Posun',
    'offset_desc' => 'Posun určuje počet záznamů, které budou přeskočeny při generování stránky. Využití např. pro vytvoření seznamu \'Předchozí záznamy\'.',
    'comments' => 'Povolit komentáře?',
    'comments_desc' => 'Určuje, zda uživatelé budou mít možnost připojovat komentáře k záznamům subweblogu',

	'publish_cats' => 'Publikuj tyto kategorie',

    'setup_rss_head' => 'Konfigurace RSS a Atomů',
    'rss_use' => 'Vytvářet kanály',
    'rss_use_desc' => 'Určuje, zda bude Pivot automaticky generovat kanály RSS a Atom pro tento weblog.',
    'rss_filename' => 'Soubor pro RSS',
    'atom_filename' => 'Soubor pro Atom',
    'rss_path' => 'Cesta k RSS kanálu',
    'rss_path_desc' => 'Relativní nebo absolutní cesta k adresáři, kde Pivot vytvoří soubor pro RSS kanál.',
//    'rss_size' => 'Délka záznamu pro RSS kanál',
//    'rss_size_desc' => 'Délka (počet znaků) každého záznamu pro RSS kanál',
        'rss_full' => 'Vytářet kompletní Feeds',
        'rss_full_desc' => 'Určuje zda bude Pivot vytářet kompletní Atom a RSS feeds. Pokud je nastaveno \'ne\' bude Pivot vytvářet feeds které obsahují pouze zkrácený popis.',
	'rss_link' => 'Odkaz Feed',
	'rss_link_desc' => 'Odkaz, který se posílá s feedem a ukazuje na hlavní stránku. Pokud toto pole necháte prázdné Pivot bude odesílat hlavní stránku weblogu.',
	'rss_img' => 'Obrázek Feed',
	'rss_img_desc' => 'Obrázek, který se posíla s feedem. Některé čtečky feedů dokáží tento obrázek zobrazit společně s feedem. Nechte buď prázné nebo zadejte plné URL.',

    'lastcomm_head' => 'Nastavení posledních komentářů',
    'lastcomm_amount' => 'Počet',
    'lastcomm_length' => 'Délka',
    'lastcomm_format' => 'Formát',
    'lastcomm_format_desc' => 'Tato nastavení určují vzhled seznamu \'Posledních komentářů\' na úvodní stránce weblogu.',
	'lastcomm_nofollow' => 'Použít \'Nofollow\'',
	'lastcomm_nofollow_desc' => 'Pro účinnější boj s odkazovacím spamem můžete vybrat doplnění atributu rel="nofollow" do všech odkazů v komentářích. Takovými odkazy se pak nebude zvyšovat hodnocení odkazovaných stránek v Google.',

    'lastref_head' => 'Nastavení posledních odkazů',
    'lastref_amount' => 'Počet',
    'lastref_length' => 'Délka',
    'lastref_format' => 'Formát',
    'lastref_format_desc' => 'Tato nastavení určují vzhled seznamu \'Posledních odkazů\' na úvodní stránce weblogu.',
    'lastref_graphic' => 'Používat grafiku',
    'lastref_graphic_desc' => 'Určuje, zda poslední odkazy budou zvýrazněny malou ikonkou podle vyhledávačů, přes které návštěvníci přicházeji.',
    'lastref_redirect' => 'Přesměrovávat odkazy',
    'lastref_redirect_desc' => 'Pro účinnější boj se spamem můžete odkazy přesměrovávat. To ztíží spamerům zvyšování ohodnocení v Googlu.',

    'various_head' => 'Další nastavení',
    'emoticons' => 'Používat emotikony',
    'emoticons_desc' => 'Určuje, zda emotikony jako :-) budou přetransformovány na grafické ekvivalenty.',
    'encode_email_addresses' => 'Kódovat emailové adresy',
    'encode_email_addresses_desc' => 'Určuje, zda emailové adresy budou kódovány pomocí javascriptu, aby byly chráněny před spamem.',
    'target_blank' => 'Otevřít v novém okně',
    'xhtml_workaround' => 'XHTML kódování',
    'target_blank_desc' => 'Pokud zvolíte \'Ano\', všechny odkazy vložené do záznamů se budou otvírat v novém okně prohlížeče. Pokud zvolíte \'XHTML kódování\', budou mít odkazy příznak rel="external", což neporuší správný XHTML kód.',

    'date_head' => 'Nastavení zobrazení datumu',
    'full_date' => 'Formát plného datumu',
    'full_date_desc' => 'Určuje formát plného datumu a času. Nejčastěji je použit na začátku stránky s jedním záznamem',
    'entry_date' => 'Čas záznamu',
    'diff_date' => 'Datum změny',
    'diff_date_desc' => '\'Datum změny\' souvisí s \'časem záznamu\'. Zatímco čas je zobrazen u každého záznamu, datum je zobrazeno jen pokud se liší od předchozího.',
    'language' => 'Jazyk',
    'language_desc' => 'Určuje, v jakém jazyce se budou zobrazovat datumy a jaké bude kódování stránky (např. iso-8859-1, koi8-r atd.).',

    'comment_head' => 'Nastavení komentářů',
    'comment_sendmail' => 'Posílat maily',
    'comment_sendmail_desc' => 'Poté, co byl vložen komentář, může být správci weblogu zaslán mail.',
    'comment_emailto' => 'Poslat na',
    'comment_emailto_desc' => 'Vepište adresy, na které bude mail odeslán. Více adres oddělte čárkou.',
    'comment_texttolinks' => 'Konvertovat text na odkazy',
    'comment_texttolinks_desc' => 'Určuje, zda budou URL vložená do textu konvertována na klikací odkazy.',
    'comment_wrap' => 'Zalamovat komentáře po',
    'comment_wrap_desc' => 'Abyste se vyhnuli dlouhým řádkům v komentářích, které by mohly poškodit vzhled stránky, určete počet znaků pro zalomení.',
    'comments_text_0' => 'označení pro \'žádný komentář\'Žádný komentář',
    'comments_text_1' => 'označení pro \'jeden komentář\'Jeden komentář',
    'comments_text_2' => 'označení pro \'X komentářů\'Komentářů: ',
    'comments_text_2_desc' => 'Text, který bude indikovat počet komentářů k záznamu. Pokud necháte volné, Pivot použije nastavení podle jazyka.',

    'comment_pop' => 'Komentáře v popup okně',
    'comment_pop_desc' => 'Určuje, zda se komentáře budou zobrazovat v původním okně prohlížeče nebo v popup (vyskakovacím) okně.',
    'comment_width' => 'Šířka okna',
    'comment_height' => 'Výška okna',
    'comment_height_desc' => 'Určení rozměrů popup okna.',

    'comment_format' => "Formát komentářů",
    'comment_format_desc' => "Specifikuje způsob formátování komentářů k záznamu.",

	'comment_reply' => "Formát 'odpovědi ..'",
	'comment_reply_desc' => "Určuje formátování odkazu, který mohou návštěvníci použít k odpovědi na konkrétní komentář.",
	'comment_forward' => "Formát 'odpovězeno ..'",
	'comment_forward_desc' => "Určuje formát textu, který je zobrazen pokud je komentář komentován jiným komentářem.",
	'comment_backward' => "Formát 'odpověď na ..'",
	'comment_backward_desc' => "Určuje formátování textu, který je zobrazen pokud je komentář komentářem k jinému komentáři.",

    'comment_textile' => 'Povolit Textile',
    'comment_textile_desc' => 'Pokud nastavíte \'Ano\' , návštěvníci mohou v komentářích používat <a href="http://www.textism.com/tools/textile/" target="_blank">Textile</a>.',

    'saved_create' => 'Nový weblog byl vytvořen.',
    'saved_update' => 'Weblog byl aktualizován.',
    'deleted' => 'Weblog byl smazán.',
    'confirm_delete' => 'Chystáte se smazat weblog %1. Jste si jist?',

    'blogroll_heading' => 'Nastavení služby Blogroll',
    'blogroll_id' => 'Blogrolling ID #',
    'blogroll_id_desc' => 'Zde můžete nastavit <a href="http://www.blogrolling.com" target="_blank">blogrolling.com</a> jako službu blogroll. Je to výborná služba pro správu odkazů, která ukazuje, kdy byly naposled aktualizovány. Pokud tuto službu nepoužíváte, jednoduše nastavení přeskočte. Po přihlášení na blogrolling.com zvolte \'get code\', kde najdete odkaz, obsahující vaše ID. Vypadá nějak takto: 2ef8b42161020d87223d42ae18191f6d',
    'blogroll_fg' => 'Barva textu',
    'blogroll_bg' => 'Barva pozadí',
    'blogroll_line1' => 'Barva řádku 1',
    'blogroll_line2' => 'Barva řádku 2',
    'blogroll_c1' => 'Barva 1',
    'blogroll_c2' => 'Barva 2',
    'blogroll_c3' => 'Barva 3',
    'blogroll_c4' => 'Barva 4',
    'blogroll_c4_desc' => 'Tyto barvy určují, jak bude vypadat váš blogroll. Barvy 1 až 4 indikují aktuálnost odkazu.',
    
    'save_comment' => "Uložit komentář",
    'comment_gravatardefault' => "Předvolený Gavatar",
    'comment_gravatardefault_desc' => "URL k předvolenému obrázku Gavataru, začínající http://",
    'comment_gravatarhtml' => "Gavatar HTML",
    'comment_gravatarhtml_desc' => "HTML pro voložení Gavataru. %img% bude nahrazeno za url obrázku.",
    'comment_gravatarsize' => "Velikost Gavataru",
    'comment_gravatarsize_desc' => "Velikost Gavateru v bode. Přednastaveno na 48.",
    'trackback_head' => "Nastavení trackbacků",
    'trackback_sendmail' => "Poslat email?",
    'trackback_sendmail_desc' => "Poté co byl u vás umístěn trackback může být správci weblogu poslán email.",
    'trackback_emailto' => "Poslat na:",
    'trackback_emailto_desc' => "Určete emailovou adresu(y) kam se má mail odeslat. Více adres oddělte čárkou.",
    'trackbacks_text_0' => "Označení pro 'žádné trackbacky'",
    'trackbacks_text_1' => "Označení pro 'jeden trackback'",
    'trackbacks_text_2' => "Označení pro 'X trackbacků'",
    'trackbacks_text_2_desc' => "Text, který je použit k oznámení kolik je zde trackbacků. Pokud tato pole nevyplníte, použíje Pivot předovlené nastavení pro daný jazyk.",
    'trackback_pop' => "Vyskakovací okna trackbacků?",
    'trackback_pop_desc' => "Určuje, zda bude stránka s trackbacky otevřena v novém okně nebo v původním okně prohlížeče.",
    'trackback_width' => "Šířka nového okna",
    'trackback_height' => "Výška nového okna",
    'trackback_height_desc' => "Zadejte šířku a výšku (v bodech) vyskakovacího okna trackbacků.",
    'trackback_format' => "Formát trackbacku",
    'trackback_format_desc' => "Určuje formátování trackbacků na stránce záznamu.",
    'trackback_link_format' => "Formát trackback odkazu",
    'save_trackback' => "Uložit trackback",
    
);


$lang['upload'] = array (
    //        File Upload        \\
    'preview' => 'Kompletní seznam',
    'thumbs' => 'Náhled',
    'create_thumb' => '(Vytvořit náhled)',
    'title' => 'Soubory',
    'thisfile' => 'Upload nového souboru:',
    'button' => 'Upload',
    'filename' => 'Jméno souboru',
    'thumbnail' => 'Náhled',
    'date' => 'Datum',
    'filesize' => 'Velikost souboru',
    'dimensions' => 'Šířka x Výška',
    'delete_title' => 'Smazat obrázek',
    'areyousure' => 'Jste si jisti, že chcete smazat soubor %s?',
    'picheader' => 'Smazat teto obrázek?',
    'create' => 'vytvořit',
    'edit' => 'editovat',

    'insert_image' => 'Vložit obrázek',
    'insert_image_desc' => 'Abyste mohli obrázek vložit, musíte ho nejdříve uploadovat nebo vybrat.',
    'insert_image_popup' => 'Vložit okno s obrázkem',
    'insert_image_popup_desc' => 'Abyste mohli vytvořit okno, musíte uploadovat obrázek nebo vybrat již exitujíci. Poté vyberte text nebo náhled, který bude umístěn v okně.',
    'choose_upload' => 'upload',
    'choose_select' => 'nebo vybrat',
    'imagename' => 'Jméno obrázku',
    'alt_text' => 'Alternativní text',
    'align' => 'Zarovnat',
    'border' => 'Okraje',
    'pixels' => 'bodů',
    'uploaded_as' => 'Váš soubor byl uložen jako \'%s\'.',
    'not_uploaded' => 'Váš soubor nebyl uložen. Nastala následující chyba:',
    'center' => 'Centrovat (předvolené)',
    'left' => 'Doleva',
    'right' => 'Doprava',
    'inline' => 'V řadě',
    'notice_upload_first' => 'Nejříve musíte vybrat nebo uploadovat obrázek',
    'select_image' => 'Vyberte obrázek',
	'select_file' => 'Vyberte soubor',

    'for_popup' => 'Do popup okna',
    'use_thumbnail' => 'Použít náhled',
    'edit_thumbnail' => 'editovat náhled',
    'use_text' => 'Použít text',
	'insert_download' => 'Vložit download',
	'insert_download_desc' => 'Pokud chcete dát soubor ke stažení, musíte ho buď nejdříve přenést na server, nebo vybrat již uložený soubor. Poté vyberte co má download spustit, zda ikona, text nebo malý obrázek.',
	'use_icon' => 'Použij ikonu',
);


$lang['link'] = array (
    //        Link Insertion \\
    'insert_link' => 'Vložit odkaz',
    'insert_link_desc' => 'Vložte text do políčka níže. Návštěvníci vašich stránek uvidí tento text při přejetí myší přes odkaz.',
    'url' => 'URL',
    'title' => 'Titulek',
    'text' => 'Text',
);


//        Categories        \\
$lang['category'] = array (
    'edit_who' => 'Zvolte, kdo může přispívat do kategorie \'%s\'',
    'name' => 'Jméno',
    'users' => 'Uživatelé',
    'make_new' => 'Vytvořit novou kategorii',
    'create' => 'Vytvořit kategorii',
    'canpost' => 'Vyberte uživatele, kterým dáte právo přispívat do této kategorie',
    'same_name' => 'Kategorie tohoto jména již existuje',
    'need_name' => 'Kategorie potřebuje jméno',

    'allowed' => 'Povoleno',
    'allow' => 'Povolit',
    'denied' => 'Zakázáno',
    'deny' => 'Zakázat',
    'edit' => 'Editovat kategorii',

    'delete' => 'Smazat kategorii',
    'delete_desc' => 'Zvolte \'Ano\', pokud chcete smazat tuto kategorii',

    'delete_message' => 'V této verzi Pivotu budou smazány pouze jména kategorií. V příštích verzích bude možné vybrat, co se má provést se záznamy, které do této kategorie patří.',
	'search_index_newctitle'   => 'Prohledat tuto kategorii',
	'search_index_newcdesc'    => 'Nastavte na \'Ne\' pouze pokud chcete, aby návštěvníci nemohli prohledávat tuto kategorii.',
	'search_index_editcheader' => 'Prohledat kategorii',

	'order' => 'Zařazení',
	'order_desc' => 'Kategorie s menším zařazením se budou objevovat v seznamu výše. Pokud necháte všechna čísla stejná, budou řazeny abecedně.',
	'public' => 'Veřejná kategorie',
	'public_desc' => 'Pokud nastavíte \'Ne\', bude tato kategorie viditelná pouze registrovaným návštěvníkům. (aplikovatelné pouze na aktuální stránky)',
	'hidden' => 'Skrytá kategorie',
	'hidden_desc' => 'Pokud je nastaveno na \'Ano\', tato kategorie bude ve výpisu archivu skryta. (aplikuje se pouze na živé stránky)',

);


$lang['entries'] = array (
    //        Entries            \\
    'post_entry' => "Vložit záznam",
    'preview_entry' => "Prohlédnout záznam",

    'first' => 'první',
    'last' => 'poslední',
    'next' => 'další',
    'previous' => 'předchozí',

    'jumptopage' => 'skočit na stránku (%num%)',
    'filteron' => 'filtrovat (%name%)',
    'filteroff' => 'filtr vyp.',
    'title' => 'Titulek',
    'subtitle' => 'Podtitulek',
    'introduction' => 'Úvod',
    'body' => 'Tělo',
    'publish_on' => 'Publikováno',
    'status' => 'Stav',
    'post_status' => 'Stav vložení',
    'category' => 'Kategorie',
    'select_multi_cats' => '(Ctrl-klik pro výběr více kategorií)',
    'last_edited' => "Naposledy změněno",
    'created_on' => "Vytvořeno",
    'date' => 'Datum',
    'author' => 'Autor',
    'code' => 'Kód',
    'comm' => 'Počet kom.',
    'name' => 'Jméno',
    'allow_comments' => 'Povolit komentáře',

	'delete_entry' => "Smazat záznam",
	'delete_entry_desc' => "Smaže tento záznam a příslušné komentáře.",
	'delete_one_confirm' => "Jste si jisti, že chcete tento záznam smazat?",
	'delete_multiple_confirm' => "Jste si jisti, že chcete tyto záznamy smazat?",

    'convert_lb' => 'Konvertovat konce řádek',
    'always_off' => '(Vždy vypnuto, pokud používáte WYSIWYG mód)',
    'be_careful' => '(Používejte opatrně!)',
    'edit_comments' => 'Editovat komentáře',
    'edit_comments_desc' => 'Editace komentářů k tomuto záznamu',
    'edit_comment' => 'Editovat komentář',
    'delete_comment' => 'Smazat komentář',
    'block_single' => 'Blokovat IP %s',
    'block_range' => 'Blokovat IP v rozsahu %s',
    'unblock_single' => 'Odblokovat IP %s',
    'unblock_range' => 'Odblokovat IP v rozsahu %s',
    'trackback' => 'Zpětné sledování',
	'trackback_desc' => 'Posílat stopovací pingu na následující URL. Posílat na více URL lze vložením jedné URL na jednu řádku.',
	'keywords' => 'Klíčová slova',
	'keywords_desc' => 'Použijte pro označení záznamu klíčovým slovem, nebo pro vytvoření jedinečného URL záznamu.',
	'vialink' => "Skrz odkaz",
	'viatitle' => "Skrz titulek",
	'via_desc' => 'Použijte k vytvoření odkazu na zdroj tohoto záznamu.',
	'entry_catnopost' => 'Není vám dovoleno přispívat do kategorie:\'%s\'.',
	'entry_saved_ok' => 'Váš záznam \'%s\' byl úspěšně uložen.',
	'entry_ping_sent' => 'Stopovací ping byl odeslán na \'%s\'.',

    'edit_entry' => "Editovat záznam",
    'edit_entry_desc' => "Editace tohoto záznamu",
    'track' => "# Track",
    'report_comment' => "Oznámit komentář",
    'edit_trackback' => "Editovat trackback",
    'edit_trackback_desc' => "Editace trackbacku, který byl přidán k tomuto záznamu",
    'delete_trackback' => "Smazat trackback",
    'report_trackback' => "Oznámi trackback",
    'encoding_warning' => "Píšete tento záznam v %s, zatímco aspoň jeden váš weblog používá jiné kódování. K odstranění tohoto problému se ujistěte, že všichni uživatelé a weblogy používají stejné kódování.",

);


//        Form Fun        \\
$lang['forms'] = array (
    'c_all' => 'Vybrat vše',
    'c_none' => 'Zrušit výběr',
    'choose' => '- vyberte možnost -',
    'publish' => 'Nastavit stav \'publikováno\'',
    'hold' => 'Nastavit stav \'pozdrženo\'',
    'delete' => 'Smazat',
    'generate' => 'Publikovat a generovat',

    'with_checked_entries' => "S vybranými záznamy proveď:",
    'with_checked_files' => "S vybranými soubory proveď:",
    'with_checked_templates' => 'S vybranými šablonami proveď:',
);


//        Errors            \\
$lang['error'] = array (
    'path_open' => 'nemohu otevřít adresář, zkontrolujte práva.',
    'path_read' => 'nemohu číst adresář, zkontrolujte práva.',
    'path_write' => 'nemohu zapisovat do adresáře, zkontrolujte práva.',

    'file_open' => 'nemohu otevřít soubor, zkontrolujte práva.',
    'file_read' => 'nemohu číst soubor, zkontrolujte práva.',
    'file_write' => 'nemohu zapisovat do souboru, zkontrolujte práva.',

    'reg_required' => "Vyžadována registrace",
    'entry_404' => "Záznam neexistuje!",
    'entry_404_desc' => "Tento záznam neexistuje nebo není publikován.",
);


//        Notices            \\
$lang['notice'] = array (
    'comment_saved' => "Komentáře byly uloženy.",
    'comment_deleted' => "Komentáře byly smazány.",
    'comment_none' => "Žádné komentáře k tomuto záznamu.",
    
    'trackback_saved' => "Trackback byl uložen.",
    'trackback_deleted' => "Trackback byl vymazán.",
    'trackback_none' => "Tento záznam nemá žádný trackback.",
);


// Comments, Karma and voting \\
$lang['karma'] = array (
    'vote' => 'Hlasů \'%val%\' pro tento záznam',
    'good' => 'Dobrý',
    'bad' => 'Špatný',
    'already' => 'Už jste pro tento záznam hlasoval/a',
    'register' => 'Váš hlas pro \'%val%\' byl zaznamenán',
);


$lang['comment'] = array (
    'register' => 'Váš komentář byl uložen.',
    'preview' => 'Prohlížení vašeho komentáře. Nezapomeňte kliknout na \'Vložit komentář\', aby se skutečně uložil.',
    'duplicate' => 'Váš komentář nebyl uložen, protože je kopií předchozího záznamu.',
    'no_name' => 'Měli byste vložit vaše jméno nebo přezdívku do políčka \'jméno\'. Nezapomeňte kliknout na \'Vložit komentář\', aby se skutečně uložil.',
    'no_comment' => 'Měli byste něco napsat do políčka \'komentář\'. Nezapomeňte kliknout na \'Vložit komentář\', aby se skutečně uložil.',
	'too_many_hrefs' => 'Překročeno maximální povolené množství odkazů. Přestaňte nás prosím spamovat.',

    'email_subject' => "[Komentář] Re:",
    'oneclickdelete' => "Smazat jedním kliknutím",
    'oneclickreport' => "Oznámit a smazat jedním kliknutím",
    'moderated' => "Moderováno",
    'moderate_queue_on' => "Na tomto webu je povoleno moderování komentářů. To znamená, že váš komentář nebude vidět dokud nebude potvrzen editorem.",
    'moderate_stored' => "Jeden nebo více komentářů čeká na potvrzení editorem.",
    'moderate_waiting' => "",
);


$lang['comments_text'] = array (
    '0' => "Žádné komentáře",
    '1' => "Jeden komentář",
    '2' => "Komentářů: %num%",
);

$lang['trackback_text'] = array (
    '0' => "Žádný trackaback",
    '1' => "%num% trackback",
    '2' => "%num% trackbacků",
);

$lang['weblog_text'] = array (
    // these are used in the weblogs, for the labels related to archives
    'archives' => "Archivy",
    'next_archive' => "Další archiv",
    'previous_archive' => "Předchozí archiv",
    'last_comments' => "Poslední komentáře",
    'last_referrers' => "Poslední odkazy",
    'calendar' => "Kalendář",
    'links' => "Odkazy",
    'xml_feed' => "XML kanál (RSS 1.0)",
	'atom_feed' => "XML: Atom Feed",
    'powered_by' => "Využívá",
    'name' => "Jméno",
    'email' => "Email",
    'url' => "URL",
    'date' => "Datum",
    'comment' => "Komentář",
    'ip' => "IP-adresa",
    'yes' => "Ano",
    'no' => "Ne",
    'emoticons' => "Emotikony",
    'emoticons_reference' => "Otevřít seznam emotikonů",
    'textile' => "Textile",
    'textile_reference' => "Otevřít nápovědu Textile",
    'post_comment' => "Vložit komentář",
    'preview_comment' => "Prohlédnout komentář",
    'remember_info' => "Zapamatovat osobní informace?",
	'notify' => "Oznamovat",
	'notify_yes' => "Ano, pošlete mi email když někdo odpoví.",
	'register' => "Registrace/Přihlášení pod vaším jménem",
    'disclaimer' => "<b>Malé upozornění:</b> všechny HTML tagy kromě &lt;b&gt; a &lt;i&gt; budou odstraněny. Odkazy a maily stačí vložit zapsáním prostého textu.",
    'search_title' => "Výsledky hledání",
    'search' => "Hledat!",
    'nomatches' => "Pro '%name%' nebylo nic nalezeno. Zkuste vložit něco jiného.",
    'matches' => "Výsledky pro '%name%':",
	'about' => "O ...",
	'stuff' => "Personál",
	'linkdump' => "Linkdump",

    'blog_name' => "Jméno Weblogu",
    'title' => "Titulek",
    'excerpt' => "Výňatek",
    'registered' => "Registrovaný",
    'discreet' => "Skrývat email",
    'discreet_yes' => "Ano, skryj moji emailovou adresu",
    'moderated' => "Moderováno",
    'waiting_moderation' => "Tento komentář ještě nebyl moderován.",
    
);


$lang['ufield_main'] = array (
    //        Userfields        \\
    'title' => 'Editovat uživatelská pole',
    'edit' => 'Editovat',
    'create' => 'Vytvořit',

    'dispname' => 'Zobrazené jméno',
    'intname' => 'Vnitřní jméno',
    'intname_desc' => 'Vnitřní jméno je jméno položky, které bude zobrazeno, pokud požádáte Pivot o zobrazení šablony.',
    'size' => 'Velikost',
    'rows' => 'Řádky',
    'cols' => 'Sloupce',
    'maxlen' => 'Maximální délka',
    'minlevel' => 'Min. úroveň uživatele',
    'filter' => 'Filtrovat podle',
    'filter_desc' => 'Filtrováním podle této položky můžete omezit vstup, který v něm může být.',
    'no_filter' => 'Nic',
    'del_title' => 'Potvrdit smazání',
    'del_desc' => 'Smazání políčka (<b>%s</b>) uživatelského záznamu smaže také všechny záznamy, které v něm uživatel uložil, a místo něj bude v šablonách prázné místo.',

    'already' => 'Toto jméno je již používáno',
    'int' => 'Vnitřní jméno musí být delší než 3 znaky',
    'short_disp' => 'Zobrazené jméno musí být delší než 3 znaky',
);


$lang['bookmarklets'] = array (
    'bookmarklets' => 'Bookmarklety',
    'bm_add' => 'Přidat bookmarklet.',
    'bm_withlink' => 'Nový Pivot',
    'bm_withlink_desc' => 'Bookmarklet otevře nové okno se záznamem, který bude obsahovat odkaz na stránku, ze které byl otevřen.',

    'bm_nolink' => 'Nový Pivot',
    'bm_nolink_desc' => 'Bookmarklet otevře okno s prázdným záznamem.',

    'bookmarklets_info' => 'Bookmarklety můžete použít k rychlému vkládání nových záznamů do Pivotu. Pro vložení bookmarkletu do vašeho prohlížeče postupujte následovně (postup se může mírně lišit podle použitého prohlížeče)',
    'bookmarklets_info_1' => 'Klikněte a přetáhněte bookmarklet do vaší lišty s odkazy nebo na tlačítko \'Bookmarks\' (Záložky).',
    'bookmarklets_info_2' => 'Pravým myšítkem klikněte na bookmarklet a vyberte \'Add to Bookmarks\' (Přidat do záložek).',
);

// Accessibility
// These are used for form fields, labels, fieldsets etc.
// for Web Content Accessibility Guidelines & 508 compliancy issues.
// see: http://bobby.watchfire.com/bobby/html/en/index.jsp
// JM =*=*= 2004/10/04
$lang['accessibility'] = array(
	'search_idname'      => 'hledat',
	'search_formname'    => 'Hledání slov v záznamech',
	'search_fldname'     => 'Zde vložte hledaná slova:',
	'search_placeholder' => 'hledaný termín',

	'calendar_summary'   => 'Tato tabulka reprezentuje záznmy kalendáře pro weblog s odkazy na záznamy příslušící k datům.',
	'calendar_noscript'  => 'Kalendář slouží k přístupu k záznamům weblogu.',
	/*
	2-letter language code, used to designate the principal language used on the site
	see: http://www.oasis-open.org/cover/iso639a.html
	*/

	'lang' => $langname,
) ;


$lang['snippets_text'] = array (
    'word_plural'     => 'slova',
    'image_single'    => 'obrázek',
    'image_plural'    => 'obrázky',
    'download_single' => 'soubor',
    'download_plural' => 'soubory',
);

$lang['trackback'] = array (
    'noid'      => 'Žádné stopovací ID (tb_id)',
    'nourl'     => 'Žádné URL (url)',
    'noping'    => 'Žádný URL ping',
    'tburl'     => 'Stopovací URL pro tento záznam',
    'delete'    => '[SMAZAT]',
    'yoursite'  => 'Je to vaše stránka?',
    'todelete'  => ' smazání pingů.',
    'login'     => 'Přihlášení',
    'logout'    => 'Odhlášení',
    'sendping'  => 'Poslat ping',
    'unaut'     => 'Nejste autorizován',
    'pinged'    => 'Ping úspěšně odeslán',
    'notpinged' => 'Chyba: Nejde ping na url',
    'invalid'   => 'Neplatné přihlášení',
    'disabled'  => 'Přihlašování zakázáno',
    'loggedout' => 'Odhlášen',
    'tracked'   => 'Stopován',
    'pass'      => 'Heslo',
    'email_subject' => '[Stopování] nové stopování',
    'email_txt' => 'Někdo zanechal nové stopování na vašich stránkách',
    
    'register' => "Váš trackback byl uložen.",
    'duplicate' => "Váš trackback nebyl uložen, protože vypadá jako kopie předchozího záznamu.",
    'too_many_hrefs' => "Maximální počet odkazů překročen. Prosím přestaňte spamovat.",
);

$lang['commentuser'] = array (
    'title'             => 'Přihlásit uživatele Pivotu',
    'header'            => 'Přihlasit registrovaného návštěvníka',
    'logout'            => 'Odhlásit',
    'loggedout'         => 'Odhlášen',
    'login'             => 'Přihlásit',
    'loggedin'          => 'Přihlášen',
    'loggedinas'        => 'Přihlášen jako',
    'pass_forgot'       => 'Zapoměli jste heslo?',
    'register_new'      => 'Registrovat nového uživatele.',
    'register'          => 'Registrovat nového návštěvníka',
    'register_info'     => 'Prosím vyplňte následující informace. <strong>Ujistěte se, že jste zadali platnou emailovou adresu</strong>, protože na ni bude odeslána žádost o potvrzení.',
    'pass_note'         => 'Pozn.: Správce těchto stránek má možnost<br /> vidět vaše heslo.. <em>Nepoužívejte</em> heslo,<br /> které používáte jinde!',
    'show_email'        => 'Ukázat moji emailovou adresu s komentářem',
    'notify'            => 'Upozorňovat na nové příspěvky emailem',
    'def_notify'        => 'Forma upozorňování na odpovědi',
    'register'          => 'Registovat',
    'pass_invalid'      => 'Nesprávné heslo',
    'nouser'            => 'Neexistující uživatel..',
    'change_info'       => 'Zde můžete změnit své informace.',
    'pref_edit'         => 'Editovat nastavení',
    'pref_change'       => 'Změnit nastavení',
    'options'           => 'Možnosti',
    'user_exists'       => 'Uživatel již existuje.. Prosím vyberte si jiné jméno.',
    'email_note'        => 'Musíte zadat emailovou adresu, jinak nebude možné ověřit váš účet. Vždy můžete vybrat neukazovat adresu ostatním návštěvníkům.',
    'stored'            => 'Změny byly uloženy',
    'verified'          => 'Váš účet je ověřen. Prosím přihlašte se..',
    'not_verified'      => 'Nesprávný kód. Bohužel není možné provést ověření.',
    'pass_sent'         => 'Heslo bylo odesláno do vaší schránky.',
    'user_pass_nomatch' => 'Tento uživatel a emailová adresa si neodpovídají.',
    'pass_send'         => 'Poslat heslo',
    'pass_send_desc'    => 'Pokud jste zapoměli heslo, vyplňte vaše uživatelské jméno a emailovou adresu. Pivot vám zašle vaše heslo na daný email.',
    'oops'              => 'Oops',
    'back'              => 'Zpět na',
    'back_login'        => 'Zpět na přihlášení',

    'user_disabled' => "Uživatel zakázán",
    'user_stored' => "Uživatel uložen",
    'user_stored_failed' => "Uložení uživatele se nezdařilo!",
    'forgotten_pass_mail' => "Vaše zapomenuté heslo pro uživatelské jméno '%name%' v Pivotu je: \n\n%pass%\n\nNezapomeňte ho znovu prosím!.\n\nPro přihlášení klikněte na následující odkaz: \n %link%",
    'registered' => "Jste v Pivotu registrován jako uživatel '%s'",
    'reg_confirmation' => "Potvrzení registrace",
    'reg_verify_short' => "Ověření vašeho účtu",
    'reg_verify_long' => "K ověření vašeho účtu klikněte na následující odkaz: %s",
    'reg_verification' => "Ověření pomocí emailu bylo odesláno na %s. Prosím zkontrolujte během pár minut svou poštu k ověření vašeho účtu.",

);

// A little tool to help you check if the file is correct..
if (count(get_included_files())<2) {

    $groups = count($lang);
    $total = 0;
    foreach ($lang as $langgroup) {
        $total += count($langgroup);
    }
    echo "<h2>Jazykový soubor je v pořádku!</h2>";
    echo "Tento soubor obsahuje $groups skupin a celkem $total nápisů.";

}

?>
