<?php

/**
 * Thickbox is javascript image viewer, made by Cody Lindley -
 * http://www.codylindley.com/
 * This pivot extension allows easy insertion of 'thickboxed' popups in your
 * Pivot weblog.
 *
 * For instructions, see this page on the wiki:
 * http://pivotlog.net/wiki/doku.php?id=lightbox_extensions
 *
 * @author Cody Lindley(original script) and Bob den Otter (Pivot Extension)
 * @version 2.1
 * @see http://jquery.com/demo/thickbox/#
 * @see http://www.pivotlog.net/docs/doku.php?id=extensions:thickbox
 *
 */



/**
 * Insert a 'thickboxed' image popup.
 *
 * We're using a trick to insert the needed scripts. If you call it using
 * [[thickbox:head]] it will insert the needed files for you.
 *
 * @param string $filename
 * @param string $thumbname
 * @param string $alt
 * @param string $align
 * @param string $border
 * @return string HTML
 *
 */
function snippet_thickbox($filename, $thumbname="",  $alt="", $align="center", $border="") {
	global	$Cfg, $Paths, $lightboxheadincluded, $db;

	/**
	 * Special case: if $filename is 'head', we return the code that goes into
	 * the <head> section of the page.
	 */
	if ($filename=="head") {
		return snippet_thickbox_head();
	}

	if (is_numeric($align)) {
		// the border and align properties were swapped, so we need
		// to compensate for the wrong ones.
		$i = $border;
		$border = $align;
		$align = $i;
	}

	if ( ($border=="") || (!is_numeric($border)) ) { $border=1; }

	$border= set_target("style=\"border: ".$border."px solid;\"", "border=\"$border\"");

	// Fix filename, if necessary
	$org_filename = $filename;

	if (!file_exists("../".$filename)) {
		$filename = "../".$Cfg['upload_path'].$filename;
	} else {
		$filename = "../".$filename;
	}

	// Fix Thumbname, perhaps use a thumbname, instead of textual link
	$org_thumbname = $thumbname;
	if ( ($thumbname=="") || ($thumbname=="(thumbnail)") ) {
		$thumbname = make_thumbname($org_filename);
	}
	if (!file_exists("../".$thumbname)) {
		$thumbname = "../".$Cfg['upload_path'].$thumbname;
	} else {
		$thumbname = "../".$thumbname;
	}

	// If the thumbnail exists, make the HTML for it, else just use the text for a link.
	if (file_exists($thumbname)) {
		$thumbname = $Paths['host'] . fixpath( $Paths['pivot_url'].$thumbname);

		$ext=getextension($thumbname);
		if ( ($ext=="jpg")||($ext=="jpeg")||($ext=="gif")||($ext=="png") ) {
			if ($align=="center") {
				$thumbname="<img src=\"$thumbname\" $border alt=\"$alt\" title=\"$alt\"  class='pivot-popupimage'/>";
			} else {
				$thumbname="<img src=\"$thumbname\" $border alt=\"$alt\" title=\"$alt\" align=\"$align\" class='pivot-popupimage' />";
			}
		} else {
			$thumbname = $org_thumbname;
		}
	} else {
		if (strlen($org_thumbname)>2) {
			$thumbname = $org_thumbname;
		} else {
			$thumbname = "popup";
		}
	}


	if( file_exists( $filename )) {

		$filename = $Paths['host'].fixpath( $Paths['pivot_url'].$filename ) ;

		$code = sprintf( "<a href='%s' class=\"thickbox\" title=\"%s\" rel=\"entry-%s\" >%s</a>",
				$filename,
				$alt,
				$db->entry['code'],
				$thumbname
			);

		if( 'center'==$align ) {
			$code = '<p style="text-align:center;">'.$code.'</p>' ;
		}
	} else {
		$code = "<!-- error: could not popup  $filename. File does not exist -->";
	}

	if (!$lightboxheadincluded) {
		$code = "<!-- error: You haven't included [[ thickbox:head ]] in your templates. -->". $code;
	}

	return $code;
}


/**
 * Insert the HTML that goes into the <head> section that includes the js and
 * css files.
 *
 * @return unknown
 */
function snippet_thickbox_head() {
	global $Paths, $lightboxheadincluded, $template_html;

	// Get the head section of the template..
	list($head) = explode("</head>", $template_html);

	// Determine if we can use jquery or not..
	if ( (preg_match("/prototype[a-z0-9_\.-]*\.js/i", $head)) || (preg_match("/lightbox\.js/i", $head)) ) {

		// We use prototype, so we can't use Jquery..
		$html = "<!-- Pivot can't include Thickbox/jquery, because prototype is used. -->\n";

	} else {

		// Lightbox script and CSS..
		$html = "<!-- Includes for Thickbox script -->\n";

		$html .= "<script type=\"text/javascript\">var tb_pathToImage = \"". $Paths['extensions_url'] ."thickbox/loadingAnimation.gif\";</script>\n";



		if (!preg_match("/jquery[a-z0-9_\.-]*\.js/i", $head)) {
			// We need to include Jquery
			$html .= sprintf("<script type=\"text/javascript\" src=\"%sincludes/js/jquery.js\"></script>\n",
				$Paths['pivot_url'] );
		}

		$html .= sprintf("<script type=\"text/javascript\" src=\"%sthickbox/thickbox.js\"></script>\n",
			$Paths['extensions_url'] );
		$html .= sprintf("<link rel=\"stylesheet\" href=\"%sthickbox/thickbox.css\" type=\"text/css\" media=\"screen\" />\n",
			$Paths['extensions_url'] );

	}


	$lightboxheadincluded = true;

	return $html;

}


?>
