<?php
//&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081; (Russian) (UTF-8)

//the above line is needed so that pivot knows how to display it in the user info.
//it also needs to be on the 2rd line.

// Russian translation of Pivot lang file (cyrilic)
// Original translation by Mikhail M. Pigulsky.
// Updated by Davron A. (Email - davron.ru@gmail.com, Website - http://davron.ru)

// allow for different encoding for non-western languages
$encoding="utf-8";
$langname="ru";

//		General		\\
$lang['general'] = array (
	'yes' => 'Да',	//affirmative
	'no' => 'Нет',		//negative
	'go' => 'Пошел!',	//proceed

	'minlevel' => 'У вас нет прав для этой части Pivot\'a',
	'email' => 'Email',
	'url' => 'URL',
	'further_options' => "Дополнительные Возможности",
	'basic_view' => "Обычный вид",
	'basic_view_desc' => "Показать только основные поля",
	'extended_view' => "Продвинутый вид",
	'extended_view_desc' => "Показать все изменяемые поля",
	'toggle_view' => "Между Продвинутым и Обычным Видами",
	'select' => "Выбрать",
	'cancel' => "Отмена",
	'delete' => 'Удалить',
	'edit' => 'Изменить',
	'welcome' => "Добро пожаловать в %build%.",
	'write' => "Записать",
	'write_open_error' => "Ошибка записи. Не открыть файл для записи",
	'write_write_error' => "Ошибка записи. Не возможно записать в файл",
	'done' => "Готово!",
	'shortcuts' => "Ярлыки",
	'cantdelete' => "Вам запрещено удалить запись %title%!",
	'cantdothat' => "Вам заперещено делать такое с записью %title%!",
	'cantdeletelast' => "Вы не можете удалять последнюю запись. Вы должны сначала записать другую",
);


$lang['userlevels'] = array (
		'Главный Владелец', 'Админ', 'Продвинутый', 'Нормальный', 'МобЛоггер'
		//  this one might be a bit hard to translate, but basically it's an order of
		//  power or trust.  Superadmin would be the person in charge - no one can do
		//  anything about his decisions. Admin is only regulated by the Superadmin,
		//  Advanced by the Admin and Superadmin, etc..
		//  Just get the idea of it.
);


$lang['numbers'] = array (
	'ноль', 'один', 'два', 'три', 'четыре', 'пять', 'шесть', 'семь', 'восемь', 'девять', 'десять', 'одиннадцать', 'двинадцать', 'тринадцать', 'четырнадцать', 'пятнадцать', 'шеснадцать'
);


$lang['months'] = array (
	'Январь', 'Февраль', 'Март', 'Апрель', 'Май', 'Июнь', 'Июль', 'Август', 'Сентябрь', 'Октябрь', 'Ноябрь', 'Декабрь'
);


$lang['months_abbr'] = array (
	'Янв', 'Фев', 'Мар', 'Апр', 'Май', 'Июн', 'Июл', 'Авг', 'Сен', 'Окт', 'Ноя', 'Дек'
);


$lang['days'] = array (
	'Воскресенье', 'Понедельник', 'Вторник', 'Среда', 'Четверг', 'Пятница', 'Суббота'
);


$lang['days_abbr'] = array (
	'Вск', 'Пнд', 'Втр', 'Срд', 'Чтв', 'Пт', 'Сб'
);


$lang['days_calendar'] = array (
	'В', 'П', 'В', 'С', 'Ч', 'П', 'С'
);


$lang['datetime_words'] = array (
	'Год', 'Месяц', 'Неделя', 'День', 'Час', 'Минута', 'Секунда'	//the actual words for them.
);


//		Login Page		\\
$lang['login'] = array (
	'title' => 'Логин',
	'name' => 'Имя Пользователя',
	'pass' => 'Пароль',
	'remember' => 'Запомнить',
	'rchoice' => array (
		'0' => 'Ничего',
		'1' => 'Мое Имя и Пароль',
		'2' => 'Что я всегда аторизован'
	),
	'delete_cookies_desc' => 'Если Вы уверены что имя и пароль правельны, но Вы <br />не можете войти, то попробуйте удалить куки (cookies) для данного домена:',
	'delete_cookies' => 'Удалить Куки',
	'retry' => 'Неверное Имя/Пароль',
	'banned' => 'Вы не смогли войти при 10-ти попытках. В результате, Ваш IP заблокирован на 12 часов (ЖРИ СУКА)',

);


//		Main Bar		\\
	$lang['userbar'] = array (
	'main' => 'Главное',
	'entries' => 'Записи',
	'submit' => 'Новая запись',
	'comments' => 'Комментарии',
	'trackbacks' => 'ТрэкБэки',
	'modify' => 'Изменить Записи',
	'userinfo' => 'Мои Данные',
	'u_settings' => 'Мои Настройки',
	'u_marklet' => 'Ярлыковые Ссылки',
	'files' => 'Управление картинок',
	'upload' => 'Выгрузить',
	'stats' => 'Статистика',
	'admin' => 'Администрация',

	'main_title' => 'Глобальный просмотр Pivot\'а',
	'entries_title' => 'Глобальный просмотр записей',
	'submit_title' => 'Написать и опубликовать новую запись',
	'comments_title' => 'Изменить или удалить записи',
	'trackbacks_title' => 'Изменить или удалить ТрэкБэки',
	'modify_title' => 'Изменить Запись',
	'userinfo_title' => 'Просмотр информации о себе',
	'u_settings_title' => 'Правка личных настроек',
	'u_marklet_title' => 'Создать закладки',
	'files_title' => 'Управление и закачка файлов',
	'upload_title' => 'Загрузить файлы',
	'uploaded_success' => 'Файл был загружен',
	'stats_title' => 'Просмотр логов и статистики.',
	'updatetitles_title' => 'Просмотр логов и статистики.',
	'admin_title' => 'Осмотр администрирования',
	'recent_entries' => 'Последние записи',
	'recent_comments' => 'Последние комментарии',
);


$lang['adminbar'] = array (
	//		Admin Bar		\\
	//'trebuild' => 'Rebuild all Files', rolled into maintenance
	'seeusers' => 'Пользователи',
	'seeconfig' => 'Настройки',
	'templates' => 'Шаблоны',
	'maintenance' => 'Операции',
	'regen' => 'Переделать все файлы',
	'blogs' => 'Веблоги',
	'categories' => 'Категории',
	'verifydb' => 'Проверить базу данных',
	'buildindex' => 'Переделать индекс',
	'buildsearchindex' => 'Переделать базу данных поисковой системы',
	'buildfrontpage' => 'Переделать заглавную(ые) страницу(ы)',
	'sendping' => 'Отправить пинги',


	'backup' => 'Резервная копия',
	'description' => 'Описание',
	'conversion' => 'Конвертировать',
	'seeusers_title' => 'Создание, правка и удаление пользователей.',
	'userfields' => 'User Information Fields',
	'userfields_title' => 'Создание, правка и удаление пользовательских полей',
	'seeconfig_title' => 'Изменить конфигурационный файл',
	'templates_title' => 'Создание, правка и удаление шаблонов',
	'maintenance_title' => 'Выполнение рутиных операций с файлами Pivot\'а',
	'regen_title' => 'Переделать файлы и архивы которые создает Pivot',
	'blogs_title' => 'Создание, правка и удаление веблогов',
	'blogs_edit_title' => 'Изменить настройки веблога для ',
	'categories_title' => 'Создание, правка и удаление категорий',
	'verifydb_title' => 'Проверить правильности базы данных',
	'buildindex_title' => 'Переделать индекс базы данных',
	'buildsearchindex_title' => 'Переделайте индекс базы данных, для поиска',
	'buildfrontpage_title' => 'Переделать заглавные файлы, последние архивы и RSS ленту для каждого

веблога.',
	'backup_title' => 'Создать резервную копию Ваших записей',
	'backup_config' => 'Создать резервную копию Ваших настроек',
	'backup_config_desc' => 'Это дает возможность скачать Zip-Файл с резервными файлами',
	'ipblocks' => 'IP блокировки',
	'ipblocks_title' => 'Просмотреть или изменить Заблокированные IP-адреса.',
	'ipblocks_stored' => 'IP-Адреса записаны и сохранены.',
	'ipblocks_store' => 'Сохранить IP-адреса',
	'ignoreddomains' => 'Блокировать Фразы',
	'ignoreddomains_title' => 'Заблокировать Фразы во входящих ссылках против спама',
	'ignoreddomains_stored' => 'Запрещенные Фразы записаны.',
	'ignoreddomains_store' => 'Сохранить список запрещенных фраз',
	'ignoreddomains_asterisk' => 'Строка помеченная звездочкой ( * ) будет только для блокировки входящийх ссылок (реферреров). Остальные будут для блокировки Входящих Ссылок (реферреров), комментариев и ТрэкБэков ',
	'fileexplore' => 'Просмотрщик Файлов',
	'fileexplore_title' => 'Посмотреть файлы (базы данных и текстовые)',
	'sendping_title' => 'Отправить пинги Трэкерам обновлений.',
	'buildindex_start' => 'Обновляется индекс. Для этого потребуется некоторое время, пожалуйста не прерывайте.',
	'buildsearchindex_start' => 'Обновление базы поиска. Для этого потребуется некоторое время, пожалуйста не прерывайте.',
	'buildindex_finished' => 'Готово! Регенерация заняла %num% секунд',

	'filemappings_desc' => 'Ниже Вы можете посмотреть на все Вэблоги созданные Pivot\'ом, Вы можете выбрать отдельные файлы наблонов для каждого блога и менять настройки. Это может помочь с проблемами фалов и ошибок в блогах.',

	'debug' => 'Открыть DEBUG-окно',

	'latest_pivot_news' => "Последние Новости от Pivot",
	'remove_setup_header' => "Скрипт Pivot-инсталлятора представляет",
	'remove_setup' => "Инсталлятор Pivot\'a 'pivot-setup.php' до сих пор находится в корневой папке. Для Вашей безопасности, удалите файл или же переименуйте",

);


$lang['templates'] = array (
	'rollback' => 'Откатать',
	'create_template' => 'Создать шаблон',
	'create_template_info' => 'Создать шаблон для Pivot\'a с нуля',
	'no_comment' => 'Нет Комментариев',
	'comment' => 'Комментарий*',
	'comment_note' => '(*Заметка: Комментарий может быть сохранен только при <b>первой</b> записи или изменении)',
	'create' => 'Создать шаблон',
	'editing' => 'Изменение',
	'filename' => 'Название Файла',
	'save_changes' => 'Сохранить настройки!',
	'save_template' => 'Сохранить шаблон!',
	'aux_template' => 'Вспомогательный шаблон',
	'sub_template' => 'ПодШаблон',
	'standard_template' => 'Нормальный Шаблон',
	'feed_template' => 'Шаблон ленты',
	'css_template' => 'CSS файл',
	'txt_template' => 'Текстовый файл',
	'php_template' => 'PHP файл',
);


//		Admin			\\
// bob notes: Mark made these, i think they should be replaced by the 'adminbar']['xxx_title'] ones
$lang['admin'] = array (
	'seeusers' => 'Создание, правка и удаление пользователей',
	'seeconfig' => 'Правка файла настроек',
	'templates' => 'Создание, правка и удаление шаблонов',
	'maintenance' => 'Выполнение рутиных операций Pivot\'а над файлами, например \'Переделать файлы\',

\'Сверить базу данных\', \'Переделать индекс\' и \'Создание резервной копии\'.',
	'regen' => 'Переделать все страницы которые создает Pivot',
	'blogs' => 'Создание, правка и удаление различных веблогов в которые будет писать Pivot',
);

//		Maintenace		\\
$lang['maint'] = array (
	'title' => 'Операции',
	'gen_arc_title' => 'Сгенерировать архив', /* bob notes: redundant, see 'regen' */
	'gen_arc_text' => 'Перегенерировать все архивы', /* bob notes: redundant, see 'regen' */
	'xml_title' => 'Проверить XML файлы', /* bob notes: replace with more general 'Verify DB' */
	'xml_text' => 'Проверить (и починить, если надо) правильность всех XML файлов', /* bob notes:

replace with more general 'Verify DB' */
	'backup_title' => 'Резервная копия',
	'backup_text' => 'Сделать резервную копию всех существенных файлов pivot\'а',
);


//      Stats and referers      \\
$lang['stats'] = array (
	'show_last' => "Показать последние",
	'20ref' => "20 реферреров",
	'50ref' => "50 реферреров",
	'allref' => "всех реферреров",
	'updateref' => "Обновить список реферреров в титуле",
	'hostaddress' => 'Хост (ip-адрес)',
	'which page' => 'которая страница',

	'getting' => 'Получаем новые заголовки',
	'awhile' => 'Это может занять некторое время, пожалуйста подождите',
	'firstpass' => 'Первый проход',
	'secondpass' => 'Второй проход',
	'nowuptodate' => 'Все реферреры-заголовки обновлены',
	'finished' => 'Закончено',
);


//		User Info		\\
	$lang['userinfo'] = array (
	'editfields' => 'Правка полей',
	'desc_editfields' => 'Правка полей которые пользователи могут использовать чтобы описАть себя',
	'username' => 'Пользователь',
	'pass1' => 'Пароль',
	'pass2' => 'Пароль (еще раз)',
	'email' => 'Email',
	'userlevel' => 'Уровень пользователя',
	'userlevel_desc' => 'Уровень пользователя определяет какие действия он может производить',
	'language' => 'Язык',
	'edituser' => 'изменение пользователя',  //the link to.. well, edit the user (also the title)
	'edituserinfo' => 'Правка информации о пользователе',
	'newuser' => 'Создать нового пользователя',
	'desc_newuser' => 'Создать новый аккаунт для Pivot\'а, позволяющий постить в веблог.',
	'newuser_button' => 'Создать',
	'edituser_button' => 'Изменить',
	'pass_too_short' => 'Пароль должен быть как минимум из 4 знаков.',
	'pass_dont_match' => 'Пароли не совпадают',
	'username_in_use' => 'Такой пользователь уже существет',
	'username_too_short' => 'Имя пользователя должно состоять из 3 символов или более',
	'username_not_valid' => 'Имя пользователя должно содержать только латинские буквы и цифры (A-Z, a

-z, 0-9) и символ подчеркивания (_).',
	'not_good_email' => 'Введенный e-mail неправильный',
	'c_admin_title' => 'Подтвердите создание администратора',
	'c_admin_message' => ''.$lang['userlevels']['1'].' имеет полный доступ к pivot\'у, может изменять

все новостные предметы, все комментарии и изменять любые настройки. Вы уверены что хотите сделать %s

'.$lang['userlevels']['1'].'?',
);


//		Config Page		\\
	$lang['config'] = array (
	'save' => 'Сохранить настройки',

	'sitename' => 'Название сайта',
	'defaultlanguage' => 'Язык по-умолчанию',
	'siteurl' => 'URL сайта',
	'header_fileinfo' => 'Инфо о файле',
	'localpath' => 'Локальный путь',
	'debug_options' => 'Настройки debug режима',
	'debug' => 'Debug режим',
	'debug_desc' => 'показывать различную debug информацию то там, то ту...',
	'log' => 'Логфайлы',
	'log_desc' => 'хранить логфайлы различных действий',

	'header_uploads' => 'Загрузка файлов',
	'upload_path' => 'Путь для загрузки файлов',
	'upload_accept' => 'Разрешенные типы файлов',
	'upload_extension' => 'Расширение по-умолчанию',
	'upload_save_mode' => 'Переписывать',
	'make_safe' => 'Чистить имена файлов',
	'c_upload_save_mode' => 'Увеличивать число в названии файла',
	'max_filesize' => 'Размер файла',
	'header_datetime' => 'Дата/Вермя',
	'timeoffset_unit' => 'Единица отставания',
	'timeoffset' => 'Кол-во',
	'header_extra' => 'Различные настройки',
	'wysiwyg' => 'Использовать WYSIWYG по-умолчанию',
	'wysiwyg_desc' => 'Определяет включен ли по-умолчанию редактор \'что вижу то и получу\'. Все

пользователи могут изменить этот пункт в своих личных настройках',
	'def_text_processing' => 'Default Text Processing',
	'text_processing' => 'Text Processing',
	'text_processing_desc' => 'Determines the default text processing, when a user is using the non-

wysiwyg editor. \'Convert Linebreaks\' does nothing more than change linebreaks to a &lt;br&gt;-tag. <a

href="http://www.textism.com/tools/textile/" target="_blank">Textile</a> is a powerful, yet easy to learn

markup style.',
	'none' => 'None',
	'convert_br' => 'Convert Linebreaks to &lt;br /&gt;',
	'textile' => 'Textile',

	'setup_ping' => 'Настройки пинга',
	'ping_use' => 'Обновлять пинг-тракеры',
	'ping_use_desc' => 'Определяет должны ли тракеры вида weblogs.com автоматически обновляться

Pivot\'ом если вы делаете новую запись. Сервисы типа blogrolling.com зависят от этих пингов',
	'ping_urls' => 'Ссылки для пингов',
	'ping_urls_desc' => 'Вы можете представить несколько ссылок для пингов. Не вписывайте http://,

иначе это все не будет работать. Просто вписывайте каждый сервер на новой строке ли разделяйте их символом

<b>-</b> . Некоторые сервера для пингования:<br /><b>rpc.weblogs.com/RPC2</b> (weblogs.com пингер, самый

распростарненный)<br /><b>pivotlog.net/pinger</b> (pivotlog пингер, пока что не работает)<br

/><b>rcs.datashed.net/RPC2</b> (euro.weblogs.com пингер)<br /><b>ping.blo.gs</b> (blo.gs пингер)<br />',

	'new_window' => 'Открывать ссылки в новом окне',
	'emoticons' => 'Использовать графические смайлы',
	'javascript_email' => 'Кодировать Email адреса?',
	'new_window_desc' => 'Определяет открывать ссылки в новом окне или в том же.',

	'mod_rewrite' => 'Использовать Filesmatch',
	'mod_rewrite_desc' => 'Если вы используете Apache\'s Filesmatch, Pivot будет делать ссылки вида

www.mysite.com/archive/2003/05/30/nice_weather, вместо www.mysite.com/pivot/entry.php?id=134. Не все

сервера поддерживают данный модуль, так что используйте это только после прочтения мануала.',
	'search_index' => 'Обновить индкс поиска',
	'search_index_desc' => 'Dit bepaalt of de zoekindex altijd wordt bijgewerkt als je een nieuw

artikel plaatst, of een artikel wijzigt.',

	'default_introduction' => 'Интродукция/тело по умолчанию',
	'default_introduction_desc' => 'This will determine the default values for Introduction and Body

when an author writes a new entry. Normally this will be an empty paragraph, which makes the most sense

semantically.',

	'upload_autothumb'	=> 'Автоматические эскизы',
	'upload_thumb_width' => 'Ширина Эскиза',
	'upload_thumb_height' => 'Высота Эскиза',
	'upload_thumb_remote' => 'Скрипт Обработки изображений на другом сервере',
	'upload_thumb_remote_desc' => 'Если ваш сервер не поддерживает обработку изображений, то можно использовать скрипт другого сервера',

	'extensions_header' => 'Директория для Дополнений',
	'extensions_desc'   => 'Папка \'extensions\' (дополнения) это файлы для дополнений Pivot\'a.
		Это делает обновление намного легче. Читайте документацию для подробностей.',
	'extensions_path'   => 'Директория Дополнений',

);


//		Weblog Config	\\
$lang['weblog_config'] = array (
	'edit_weblog' => 'Правка веблога',
	'edit_blog' => 'Правка блогов',
	'new_weblog' => 'Новый веблог',
	'new_weblog_desc' => 'Добавить новый веблог',
	'del_weblog' => 'Удалить веблог',
	'del_this_weblog' => 'Удалить этот веблог.',
	'create_new' => 'Создать новый веблог',
	'subw_heading' => 'Для каждого подблога найденного в шаблонах вы можете указать какой шаблон для

них использовать, а так же категории которые будет в них отображаться',
	'create' => 'Закончить',

	'create_1' => 'Создание / правка веблога, шаг 1 из 3',
	'create_2' => 'Создание / правка веблога, шаг 2 из 3',
	'create_3' => 'Создание / правка веблога, шаг 3 из 3',

	'name' => 'Название веблога',
	'payoff' => 'ПэйОфф',
	'payoff_desc' => 'Пэйофф может быть использован как подзаголовок или как краткое описание вашего

веблога',
	'url' => 'URL к веблогу',
	'url_desc' => 'Pivot сам определит ссылку на веблог если вы оставите это поле пустым. Если вы

используете свой веблог как часть фрейма, или включение со стороны сервера, вы можете использовать это

поле для переписи.',
	'index_name' => 'Главная страница (индекс)',
	'index_name_desc' => 'Имя индекс-файла. Обычно это что-то вроде \'index.html\' или

\'index.php\'.',

	'ssi_prefix' => 'Префикс SSI',
	'ssi_prefix_desc' => 'Если ваш блог использует SSI (что не рекомендовано вы можете использвать

данное поле чтобы обозначит префикс файлов Pivot\'а для SSI. Например \'index.shtml?p=\'. Оставьте поле

пустым если не знаете что делаете.',

	'front_path' => 'Путь к заглавной странице',
	'front_path_desc' => 'Относительный или абсолютный путь к каталогу в котором Pivot будет создавать

главные страницы к блогу.',
	'file_format' => 'Имя файла',
	'entry_heading' => 'Настройки записей',
	'entry_path' => 'Путь записей',
	'entry_path_desc' => 'Относительный или абсолютный путь к каталогу в котором Pivot будет создавать

отдельные страницы для каждой записи (если вы выберите не использовать \'живые записи\')',
	'live_comments' => 'Живые записи',
	'live_comments_desc' => 'Если вы используете \'Живые записи\', Pivot не будет создавать отдельную

страницу для каждой записи. Это стоит по-умолчанию.',
	'readmore' => 'Текст для \'дальнейшего чтения\' записи',
	'readmore_desc' => 'Этот текст показывает что запись намного длиннее чем показано на главной

странице и предлагает ссылку для дальнейшего чтения. Если вы оставите поле пустым, будет использована

настройка из языкового файла.',

	'arc_heading' => 'Настройки архивов',
	'arc_index' => 'Главный файл',
	'arc_path' => 'Путь к архиву',
	'archive_amount' => 'Количество архивов',
	'archive_unit' => 'Тип архива',
	'archive_format' => 'Формат архива',
	'archive_none' => 'Не делать архивов',
	'archive_weekly' => 'Еженедельные архивы',
	'archive_monthly' => 'Месячные архивы',

	'archive_link' => 'Архивная ссылка',
	'archive_linkfile' => 'Файлс-сылка на архив',
	'archive_order' => 'Порядок архива',
	'archive_ascending' => 'Возрастание (старые вначале)',
	'archive_descending' => 'Убывание (новые вначале)',

	'templates_heading' => 'Шаблоны',
	'frontpage_template' => 'Шаблон главной страницы',
	'frontpage_template_desc' => 'Вид заглавной страницы этого блога.',
	'archivepage_template' => 'Шаблон страницы архивов',
	'archivepage_template_desc' => 'Вид станицы с архивами. Может быть таким же как и \'Шаблон главной

страницы\'.',
	'entrypage_template' => 'Шаблон записи',
	'entrypage_template_desc' => 'Вид страницы каждой отдельной записи.',
	'extrapage_template' => 'Extra-Шаблон',
	'extrapage_template_desc' => 'Показывает как будет показана страница search.php .',

	'shortentry_template' => 'Шаблон короткой записи',
	'shortentry_template_desc' => 'Вид записей в коротком виде в влоге и архивах.',
	'num_entries' => 'Количество записей',
	'num_entries_desc' => 'Сколько записей будет показано на главной странице.',
	'offset' => 'Offset',
	'offset_desc' => 'Если оффсету будет присвоен номер, то идентификаторы записей будут пропущены при регенерации. Вы можете использовать это чтобы создать \'Предыдущие записи\' list, for example.',
	'comments' => 'Позволить комментарии?',
	'comments_desc' => 'Определяет смогут ли пользователи оставлять комментарии.',

	'setup_rss_head' => 'Настройка RSS',
	'rss_use' => 'Использовать RSS',
	'rss_use_desc' => 'Определяет стоит ли Pivot\'у создавать RSS ленту для данного блога.',
	'rss_filename' => 'Файл с RSS лентой',
	'atom_filename' => 'Atom bestandsnaam',
	'rss_path' => 'Путь к RSS',
	'rss_path_desc' => 'Относительный или абсолютный путь к RSS ленте.',
	'rss_size' => 'Длина записи в RSS',
	'rss_size_desc' => 'Длина записи (кол-во символов) которая будет в RSS ленте',

	'lastcomm_head' => 'Настройки последних комментариев',
	'lastcomm_amount' => 'Сколько показывать',
	'lastcomm_length' => 'Вырезать при длине',
	'lastcomm_format' => 'Формат',
	'lastcomm_format_desc' => 'These settings determine the appearance of the \'last comments\' on the

weblog\'s frontpage.',

	'lastref_head' => 'Settings for Last Referers',
	'lastref_amount' => 'Сколько показывать',
	'lastref_length' => 'Обрывать при длине',
	'lastref_format' => 'Формат',
	'lastref_format_desc' => 'Эти настройки покажут вид \'Последние Реферреры\' на главной странице вэблога',

	'various_head' => 'Различные настройки',
	'emoticons' => 'Использовать граф. смайлы',
	'emoticons_desc' => 'Определяет следует ли текстовые смайлы наподобие :-) трансформировать в их

графический эквивалент.',
	'encode_email_addresses' => 'Кодировать Email адреса',
	'encode_email_addresses_desc' => 'Определяет будут ли email-дреса закодированы при помощи

javascript, для защиты от спам-ботов.',
	'target_blank' => 'Цель пуста',
	'xhtml_workaround' => 'XHTML Workaround',
	'target_blank_desc' => 'Если стоит в значении \'Да\', то все ссылки будут открываться в новом

окне.',

	'date_head' => 'Настройка отображения даты',
	'full_date' => 'Полный формат даты',
	'full_date_desc' => 'Определяет формат записи даты и времени. В основном используется в записях.',
	'entry_date' => 'Дата записи',
	'diff_date' => 'Различные даты',
	'diff_date_desc' => '\'Различные даты\' чаще всего используется в связке с  \'Датой записи\'. Дата

записи показывается в вашем логе, в то время как различные даты показываются только если есть отличие от

прошлой записи.',
	'language' => 'Язык',

	'comment_head' => 'Настройки комментариев',
	'comment_sendmail' => 'Отсылать по почте?',
	'comment_sendmail_desc' => 'После того как был оставлен комментарий, Pivot может отправить письмо

ведущему блога.',
	'comment_emailto' => 'Кому',
	'comment_emailto_desc' => 'Адрес(а) на которые будет отправлено сообщение об оставленном

комментарие. Несколько адресов следует разделить запятой.',
	'comment_texttolinks' => 'Текст в ссылки',
	'comment_texttolinks_desc' => 'Указывает, следует ли написанные адреса страниц и e-mail\'ов

переводить в ссылки.',
	'comment_wrap' => 'Переносить комментарий после',
	'comment_wrap_desc' => 'Чтобы очень длинные тексты не портили ваш дизайн, текст может быть

перенесен на новую строку после количества указанных знаков.',
	'comments_text_0' => 'запись для \'нет комментариев\'',
	'comments_text_1' => 'запись для \'один комментарий\'',
	'comments_text_2' => 'запись для \'комментариев - Х\'',
	'comments_text_2_desc' => 'Указывает на текст, который будет использован для отображения

количества оставленных комментариев. Если вы оставите эти поля пустыми, Pivot будет использовать записи из

файла языка',

	'comment_pop' => 'Комментарии в новом окне?',
	'comment_pop_desc' => 'Указывает, будут ли комментарии (или \'отдельные записи\') показываться в

новом окне или в оригинальном окне браузера.',
	'comment_width' => 'Ширина окна',
	'comment_height' => 'Высота окна',
	'comment_height_desc' => 'Указывает ширину и высоту (в пикселах)окна для комментариев.',

	'comment_format' => "Формат комментариев",
	'comment_format_desc' => "Это покажет вид последних комментариев",

	'comment_textile' => 'Разрешить Textile',
	'comment_textile_desc' => 'Если это значение стоит \'Да\', то посетители могут использовать <a

href="http://www.textism.com/tools/textile/" target="_blank">Textile</a> в их комментариях.',

	'saved_create' => 'Новый блог был успешно создан.',
	'saved_update' => 'Веблог обновлен.',
	'deleted' => 'Веблог был удален.',
	'confirm_delete' => 'Вы собираетесь удалить веблог %1. Вы уверены?',

	'blogroll_heading' => 'Свойства Blogroll',
	'blogroll_id' => 'Blogrolling ID #',
	'blogroll_id_desc' => 'Вы можете включить <a href="http://www.blogrolling.com"

target="_blank">blogrolling.com</a> blogroll на ваш блог. Blogrolling отличный способ показать ссылки, показывая последнее обновление. Если не хотите, то оставьте поле пустым. Если да: When you\'re logged in to blogrolling.com, go to \'get code\', there

you will find links containing your blogroll\'s ID #. Должно выглядить вроде этого:

2ef8b42161020d87223d42ae18191f6d',
	'blogroll_fg' => 'Цвет текста',
	'blogroll_bg' => 'Цвет фона',
	'blogroll_line1' => 'Цвет линии 1',
	'blogroll_line2' => 'Цвет линии 2',
	'blogroll_c1' => 'Цвет 1',
	'blogroll_c2' => 'Цвет 2',
	'blogroll_c3' => 'Цвет 3',
	'blogroll_c4' => 'Цвет 4',
	'blogroll_c4_desc' => 'Показывает цвета на сайте. Цвет 1 до цвета

4 показывает визуально как давно обновлена ссылка.',
);


$lang['upload'] = array (
	//		File Upload		\\
	'preview' => 'Весь список',
	'thumbs' => 'Предпросмотр эскизов',
	'create_thumb' => '(создать эскиз)',
	'title' => 'Файлы',
	'thisfile' => 'Загрузить новый файл:',
	'button' => 'Загрузить',
	'filename' => 'Имя файла',
	'thumbnail' => 'Эскиз',
	'date' => 'Дата',
	'filesize' => 'Размер',
	'dimensions' => 'Ширина x Высота',
	'delete_title' => 'Удалить изображение',
	'areyousure' => 'Вы уверены что хотите удалить файл %s?',
	'picheader' => 'Удалить данное изображение?',
	'create' => 'создать',
	'edit' => 'правка',

	'insert_image' => 'Вставить изображение',
	'insert_image_desc' => 'Чтобы вставить изображение, вы должны его загрузить или выбрать ранее

загруженное.',
	'insert_image_popup' => 'Вставить вскакивающее изображение',
	'insert_image_popup_desc' => 'Если вы хотите сделать вскакивающее окно с изображением, вам надо

выбрать изображение ли текст.',
	'choose_upload' => 'загрузить',
	'choose_select' => 'или выбрать',
	'imagename' => 'Название изображения',
	'alt_text' => 'Альтернативный текст',
	'align' => 'Положение',
	'border' => 'Рамка',
	'pixels' => 'пикселей',
	'uploaded_as' => 'Ваш файл был загружен как \'%s\'.',
	'not_uploaded' => 'Ваш файл не был загружен. Произошла следующая ошибка:',
	'center' => 'Центр (по умолчанию)',
	'left' => 'Лево',
	'right' => 'Право',
	'inline' => 'Внутри',
	'notice_upload_first' => 'Для начала вы должны выбрать или загрузить изображение',
	'select_image' => 'Выбрать изображение',

	'for_popup' => 'Для нового окна',
	'use_thumbnail' => 'Использовать эскиз',
	'edit_thumbnail' => 'править эскиз',
	'use_text' => 'Использовать текст',
	'insert_download' => 'Вставить Загрузку',
	'insert_download_desc' => 'Чтобы сделать файл для загрузки, вы должны выгрузить файл или выбрать ранее выгруженный файл. Затем выбрать текст или изображение для ссылки на загрузку',
	'use_icon' => 'Использовать иконку',
);


$lang['link'] = array (
	//		Link Insertion \\
	'insert_link' => 'Вставить ссылку',
	'insert_link_desc' => 'Для того, чтобы сделать ссылку, вам необходимо выделить текст. Посетители перейдут по ссылке при нажатии на нее.',
	'url' => 'URL',
	'title' => 'Заглавие',
	'text' => 'Текст',
);


//		Categories		\\
$lang['category'] = array (
	'edit_who' => 'Настроить тех кто может писать в категорию \'%s\'',
	'name' => 'Имя',
	'users' => 'Пользователи',
	'make_new' => 'Создать новую категорию',
	'create' => 'Создать категорию',
	'canpost' => 'Выберите пользователей, которым вы хотите разрешить писать в эту категорию',
	'same_name' => 'Категория с таким названием уже существует',
	'need_name' => 'Категория должна быть названа',

	'allowed' => 'Позволено',
	'allow' => 'Позволить',
	'denied' => 'Запрещено',
	'deny' => 'Запретить',
	'edit' => 'Править категорию',

	'delete' => 'Удалить категорию',
	'delete_desc' => 'Выберите \'Да\', для удаления записи',

	'delete_message' => 'В этом билде Pivot\'а категория будет просто удалена. В следующих же билдах

вы будете выбирать, что сделать с записями из данной категории.',
	'search_index_newctitle'   => 'Индексировать данную категорию',
	'search_index_newcdesc'    => 'Выберите \'Нет\' если не хотите чтобы посетители не могли искать в этой категории.',
	'search_index_editcheader' => 'Индексирование категории',

	'order' => 'Сортировка',
	'order_desc' => 'Категории будут сортироваться по списку, в нижнюю сторону. Если вы сохраните все номера, они будут сохраняться в алфавитном порядке',
	'public' => 'Публичная Категория',
	'public_desc' => 'Если выбрать \'Нет\', эта категория будет видна только для зарегистрированных посетителей. (только для "живых" страниц)',
	'hidden' => 'Скрытая категория',
	'hidden_desc' => 'если выбрать \'Да\', эта категория будет скрыта в архивах. (только для "живых" страниц)',

);


$lang['entries'] = array (
	'post_entry' => "Записать",
	'preview_entry' => "Пред-просмотр",

	'first' => 'первая',
	'last' => 'последняя',
	'next' => 'следующая',
	'previous' => 'предыдущая',
	'jumptopage' => 'Страница (%num%)',
	'filteron' => 'Фильтровать по (%name%)',
	'filteroff' => 'не фильтровать - off',
	'title' => 'Заголовок',
	'subtitle' => 'Подзаголовок',
	'introduction' => 'Вступление',
	'body' => 'Тело записи',
	'publish_on' => 'Число для записи',
	'status' => 'Статус',
	'post_status' => 'Статус отправки',
	'category' => 'Категория',
	'select_multi_cats' => '(Ctrl-клик чтобы выделить несколько категорий)',
	'last_edited' => "Последний раз правилось",
	'created_on' => "Создано",
	'date' => 'Дата',
	'author' => 'Автор',
	'code' => 'Код',
	'comm' => '# Comm',
	'allow_comments' => 'Позволить комментировать',
	'convert_lb' => 'Конвертировать переходы строк',
	'always_off' => '(всегда выключено когда в режиме wysiwyg)',
	'be_careful' => '(будьте осторожны с этим!)',
	'edit_comments' => 'Править комментарии',
	'edit_comments_desc' => 'Править комментарии оставленные для данной записи',
	'edit_comment' => 'Правка комментария',
	'delete_comment' => 'Удалить комментарий',
	'block_single' => 'Заблокировать IP %s',
	'block_range' => 'Заблокировать диапазон IP %s',
	'unblock_single' => 'Разблокировать IP %s',
	'unblock_range' => 'Разблокировать диапазон IP %s',
	'trackback' => 'Пинг ТрэкБэка',
	'trackback_desc' => 'отправить пинги следующим серверам url(s). для нескольких серверов, напишите на каждой строке.',
	'keywords' => 'Ключевые Слова',
	'keywords_desc' => 'Для создания ключевых слов для записи, для того чтобы добавить дополнительные слова для поиска записи.',
	'vialink' => "Виа-Линк",
	'viatitle' => "Виа-Заглавие",
	'via_desc' => 'Используйте это для источника ресурса.',
	'entry_catnopost' => 'Вам не разрешено делать запись в категории:\'%s\'.',
	'entry_saved_ok' => 'Ваша запись \'%s\' записана успешно.',
	'entry_ping_sent' => 'Ссылка ТрэкБэка отпингована \'%s\'.',
);


//		Form Fun		\\
$lang['forms'] = array (
	'c_all' => 'Отметить все',
	'c_none' => 'Снять отметку со всех',
	'choose' => '- выберите -',
	'publish' => 'Установить статус в \'опубликовано\'',
	'hold' => 'Установить статус в \'придержать\'',
	'delete' => 'Удалить их',
	'generate' => 'Опубликовать и сгенерировать',

	'with_checked_entries' => "С отмеченными записями сделать:",
	'with_checked_files' => "С отмеченными файлами сделать:",
	'with_checked_templates' => 'С отмеченными шаблонами сделать:',
);


//		Errors			\\
$lang['error'] = array (
	'path_open' => 'не могу открыть директорию, проверьте права.',
	'path_read' => 'не могу прочитать директорию, проверьте права.',
	'path_write' => 'не могу записать в директорию, проверьте права.',

	'file_open' => 'не могу открыть файл, проверьте права.',
	'file_read' => 'не могу прочитать файл, проверьте права.',
	'file_write' => 'не могу записать файл, проверьте права.',
);


//		Notices			\\
$lang['notice'] = array (
	'comment_saved' => "Комментарий сохранен.",
	'comment_deleted' => "Комментарий удален.",
	'comment_none' => "У записи нет комментарий.",
	'trackback_saved' => "ТрэкБэк сохранен.",
	'trackback_deleted' => "ТрэкБэк удален.",
	'trackback_none' => "У записи нет ТрэкБэков.",
);


// Comments, Karma and voting \\
$lang['karma'] = array (
	'vote' => 'Проголосовать \'%val%\' за эту запись',
	'good' => 'Хорошо',
	'bad' => 'Плохо',
	'already' => 'Вы уже голосовали за эту запись или опрос',
	'register' => 'Ваш голос \'%val%\' был записан',
);


$lang['comment'] = array (
	'register' => 'Ваш комментарий оставлен.',
	'preview' => 'Вы просматривайте вид комментария, но он пока не оставлен. Не забудьте нажать \'Оставить комментарий\', чтобы сохранить его.',
	'duplicate' => 'Комментарий не сохранен, Ваш предыдущий комментарий выглядит точно также.',
	'no_name' => 'Вы должны написать ваше имя или ник в поле \'Имя\'. Не забудьте нажать \'Оставить комментарий\', чтобы сохранить его.',
	'no_comment' => 'Вы должны написать что-либо для комментария. Не забудьте нажать \'Оставить комментарий\', чтобы сохранить его.',
	'too_many_hrefs' => 'Слишком много ссылок в Вашем комментарие. Мы не любим Спаммеров.',
    'email_subject' => '[Comment] Re:',
);


$lang['comments_text'] = array (
	'0' => "Нет комментариев",
	'1' => "%num% комментарий",
	'2' => "комментариев: %num%",
);

$lang['trackbacks_text'] = array (
	'0' => "Нет трэкбэков",
	'1' => "%num% трэкбэк",
	'2' => "%num% трэкбэков",
);

$lang['weblog_text'] = array (
	// these are used in the weblogs, for the labels related to archives
	'archives' => "Архивы / Archives",
	'next_archive' => "Следующий архив",
	'previous_archive' => "Предыдущий архив",
	'last_comments' => "Последние комментарии",
	'last_referrers' => "Входящие ссылки",
	'calendar' => "Календарь",
	'links' => "Меню",
	'xml_feed' => "RSS лента (2.0)",
	'powered_by' => "Поддержано ",
	'name' => "Имя",
	'email' => "Email",
	'url' => "URL",
	'date' => "Дата",
	'comment' => "Комментарий",
	'ip' => "IP адрес",
	'yes' => "Да",
	'no' => "Нет",
	'emoticons' => "Смайлы",
	'emoticons_reference' => 'Открыть Смайлики',
	'textile' => 'Тэги',
	'textile_reference' => 'Открыть Кодировку "Textile" - для продвинутых комментаторов.',
	'post_comment' => "Оставить комментарий (ok)",
	'preview_comment' => "Пред-просмотр",
	'remember_info' => "Запомнить меня",
	'disclaimer' => "<b>Информация:</b> Все кроме &lt;b&gt; и &lt;i&gt; удаляются из

комментария. Чтобы создать ссылку, напишите адрес или Email.",
	'search_title' => "Результаты поиска",
	'search' => " Go! ",
	'nomatches' => "Ничего не найдено по запросу '%name%'. Попробуйте поискать что нибудь ещё, уверен

что Вы найдёте кое что полезное или интересное, ключевые слова находятся в теле записи, не в его заголовке.",
	'matches' => "Результаты поиска для '%name%':",
	'about' => "Информация",
	'stuff' => "Начинка",
	'linkdump' => "Свежие записи",
	'discreet' => "Скрыть email",
	'discreet_yes' => "Да, скрыть мой email.",
);


$lang['ufield_main'] = array (
	//		Userfields		\\
	'title' => 'Правка пользовательских полей',
	'edit' => 'Правка',
	'create' => 'Создать',

	'dispname' => 'Отображаемое имя',
	'intname' => 'Внутренне имя',
	'intname_desc' => 'Внутренне имя это имя предмета который вы захотите чтобы он отразился. Оно

будет показано в шаблонах.',
	'size' => 'Размер',
	'rows' => 'Рядов',
	'cols' => 'Колон',
	'maxlen' => 'Макс. длина',
	'minlevel' => 'Мин. уровень пользователя',
	'filter' => 'Фильтровать',
	'filter_desc' => 'Фильтруя данный предмет вы ограничиваете все то что может быть в нем написано',
	'no_filter' => 'Ничего',
	'del_title' => 'Подтвердить удаление',
	'del_desc' => 'Удаляя данное поле (<b>%s</b>) вы также уничтожите все данные которые пользователи

здесь хранили.',

	'already' => 'Данное имя уже используется',
	'int' => 'Внутренне имя должно быть длиннее трех символов',
	'short_disp' => 'Отображаемое имя должно быть длиннее 3 символов',
);


$lang['bookmarklets'] = array (
	'bookmarklets' => 'Ярлыки',
	'bm_add' => 'Добавить Ярлык.',
	'bm_withlink' => 'Piv " New',
	'bm_withlink_desc' => 'Открывает окно с Новой Записью, которая содержит ссылку.',

	'bm_nolink' => 'Piv " New',
	'bm_nolink_desc' => 'Открывает окно с чистой записью.',

	'bookmarklets_info' => 'You can use Bookmarklets to quickly write New Entries with Pivot. To add a

Bookmarklet to your browser, use one of the following options: (exact text varies, depending on which

browser you are using)',
	'bookmarklets_info_1' => 'Click and drag the bookmarklet to your \'Links\'-toolbar or your

browsers \'Bookmarks\'-button.',
	'bookmarklets_info_2' => 'Right-click on the bookmarklet and select \'Add to Bookmarks\'.',
);

// Accessibility - These are used for form fields, labels, fieldsets etc.
// for Web Content Accessibility Guidelines & 508 compliancy issues.
// see: http://bobby.watchfire.com/bobby/html/en/index.jsp
// JM =*=*= 2004/10/04
// 2004/11/25 =*=*= JM - minor correction for tim
$lang['accessibility'] = array(
	'search_idname'      => 'Поиск',
	'search_formname'    => 'Поиск в словах записей сайта',
	'search_fldname'     => 'Введите слово[а] для поиска:',
	'search_placeholder' => 'Введите ключевые слова',

	'calendar_summary'   => 'Это календарь записей этого блога со ссылками на записи по датам.',
	'calendar_noscript'  => 'Календарь позволяет искать записи по дате',
	/*
	2-letter language code, used to designate the principal language used on the site
	see: http://www.oasis-open.org/cover/iso639a.html
	*/

	'lang' => $langname,
) ;


$lang['snippets_text'] = array (
    'word_plural'     => 'слов(а)',
    'image_single'    => 'изображение',
    'image_plural'    => 'изображения',
    'download_single' => 'файл',
    'download_plural' => 'файлы',
);

$lang['trackback'] = array (
    'register' => 'Ваш ТрэкБэк сохранен.',
    'duplicate' => 'Ваш ТрэкБэк не сохранен, так как предыдущий точно такойже.',
    'too_many_hrefs' => 'Слишком много ссылок. Мы не любим спам.',
    'noid'      => 'Нет идентификатора трэкбэка (ID) (tb_id)',
    'nourl'     => 'Нет URL (url)',
    'tracked'   => 'Откатано',
    'email_subject' => '[Trackback] Re:',
);

$lang['commentuser'] = array (
    'title'             => 'Вход для пользователей',
    'header'            => 'Войти как зарегистрированный',
    'logout'            => 'Выйти.',
    'loggedout'         => 'Вы вышли из аккаунта',
    'login'             => 'Логин',
    'loggedin'          => 'Вход совершен',
    'loggedinas'        => 'Вы вошли как',
    'pass_forgot'       => 'Забыли пароль?',
    'register_new'      => 'Зарегистрируйтесь.',
    'register'          => 'Зарегистрируйтесь как пользователь',
    'register_info'     => 'Пожалуйста заполните следующие поля. <strong>Убедитесь что Вы дали правильный email</strong>, так как мы отправим вам письмо с подтверждением.',
    'pass_note'         => 'Заметка: Не ставьте важные или легкие пароли. <br /> Так же как и другие сайты ваш пароль <em>важен</em> <br /> важен для вас же самих!',
    'show_email'        => 'Показывать мой зашифрованный email в комментариях',
    'notify'            => 'Отправлять мне сообщения о новых записях',
    'def_notify'        => 'Всегда помечать поле "Сообщить об ответах"',
    'register'          => 'Зарегистрироваться',
    'pass_invalid'      => 'Неверный пароль',
    'nouser'            => 'Нет такого пользователя..',
    'change_info'       => 'Здесь Вы можете изменить Вашу информацию.',
    'pref_edit'         => 'Изменить мои данные',
    'pref_change'       => 'Изменить настройки',
    'options'           => 'Настройки',
    'user_exists'       => 'Такой пользователь уже существует.. Пожалуйста введите другое имя.',
    'email_note'        => 'Вы должны дать свой электронный адрес, так как вы не сможете подтвердить пользователя без этого. Ваш адрес не будет виден никому кроме Вас и будет шифроваться.',
    'stored'            => 'Изменения сохранены',
    'verified'          => 'Ваш пользователь сохранен. Пожалуйста войдите..',
    'not_verified'      => 'Кажется, что код неверный. Извините, но пользователь не смог подтвердиться.',
    'pass_sent'         => 'Ваш пароль отправлен на Ваш адрес электронный адрес email..',
    'user_pass_nomatch' => 'Имя пользователя и email почему-то не совпадают..',
    'user_stored'       => 'Пользователь зарегистрирован!',
    'user_stored_failed' => 'Не возможно сохранить нового пользователя!!',
    'pass_send'         => 'Отправить пароль',
    'pass_send_desc'    => 'Если Вы забыли Ваш пароль, он будет выслан на Ваш email. ',
    'oops'              => 'Ой',
    'back'              => 'Назад',
    'back_login'        => 'Назад на страницу входа',
    'forgotten_pass_mail' => "Ваш забытый пароль для '%name%': \n\n%pass%\n\nПожалуйста больше не забывайте!\n\nДля того чтобы войти, нажмите следующую ссылку:\n %link%",
    'registered'        => "Вы зарегистрированы '%s'",
    'reg_confirmation'  => 'Подтверждение регистрации',
    'reg_verify_short'  => 'Подтверждение вашего пользователя',
    'reg_verify_long'   => "Для подтверждения вашего пользователя, пожалуйста перейдите по следующей ссылке:\n %s",
    'reg_verification'  => 'Подтверждение отправлено на %s. Пожалуйста проверьте Ваш email для подтверждения.'
);

// A little tool to help you check if the file is correct..
if (count(get_included_files())<2) {

	$groups = count($lang);
	$total = 0;
	foreach ($lang as $langgroup) {
		$total += count($langgroup);
	}
	echo "<h2>Language file is correct! Файл корректен!</h2>";
	echo "This file contains $groups groups and a total of $total labels.";

}

?>
