/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.MessageRequestId;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public class SshFxpStatus
extends SubsystemMessage
implements MessageRequestId {
    public static final int SSH_FXP_STATUS = 101;
    public static final int STATUS_FX_OK = 0;
    public static final int STATUS_FX_EOF = 1;
    public static final int STATUS_FX_NO_SUCH_FILE = 2;
    public static final int STATUS_FX_PERMISSION_DENIED = 3;
    public static final int STATUS_FX_FAILURE = 4;
    public static final int STATUS_FX_BAD_MESSAGE = 5;
    public static final int STATUS_FX_NO_CONNECTION = 6;
    public static final int STATUS_FX_CONNECTION_LOST = 7;
    public static final int STATUS_FX_OP_UNSUPPORTED = 8;
    private UnsignedInteger32 id;
    private UnsignedInteger32 errorCode;
    private String errorMessage;
    private String languageTag;

    public SshFxpStatus(UnsignedInteger32 id, UnsignedInteger32 errorCode, String errorMessage, String languageTag) {
        super(101);
        this.id = id;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.languageTag = languageTag;
    }

    public SshFxpStatus() {
        super(101);
    }

    public UnsignedInteger32 getId() {
        return this.id;
    }

    public UnsignedInteger32 getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getLanguageTag() {
        return this.languageTag;
    }

    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        this.id = bar.readUINT32();
        this.errorCode = bar.readUINT32();
        this.errorMessage = bar.readString();
        this.languageTag = bar.readString();
    }

    public String getMessageName() {
        return "SSH_FXP_STATUS";
    }

    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        baw.writeUINT32(this.id);
        baw.writeUINT32(this.errorCode);
        baw.writeString(this.errorMessage);
        baw.writeString(this.languageTag);
    }
}

