/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgDebug
extends SshMessage {
    protected static final int SSH_MSG_DEBUG = 4;
    private String langTag;
    private String message;
    private boolean alwaysDisplay;

    public SshMsgDebug(boolean alwaysDisplay, String message, String langTag) {
        super(4);
        this.alwaysDisplay = alwaysDisplay;
        this.message = message;
        this.langTag = langTag;
    }

    public SshMsgDebug() {
        super(4);
    }

    public boolean getDisplayAlways() {
        return this.alwaysDisplay;
    }

    public String getLanguageTag() {
        return this.langTag;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageName() {
        return "SSH_MSG_DEBUG";
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.write(this.alwaysDisplay ? 1 : 0);
            baw.writeString(this.message);
            baw.writeString(this.langTag);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error writing message data: " + ioe.getMessage());
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.alwaysDisplay = bar.read() != 0;
            this.message = bar.readString();
            this.langTag = bar.readString();
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error reading message data: " + ioe.getMessage());
        }
    }
}

