/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.baseForm;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gCLINE.general.GCFileChooser;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.PLINK_Execute;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.FilterDialog;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.InputPane;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.OutputPane;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.ThresholdDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public abstract class Form
extends JDialog {
    private static Logger logger = Logger.getLogger(Form.class);
    public GPLINK parent;
    public InputPane input;
    protected OutputPane output;
    private String filter = "";
    private String threshold = "";
    protected boolean validBody = false;
    private JButton ok;
    private JButton cancel;
    protected JButton filterButton;
    protected JButton thresholdButton;
    protected ActionListener validateBodyAL = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Form.this.isBodyValid();
        }
    };
    protected DocumentListener validateBodyDL = new DocumentListener(){

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            Form.this.isBodyValid();
        }

        public void removeUpdate(DocumentEvent e) {
            Form.this.isBodyValid();
        }
    };

    public void resetFilter() {
        this.filter = "";
    }

    public void addFilter(String newParam) {
        this.filter = String.valueOf(this.filter) + newParam;
    }

    public void resetThreshold() {
        this.threshold = "";
    }

    public void addThreshold(String newParam) {
        this.threshold = String.valueOf(this.threshold) + newParam;
    }

    protected abstract JPanel createBody();

    protected abstract String processBody();

    protected abstract void isBodyValid();

    protected void okForm() {
        logger.info("(okForm()) Entering okForm");
        if (this.input.validInput && this.output.validOutput && this.validBody) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    public void closeButtons() {
        this.ok.setEnabled(false);
        this.cancel.setEnabled(false);
        this.filterButton.setEnabled(false);
        this.thresholdButton.setEnabled(false);
    }

    public void openButtons() {
        this.ok.setEnabled(true);
        this.cancel.setEnabled(true);
        this.filterButton.setEnabled(true);
        this.thresholdButton.setEnabled(true);
        this.isBodyValid();
    }

    private JPanel createButtonPane() {
        JPanel ans = new JPanel();
        this.filterButton = new JButton("Filter");
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new FilterDialog(Form.this);
            }
        });
        this.thresholdButton = new JButton("Threshold");
        this.thresholdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ThresholdDialog(Form.this);
            }
        });
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PLINK_Execute(Form.this.parent, Form.this.process());
                Form.this.dispose();
            }
        });
        this.ok.setEnabled(false);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                logger.info("(createButtonPane())Cancel button activated");
                Form.this.dispose();
            }
        });
        ans.add(this.filterButton);
        ans.add(this.thresholdButton);
        ans.add(this.ok);
        ans.add(this.cancel);
        return ans;
    }

    private String process() {
        String cmd = String.valueOf(this.parent.data.getPlinkPrefix()) + " " + FileInfo.quote(this.parent.data.getPlinkPath()) + " " + this.filter + " " + this.threshold + " " + this.input.process() + " " + this.processBody() + " " + this.output.process();
        return cmd;
    }

    public Form(GPLINK p, String name) {
        super((Frame)p, name);
        this.parent = p;
        this.input = new InputPane(this.parent, this);
        this.output = new OutputPane(this, this.parent.data.getLogExt(), this.parent.data.getHomeFiles(), this.parent.data.getHomeFolder());
        this.createBody();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(new JScrollPane(this.input));
        this.getContentPane().add(new JScrollPane(this.createBody()));
        this.getContentPane().add(this.output);
        this.getContentPane().add(this.createButtonPane());
    }

    public static JPanel bundel(final JToggleButton toggle, final JTextField text, final JButton button) {
        toggle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                text.setEnabled(toggle.isSelected());
                button.setEnabled(toggle.isSelected());
            }
        });
        text.setEnabled(toggle.isSelected());
        button.setEnabled(toggle.isSelected());
        JPanel ans = new JPanel();
        ans.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        ans.add((Component)toggle, c);
        c.gridx = 1;
        c.weightx = 1.0;
        ans.add((Component)text, c);
        c.weightx = 0.0;
        c.gridx = 2;
        ans.add((Component)button, c);
        return ans;
    }

    public static JPanel bundel(final JToggleButton toggle, final JTextField text) {
        toggle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                text.setEnabled(toggle.isSelected());
            }
        });
        text.setEnabled(toggle.isSelected());
        JPanel ans = new JPanel();
        ans.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        ans.add((Component)toggle, c);
        c.gridx = 1;
        ans.add((Component)text, c);
        return ans;
    }

    public static void bundel(final JToggleButton toggle, final JTextField[] texts, final BrowseButton[] buttons) {
        toggle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected = toggle.isSelected();
                JComponent[] jComponentArray = texts;
                int n = 0;
                int n2 = jComponentArray.length;
                while (n < n2) {
                    JTextField f = jComponentArray[n];
                    f.setEnabled(selected);
                    ++n;
                }
                jComponentArray = buttons;
                n = 0;
                n2 = jComponentArray.length;
                while (n < n2) {
                    JComponent b = jComponentArray[n];
                    ((AbstractButton)b).setEnabled(selected);
                    ++n;
                }
            }
        });
        boolean selected = toggle.isSelected();
        JComponent[] jComponentArray = texts;
        int n = 0;
        int n2 = jComponentArray.length;
        while (n < n2) {
            JTextField f = jComponentArray[n];
            f.setEnabled(selected);
            ++n;
        }
        jComponentArray = buttons;
        n = 0;
        n2 = jComponentArray.length;
        while (n < n2) {
            JComponent b = jComponentArray[n];
            ((AbstractButton)b).setEnabled(selected);
            ++n;
        }
    }

    public static void bundel(final JToggleButton toggle, final JTextField[] texts) {
        toggle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected = toggle.isSelected();
                JTextField[] jTextFieldArray = texts;
                int n = 0;
                int n2 = jTextFieldArray.length;
                while (n < n2) {
                    JTextField f = jTextFieldArray[n];
                    f.setEnabled(selected);
                    ++n;
                }
            }
        });
        boolean selected = toggle.isSelected();
        JTextField[] jTextFieldArray = texts;
        int n = 0;
        int n2 = jTextFieldArray.length;
        while (n < n2) {
            JTextField f = jTextFieldArray[n];
            f.setEnabled(selected);
            ++n;
        }
    }

    public static JPanel bundel(JTextField text, JButton button) {
        JPanel ans = new JPanel();
        ans.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        ans.add((Component)text, c);
        c.weightx = 0.0;
        c.gridx = 2;
        ans.add((Component)button, c);
        return ans;
    }

    public class BrowseButton
    extends JButton {
        private String suffex;
        private String suffexDisc;
        private JTextField target;
        private GCFileChooser pick;

        public BrowseButton(JTextField givenTarget) {
            this(givenTarget, null, null);
        }

        public BrowseButton(JTextField givenTarget, String givenSuffex, String givenSuffexDisc) {
            super("Browse");
            this.target = givenTarget;
            this.suffex = givenSuffex;
            this.suffexDisc = givenSuffexDisc;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileFilter temp = null;
                    if (BrowseButton.this.suffex != null) {
                        temp = new FileFilter(this){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public boolean accept(File f) {
                                return f.getAbsolutePath().endsWith(BrowseButton.access$0(1.access$0(this.this$2)));
                            }

                            public String getDescription() {
                                return BrowseButton.access$1(1.access$0(this.this$2));
                            }
                        };
                    }
                    BrowseButton.this.pick = new GCFileChooser(Form.this, temp, !((BrowseButton)BrowseButton.this).Form.this.parent.data.isRemote(), false, ((BrowseButton)BrowseButton.this).Form.this.parent.data.getConn(), ((BrowseButton)BrowseButton.this).Form.this.parent.data.getHomeFolder());
                    BrowseButton.this.pick.addFileChoosenListener(new GCFileChooser.FileChoosenListener(this){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                            BrowseButton.access$4(1.access$0(this.this$2)).setText(BrowseButton.access$3((BrowseButton)1.access$0(this.this$2)).fileName);
                        }
                    });
                    BrowseButton.this.pick.showChooser();
                }

                static /* synthetic */ BrowseButton access$0(1 var0) {
                    return var0.BrowseButton.this;
                }
            });
        }

        static /* synthetic */ String access$1(BrowseButton browseButton) {
            return browseButton.suffexDisc;
        }

        static /* synthetic */ JTextField access$4(BrowseButton browseButton) {
            return browseButton.target;
        }
    }
}

