/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.baseForm;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OutputPane
extends JPanel {
    private static Logger logger = Logger.getLogger(OutputPane.class);
    private String op_log_ext;
    private Vector<String> rootList;
    private JTextField root;
    private Form parentForm;
    boolean validOutput = false;

    protected OutputPane(Form p, String givenop_log_ext, Vector<String> givenHomeFiles, String homeFolder) {
        this.parentForm = p;
        this.root = new JTextField(10);
        this.op_log_ext = givenop_log_ext;
        this.rootList = new Vector();
        Vector<String> temp = givenHomeFiles;
        for (String file : temp) {
            if (!file.endsWith(this.op_log_ext)) continue;
            this.rootList.add(file);
        }
        this.setBorder(new TitledBorder("Output file root: Invalid fileroot"));
        this.setLayout(new BoxLayout(this, 3));
        this.add(new JLabel(homeFolder));
        this.add(this.root);
        this.root.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                logger.info("(changeUpdate(DocumentEvent)) root fires changedUpdate");
            }

            public void insertUpdate(DocumentEvent e) {
                logger.info("(insertUpdate(DocumentEvent)) root fires insertUpdate");
                boolean state = OutputPane.this.okOutput();
                if (state != OutputPane.this.validOutput) {
                    OutputPane.this.validOutput = state;
                    if (OutputPane.this.validOutput) {
                        OutputPane.this.setBorder(new TitledBorder("Output file root: Valid fileroot"));
                    } else {
                        OutputPane.this.setBorder(new TitledBorder("Output file root: Invalid fileroot"));
                    }
                    OutputPane.this.parentForm.okForm();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                logger.info("(remoteUpdate(DocumentEvent)) root fires removeUpdate");
                boolean state = OutputPane.this.okOutput();
                if (state != OutputPane.this.validOutput) {
                    OutputPane.this.validOutput = state;
                    if (OutputPane.this.validOutput) {
                        OutputPane.this.setBorder(new TitledBorder("Output file root: Valid fileroot"));
                    } else {
                        OutputPane.this.setBorder(new TitledBorder("Output file root: Invalid fileroot"));
                    }
                    OutputPane.this.parentForm.okForm();
                }
            }
        });
    }

    public String process() {
        return "--out " + FileInfo.quote(String.valueOf(this.parentForm.parent.data.getHomeFolder()) + this.root.getText());
    }

    protected boolean okOutput() {
        String temp = this.root.getText();
        return temp.matches("^[\\w\\-]+$") && !this.rootList.contains(String.valueOf(temp) + this.op_log_ext);
    }
}

