/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.forms;

import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;

public class AlleleAssoc
extends Form {
    public static String name = "Allelic Association Tests";
    private JCheckBox permButton;
    private JCheckBox mpermButton;
    private JCheckBox ciButton;
    private JCheckBox adjustButton;
    private JTextField ciText;
    private JTextField mpermText;
    private static Double CI_DEFAULT = new Double(0.95);
    private static Integer MPERM_DEFAULT = new Integer(1000);

    public AlleleAssoc(GPLINK mf) {
        super(mf, name);
        this.pack();
        this.setVisible(true);
    }

    protected JPanel createBody() {
        this.validBody = true;
        JPanel body = new JPanel();
        this.ciText = new JTextField(CI_DEFAULT.toString(), 4);
        this.ciText.getDocument().addDocumentListener(this.validateBodyDL);
        this.mpermText = new JTextField(MPERM_DEFAULT.toString(), 4);
        this.mpermText.getDocument().addDocumentListener(this.validateBodyDL);
        this.ciButton = new JCheckBox("Confidence interval, C/C only (--ci)");
        this.ciButton.addActionListener(this.validateBodyAL);
        this.mpermButton = new JCheckBox("max(T) permutation mode (--mperm)");
        this.mpermButton.addActionListener(this.validateBodyAL);
        this.permButton = new JCheckBox("Adaptive permutation mode (--perm)");
        this.permButton.addActionListener(this.validateBodyAL);
        this.adjustButton = new JCheckBox("Adjusted p-values (--adjust)");
        this.adjustButton.addActionListener(this.validateBodyAL);
        ActionListener toggle = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(AlleleAssoc.this.mpermButton) && AlleleAssoc.this.mpermButton.isSelected()) {
                    AlleleAssoc.this.permButton.setSelected(false);
                }
                if (e.getSource().equals(AlleleAssoc.this.permButton) && AlleleAssoc.this.permButton.isSelected()) {
                    AlleleAssoc.this.mpermButton.setSelected(false);
                }
            }
        };
        this.permButton.addActionListener(toggle);
        this.mpermButton.addActionListener(toggle);
        body.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.weightx = 1.0;
        body.add((Component)new JLabel("Basic allelic single SNP association [C/C or QT] (--assoc)"), c);
        c.gridy = 1;
        body.add((Component)Form.bundel((JToggleButton)this.ciButton, this.ciText), c);
        c.gridy = 2;
        body.add((Component)this.adjustButton, c);
        c.gridy = 3;
        c.fill = 2;
        JPanel constraits = new JPanel();
        constraits.setBorder(new TitledBorder("Permutation options "));
        constraits.setLayout(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.anchor = 21;
        constraits.add((Component)this.permButton, c1);
        c1.gridy = 1;
        c1.weightx = 1.0;
        constraits.add((Component)Form.bundel((JToggleButton)this.mpermButton, this.mpermText), c1);
        body.add((Component)constraits, c);
        return body;
    }

    protected String processBody() {
        String ans = "--assoc";
        if (this.ciButton.isSelected()) {
            ans = String.valueOf(ans) + " --ci " + this.ciText.getText();
        }
        if (this.mpermButton.isSelected()) {
            ans = String.valueOf(ans) + " --mperm " + this.mpermText.getText();
        }
        if (this.permButton.isSelected()) {
            ans = String.valueOf(ans) + " --perm";
        }
        if (this.adjustButton.isSelected()) {
            ans = String.valueOf(ans) + " --adjust";
        }
        return ans;
    }

    protected void isBodyValid() {
        this.validBody = this.ciButton.isSelected() && !this.ciText.getText().matches("\\d*\\.?\\d+") ? false : !this.mpermButton.isSelected() || this.mpermText.getText().matches("\\d*\\.?\\d+");
        this.okForm();
    }
}

