/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.Execute;

public class PropositionalLogicParser
implements PropositionalLogicParserConstants {
    private static BufferedReader br;
    private static final boolean DEBUG = false;
    private static int NUMBER_OF_TRUTH_VALUES;
    private static final String VERSION = "2.5.1";
    private static PropositionalLogicParser parser;
    private static VariableTable table;
    private static Vector sentence_symbols_vector;
    private static Hashtable symbols_in_vector;
    private static String inputString;
    private static String formulaDescription;
    private static int nSentenceElements;
    private static int input_index;
    private static boolean list_flag;
    private static boolean description_flag;
    private static boolean file_input_to_interactive_mode_flag;
    private static boolean verbose_output;
    private static boolean if_flag;
    private static boolean execute_p;
    private static LogicalSystems logicalSystems;
    private static Hashtable logical_systems_table;
    private static LogicalSystem current_system;
    private static BinaryTwoValuedRelation current_relation;
    public PropositionalLogicParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[21];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[7];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            PropositionalLogicParser.runInteractiveMode();
        } else if (stringArray.length == 1) {
            PropositionalLogicParser.runFileInputMode(stringArray[0]);
        } else {
            System.out.println("Usage: plman [ input_file ] ");
        }
    }

    private static void runInteractiveMode() {
        parser = new PropositionalLogicParser(System.in);
        if (file_input_to_interactive_mode_flag) {
            file_input_to_interactive_mode_flag = false;
        } else {
            System.out.println("\n=================================================================");
            System.out.println("Propositional LogicMan (PLMan) by T. Hoshi -- version 2.5.1  (Interactive mode)");
            System.out.println("=================================================================\n");
            PropositionalLogicParser.displayInstruction();
        }
        while (true) {
            try {
                ++input_index;
                System.out.print(PropositionalLogicParser.insertPLManPrompt());
                parser.Start();
            }
            catch (ParseException parseException) {
                System.out.println("SYNTAX ERROR: The input formula is ill-formed (i.e., doesn't follow the syntax).  Input ignored...");
                PropositionalLogicParser.recoveryFromException();
            }
            catch (TokenMgrError tokenMgrError) {
                System.out.println("SYNTAX ERROR: Illegal token encountered in the input sentence.  Input ignored...");
                PropositionalLogicParser.recoveryFromException();
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("NUMBER ERROR: Illegal input number found (maybe the input number is too big). Numbers accepted are 0, 1, 2, ..., 2147483647. Input ignored...");
                PropositionalLogicParser.recoveryFromException();
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                System.out.println("SYNTAX ERROR: The input formula is ill-formed (i.e., doesn't follow the syntax).  Input ignored...");
                PropositionalLogicParser.recoveryFromException();
            }
            catch (Exception exception) {
                System.out.println("ERROR: Unexpected exception occurred during processing the input. Program exitting...");
                exception.printStackTrace();
                System.exit(-1);
            }
            inputString = "";
        }
    }

    private static void runFileInputMode(String string) {
        System.out.println();
        System.out.println("------------------ PLMan: Reading input strings from file `" + string + "'");
        System.out.println();
        try {
            parser = new PropositionalLogicParser(new FileInputStream(string));
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "JISAutoDetect"));
            parser.FileInputModeStart();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("PLMan Parser:  File " + string + " not found.");
            return;
        }
        catch (ParseException parseException) {
            System.out.println("SYNTAX ERROR: The input formula is ill-formed (i.e., doesn't follow the syntax).  Input ignored...");
            parseException.printStackTrace();
        }
        catch (TokenMgrError tokenMgrError) {
            System.out.println("SYNTAX ERROR: Illegal token encountered in the input sentence.  Input ignored...");
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("NUMBER ERROR: Illegal input number found (maybe the input number is too big). Numbers accepted are 0, 1, 2, ..., 2147483647. Input ignored...");
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            System.out.println("SYNTAX ERROR: The input formula is ill-formed (i.e., doesn't follow the syntax).  Input ignored...");
            lookaheadSuccess.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("ERROR: Unexpected exception occurred during processing the input. Program exitting...");
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private static void recoveryFromException() {
        StringReader stringReader = new StringReader("");
        parser.ReInit(stringReader);
        parser.ReInit(System.in);
        description_flag = false;
        list_flag = false;
    }

    private static void displayInstruction() {
        System.out.println("Negation symbol is either `~', `NOT', or the NOT symbol in Unicode.");
        System.out.println("Conjunction symbol is either `&', `AND', or the AND symbol in Unicode.");
        System.out.println("Disjunction symbol is either `|', `OR', or the OR symbol in Unicode.");
        System.out.println("Conditional symbol is either `=>', `IMPLIES', or the IMPLIES symbol in Unicode.");
        System.out.println("Biconditional symbol is either `<=>', `IFF', or the IFF symbol in Unicode.");
        System.out.println("Truth symbol can be one of the following: `1', `TRUE', or `T'.");
        System.out.println("False symbol can be one of the following: `0', `FALSE', or `F'.\n");
        System.out.println("Please send a bug report or suggestions to <hoshi103@chapman.edu>.");
        System.out.println("To exit the program, just input `:exit' at the prompt.\n");
    }

    private String replaceConstantSymbolsWithTheirValues(String string) {
        Object[] objectArray = table.getValues();
        String[] stringArray = table.getKeys();
        Replacer replacer = new Replacer(stringArray.length);
        String string2 = string;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!((VariableEntry)objectArray[i]).isInitialized()) continue;
            Object object = ((VariableEntry)table.get(stringArray[i])).getValue();
            string2 = replacer.replaceSingleSymbol(string2, stringArray[i], String.valueOf(object));
        }
        return string2;
    }

    private static String getPLManPath() {
        Vector vector = Execute.getProcEnvironment();
        String string = "";
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n = string2.indexOf(61);
            if (n == -1 || !string2.substring(0, n).equals("PLMAN_SCRIPT_PATH")) continue;
            string = string2.substring(n + 1);
        }
        return string;
    }

    private static boolean logicalSystemExists(String string) {
        return logical_systems_table.containsKey(string);
    }

    public static String insertPLManPrompt() {
        String string = "plman[" + input_index + "]" + "> ";
        return string;
    }

    public static void outputResult(Object object) {
        String string = "out[" + input_index + "]> ";
        System.out.print(string + (current_system.trueOrFalse(object) ? "True" : "False"));
        if (verbose_output) {
            System.out.println("\t\t[ " + current_system.truthValueToEnglish(object) + " ]");
        } else {
            System.out.println();
        }
    }

    public LogicalSystem getCurrentSystem() {
        return current_system;
    }

    private static void normalizeListState() {
        list_flag = false;
        nSentenceElements = 0;
        sentence_symbols_vector.removeAllElements();
        symbols_in_vector.clear();
    }

    private static void changeLogicalSystem(String string) {
        current_system = (LogicalSystem)logical_systems_table.get(string);
    }

    public final void FileInputModeStart() throws ParseException {
        block20: {
            String string = "";
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: 
                    case 11: 
                    case 14: 
                    case 15: 
                    case 19: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 47: 
                    case 51: 
                    case 52: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block20;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 11: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 47: 
                    case 52: {
                        try {
                            string = br.readLine();
                            ++input_index;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        inputString = "";
                        System.out.println(PropositionalLogicParser.insertPLManPrompt() + string);
                        this.StatementList();
                        this.jj_consume_token(8);
                        continue block17;
                    }
                    case 14: 
                    case 15: 
                    case 19: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 51: {
                        try {
                            string = br.readLine();
                            ++input_index;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        inputString = "";
                        System.out.println(PropositionalLogicParser.insertPLManPrompt() + string);
                        this.Command();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 11: {
                                this.jj_consume_token(11);
                                break;
                            }
                            default: {
                                this.jj_la1[1] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(8);
                        continue block17;
                    }
                    case 8: {
                        try {
                            string = br.readLine();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        inputString = "";
                        this.jj_consume_token(8);
                        continue block17;
                    }
                }
                break;
            }
            this.jj_la1[2] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
        if (file_input_to_interactive_mode_flag) {
            PropositionalLogicParser.runInteractiveMode();
        } else {
            System.exit(0);
        }
    }

    public final void Start() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 11: 
            case 38: 
            case 39: 
            case 40: 
            case 47: 
            case 52: {
                this.StatementList();
                this.jj_consume_token(8);
                break;
            }
            case 14: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 51: {
                this.Command();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                    }
                }
                this.jj_consume_token(8);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                System.exit(0);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void StatementList() throws ParseException {
        this.Statement();
        while (this.jj_2_1(2)) {
            this.jj_consume_token(11);
            this.Statement();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
    }

    public final void Statement() throws ParseException {
        if (this.jj_2_2(2)) {
            this.AssignmentExpressionList();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 38: 
                case 39: 
                case 40: 
                case 47: 
                case 52: {
                    Object object = this.PropositionalExpression();
                    PropositionalLogicParser.outputResult(object);
                    break;
                }
                case 11: {
                    this.jj_consume_token(11);
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final Object PropositionalExpression() throws ParseException {
        Object object = this.Formula();
        return object;
    }

    public final Object Formula() throws ParseException {
        Object object = this.AdditiveExpression();
        return object;
    }

    public final Object AdditiveExpression() throws ParseException {
        Object object = this.MultiplicativeExpression();
        block4: while (this.jj_2_3(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: {
                    Token token = this.jj_consume_token(43);
                    inputString = inputString.concat(token.image + " ");
                    if (description_flag) {
                        formulaDescription = formulaDescription.concat("implies ");
                    }
                    Object object2 = this.AdditiveExpression();
                    object = current_system.interpretImplies(object, object2);
                    continue block4;
                }
                case 44: {
                    Token token = this.jj_consume_token(44);
                    inputString = inputString.concat(token.image + " ");
                    if (description_flag) {
                        formulaDescription = formulaDescription.concat("if and only if ");
                    }
                    Object object2 = this.AdditiveExpression();
                    object = current_system.interpretIff(object, object2);
                    continue block4;
                }
            }
            this.jj_la1[7] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return object;
    }

    public final void AssignmentExpressionList() throws ParseException {
        this.AssignmentExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            this.AssignmentExpression();
        }
    }

    public final void AssignmentExpression() throws ParseException {
        if (this.jj_2_4(2)) {
            this.ValueAssignmentExpression();
        } else if (this.jj_2_5(2)) {
            this.DescriptionAssignmentExpression();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void ValueAssignmentExpression() throws ParseException {
        Token token = this.jj_consume_token(47);
        this.jj_consume_token(10);
        Object object = this.Formula();
        if (!current_system.getSystemName().equals("FDE")) {
            table.put(token.image, object);
        } else {
            System.out.println("The input ignored...");
            System.out.println("( Current logical system `" + current_system.getSystemName() + "' evaluates expression in terms of 'relation', not by 'value'.");
            System.out.println("In order to add an element to an existing relation, use the expression \":addR ExistingRelation <symbol, value>\" (e.g., :addR  R1 <a, 0>) instead. )");
        }
    }

    public final void DescriptionAssignmentExpression() throws ParseException {
        Token token = this.jj_consume_token(47);
        this.jj_consume_token(9);
        Token token2 = this.jj_consume_token(49);
        String string = token2.image;
        string = string.substring(1, string.length() - 1);
        string = string.replaceAll("\\\\\"", "\"");
        table.put(token.image, null, string);
    }

    public final Object MultiplicativeExpression() throws ParseException {
        Object object = this.UnaryExpression();
        block4: while (this.jj_2_6(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    Token token = this.jj_consume_token(41);
                    inputString = inputString.concat(token.image + " ");
                    if (description_flag) {
                        formulaDescription = formulaDescription.concat("and ");
                    }
                    Object object2 = this.MultiplicativeExpression();
                    object = current_system.interpretAnd(object, object2);
                    continue block4;
                }
                case 42: {
                    Token token = this.jj_consume_token(42);
                    inputString = inputString.concat(token.image + " ");
                    if (description_flag) {
                        formulaDescription = formulaDescription.concat("or ");
                    }
                    Object object2 = this.MultiplicativeExpression();
                    object = current_system.interpretOr(object, object2);
                    continue block4;
                }
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return object;
    }

    public final Object UnaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                Token token = this.jj_consume_token(40);
                inputString = inputString.concat(token.image);
                if (description_flag) {
                    formulaDescription = formulaDescription.concat("it is not the case that ");
                }
                Object object = this.UnaryExpression();
                return current_system.interpretNot(object);
            }
            case 7: 
            case 38: 
            case 39: 
            case 47: 
            case 52: {
                Object object = this.AtomicExpression();
                return object;
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object AtomicExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                Token token = this.jj_consume_token(7);
                inputString = inputString.concat(token.image + " ");
                if (description_flag) {
                    formulaDescription = formulaDescription.concat(token.image + " ");
                }
                return current_system.getCorrespondingNumberFormat(token.toString());
            }
            case 38: {
                Token token = this.jj_consume_token(38);
                inputString = inputString.concat(token.image + " ");
                if (description_flag) {
                    formulaDescription = formulaDescription.concat(token.image + " ");
                }
                return current_system.getTrueValue();
            }
            case 39: {
                Token token = this.jj_consume_token(39);
                inputString = inputString.concat(token.image + " ");
                if (description_flag) {
                    formulaDescription = formulaDescription.concat(token.image + " ");
                }
                return current_system.getFalseValue();
            }
            case 47: {
                Object object = this.Symbol();
                return object;
            }
            case 52: {
                Token token = this.jj_consume_token(52);
                inputString = inputString.concat(token.image + " ");
                if (description_flag) {
                    formulaDescription = formulaDescription.concat("[ ");
                }
                Object object = this.Formula();
                Token token2 = this.jj_consume_token(53);
                inputString = inputString.concat(token2.image + " ");
                if (description_flag) {
                    formulaDescription = formulaDescription.concat("] ");
                }
                return object;
            }
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object Symbol() throws ParseException {
        Token token = this.jj_consume_token(47);
        inputString = inputString.concat(token.image + " ");
        if (description_flag) {
            formulaDescription = table.exists(token.image) ? (!((VariableEntry)table.get(token.image)).getDescription().equals("") ? formulaDescription.concat("\"" + ((VariableEntry)table.get(token.image)).getDescription() + "\"" + " ") : formulaDescription.concat("`" + token.image + "'" + " ")) : formulaDescription.concat("`" + token.image + "'" + " ");
        }
        if (table.exists(token.image)) {
            if (list_flag && !symbols_in_vector.containsKey(token.image)) {
                ++nSentenceElements;
                symbols_in_vector.put(token.image, "");
                sentence_symbols_vector.add((VariableEntry)table.get(token.image));
            }
            if (!((VariableEntry)table.get(token.image)).isInitialized()) {
                if (!description_flag || list_flag) {
                    if (!current_system.getSystemName().equals("FDE")) {
                        System.out.println("Propositional atom `" + token.image + "' is uninitialized (i.e. declared, but doesn't have its value). Returning False ( value: " + current_system.getFalseValue().toString() + " ) instead... ");
                        return current_system.getFalseValue();
                    }
                    return ((LogicalSystems.SystemFDE)current_system).interpretSymbol(token.image);
                }
                if (!current_system.getSystemName().equals("FDE")) {
                    return current_system.getTrueValue();
                }
                return ((LogicalSystems.SystemFDE)current_system).interpretSymbol(token.image);
            }
            if (!current_system.getSystemName().equals("FDE")) {
                Object object = ((VariableEntry)table.get(token.image)).getValue();
                return object;
            }
            return ((LogicalSystems.SystemFDE)current_system).interpretSymbol(token.image);
        }
        if (list_flag) {
            if (!symbols_in_vector.containsKey(token.image)) {
                ++nSentenceElements;
                symbols_in_vector.put(token.image, "");
                sentence_symbols_vector.add(new VariableEntry(token.image, null, 1, false));
            }
        } else if (!description_flag) {
            if (!current_system.getSystemName().equals("FDE")) {
                System.out.println("Propositional atom `" + token.image + "' is undeclared. Returning False ( value: " + current_system.getFalseValue().toString() + " ) instead. ");
                return current_system.getFalseValue();
            }
            return ((LogicalSystems.SystemFDE)current_system).interpretSymbol(token.image);
        }
        if (!current_system.getSystemName().equals("FDE")) {
            return current_system.getFalseValue();
        }
        return ((LogicalSystems.SystemFDE)current_system).interpretSymbol(token.image);
    }

    public final void Command() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                System.exit(0);
                break;
            }
            case 51: {
                Token token = this.jj_consume_token(51);
                String string = token.image;
                string = string.substring(2, string.length());
                System.out.println(string);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                file_input_to_interactive_mode_flag = true;
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                Token token = this.jj_consume_token(49);
                String string = PropositionalLogicParser.getPLManPath();
                String string2 = token.image.substring(1, token.image.length() - 1);
                if (string.equals("")) {
                    System.out.println("The environment variable `PLMAN_SCRIPT_PATH' isn't set correctly. ");
                } else {
                    String string3 = string + System.getProperty("file.separator") + string2;
                    PropositionalLogicParser.runFileInputMode(string3);
                }
                System.out.println(string);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                description_flag = true;
                this.Formula();
                System.out.println(formulaDescription);
                description_flag = false;
                formulaDescription = "";
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                list_flag = true;
                this.Formula();
                if (list_flag) {
                    if (current_system.truthTableConstructable()) {
                        Lister lister = new Lister(current_system, inputString, sentence_symbols_vector, parser);
                        System.out.println();
                        lister.listReversed();
                    } else {
                        System.out.println("`:table' command is disabled within this system since truth tables are not constructable within this system.");
                    }
                } else {
                    System.out.println("Some undeclared symbols found... You must declare all symbols in the sentence to use LIST.");
                }
                PropositionalLogicParser.normalizeListState();
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                Token token = this.jj_consume_token(49);
                String string = token.image.substring(1, token.image.length() - 1);
                if (PropositionalLogicParser.logicalSystemExists(string)) {
                    current_relation = null;
                    PropositionalLogicParser.changeLogicalSystem(string);
                    break;
                }
                System.out.println("WARNING: Either logical system `" + string + "' doesn't exist or is not yet implemented.");
                System.out.println("Current logical system `" + current_system.getSystemName() + "'  will be used continually.");
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                System.out.println(current_system.getSystemName());
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                Token token = this.jj_consume_token(47);
                String string = token.image;
                if (table.exists(string)) {
                    Object object = ((VariableEntry)table.get(string)).getValue();
                    if (object instanceof BinaryTwoValuedRelation && current_system.getSystemName().equals("FDE")) {
                        current_relation = (BinaryTwoValuedRelation)object;
                        ((LogicalSystems.SystemFDE)current_system).setRelation(current_relation);
                        System.out.println("Relation for the current system is now set to `" + string + "'.");
                        break;
                    }
                    System.out.println("WARNING: Symbol `" + string + "' is not an relation object. The attempt failed...");
                    break;
                }
                System.out.println("WARNING: Symbol `" + string + "' doesn't exist. The attempt failed...");
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                Token token = this.jj_consume_token(47);
                BinaryTwoValuedRelation binaryTwoValuedRelation = this.BinaryRelationalSet();
                table.put(token.image, binaryTwoValuedRelation);
                System.out.println("Relation `" + token.image + "' is now created.");
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                Token token = this.jj_consume_token(47);
                if (table.exists(token.image)) {
                    Object object = ((VariableEntry)table.get(token.image)).getValue();
                    if (object instanceof BinaryTwoValuedRelation) {
                        ((BinaryTwoValuedRelation)object).printAllRelations();
                        break;
                    }
                    System.out.println("WARNING: Symbol `" + token.image + "' is not an relation object.");
                    break;
                }
                System.out.println("WARNING: Symbol `" + token.image + "' doesn't exist.");
                break;
            }
            case 14: {
                OrderedPair orderedPair = this.OrderedPairExpression();
                if (current_relation != null) {
                    if (current_relation.add(orderedPair)) {
                        System.out.println("Pair " + orderedPair.toString() + " added to the current relation.");
                    } else {
                        System.out.println("WARNING: Pair " + orderedPair.toString() + " could not be added.");
                    }
                } else {
                    System.out.println("A relation for the system is not yet set. One can do so by inputting:\n:setR ExistingRelationSymbol\n\nIf no relation is available, one can make a creation of such an object by inputting:\n:createR NonExistingRelationSymbol");
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(12);
                    orderedPair = this.OrderedPairExpression();
                    if (current_relation != null) {
                        if (current_relation.add(orderedPair)) {
                            System.out.println("Pair " + orderedPair.toString() + " added to the current relation.");
                            continue;
                        }
                        System.out.println("WARNING: Pair " + orderedPair.toString() + " could not be added.");
                        continue;
                    }
                    System.out.println("A relation for the system is not yet set. One can do so by inputting:\n:setR ExistingRelationSymbol\n\nIf no relation is available, one can make a creation of such an object by inputting:\n:createR NonExistingRelationSymbol");
                }
            }
            case 19: {
                this.jj_consume_token(19);
                OrderedPair orderedPair = this.OrderedPairExpression();
                if (current_relation != null) {
                    if (current_relation.remove(orderedPair)) {
                        System.out.println("Pair " + orderedPair.toString() + " removed from the current relation.");
                    } else {
                        System.out.println("WARNING: Pair " + orderedPair.toString() + " could not be removed. ");
                    }
                } else {
                    System.out.println("A relation for the system is not yet set. One can do so by inputting:\n:setR ExistingRelationSymbol\n\nIf no relation is available, one can make a creation of such an object by inputting:\n:createR NonExistingRelationSymbol");
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[13] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(12);
                    orderedPair = this.OrderedPairExpression();
                    if (current_relation != null) {
                        if (current_relation.remove(orderedPair)) {
                            System.out.println("Pair " + orderedPair.toString() + " removed from the currently set relation.");
                            continue;
                        }
                        System.out.println("WARNING: Pair " + orderedPair.toString() + " could not be removed.");
                        continue;
                    }
                    System.out.println("A relation for the system is not yet set. One can do so by inputting:\n:setR ExistingRelationSymbol\n\nIf no relation is available, one can make a creation of such an object by inputting:\n:createR NonExistingRelationSymbol");
                }
            }
            case 33: {
                Object object;
                this.jj_consume_token(33);
                Token token = this.jj_consume_token(47);
                OrderedPair orderedPair = this.OrderedPairExpression();
                if (table.exists(token.image)) {
                    object = ((VariableEntry)table.get(token.image)).getValue();
                    if (object instanceof BinaryTwoValuedRelation) {
                        if (((BinaryTwoValuedRelation)object).add(orderedPair)) {
                            System.out.println("Pair " + orderedPair.toString() + " added to the current relation.");
                        } else {
                            System.out.println("WARNING: Pair " + orderedPair.toString() + " could not be added.");
                        }
                    } else {
                        System.out.println("WARNING: Symbol `" + token.image + "' is not an relation object. The ordered pair " + orderedPair.toString() + " cannot be added.");
                    }
                } else {
                    System.out.println("WARNING: Symbol `" + token.image + "' doesn't exist.The ordered pair " + orderedPair.toString() + " cannot be added.");
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(12);
                    orderedPair = this.OrderedPairExpression();
                    if (table.exists(token.image)) {
                        object = ((VariableEntry)table.get(token.image)).getValue();
                        if (object instanceof BinaryTwoValuedRelation) {
                            if (((BinaryTwoValuedRelation)object).add(orderedPair)) {
                                System.out.println("Pair " + orderedPair.toString() + " added to the current relation.");
                                continue;
                            }
                            System.out.println("WARNING: Pair " + orderedPair.toString() + " could not be added.");
                            continue;
                        }
                        System.out.println("WARNING: Symbol `" + token.image + "' is not an relation object. The ordered pair " + orderedPair.toString() + " cannot be added.");
                        continue;
                    }
                    System.out.println("WARNING: Symbol `" + token.image + "' doesn't exist.The ordered pair " + orderedPair.toString() + " cannot be added.");
                }
            }
            case 34: {
                Object object;
                this.jj_consume_token(34);
                Token token = this.jj_consume_token(47);
                OrderedPair orderedPair = this.OrderedPairExpression();
                if (table.exists(token.image)) {
                    object = ((VariableEntry)table.get(token.image)).getValue();
                    if (object instanceof BinaryTwoValuedRelation) {
                        if (((BinaryTwoValuedRelation)object).remove(orderedPair)) {
                            System.out.println("Pair " + orderedPair.toString() + " removed from the current relation.");
                        } else {
                            System.out.println("WARNING: Pair " + orderedPair.toString() + " could not be removed. ");
                        }
                    } else {
                        System.out.println("WARNING: Symbol `" + token.image + "' is not an relation object. The ordered pair " + orderedPair.toString() + " cannot be removed.");
                    }
                } else {
                    System.out.println("WARNING: Symbol `" + token.image + "' doesn't exist.The ordered pair " + orderedPair.toString() + " cannot be removed.");
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(12);
                    orderedPair = this.OrderedPairExpression();
                    if (table.exists(token.image)) {
                        object = ((VariableEntry)table.get(token.image)).getValue();
                        if (object instanceof BinaryTwoValuedRelation) {
                            if (((BinaryTwoValuedRelation)object).remove(orderedPair)) {
                                System.out.println("Pair " + orderedPair.toString() + " removed from the current relation.");
                                continue;
                            }
                            System.out.println("WARNING: Pair " + orderedPair.toString() + " could not be removed. ");
                            continue;
                        }
                        System.out.println("WARNING: Symbol `" + token.image + "' is not an relation object. The ordered pair " + orderedPair.toString() + " cannot be added.");
                        continue;
                    }
                    System.out.println("WARNING: Symbol `" + token.image + "' doesn't exist.The ordered pair " + orderedPair.toString() + " cannot be added.");
                }
            }
            case 37: {
                this.jj_consume_token(37);
                Token token = this.jj_consume_token(7);
                if (current_system.getSystemName().equals("L")) {
                    ((LogicalSystems.SystemL)current_system).setBorderLine(Double.parseDouble(token.image));
                    break;
                }
                System.out.println("There is not truth value border line in this system.");
                System.out.println("Request rejected...");
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                list_flag = true;
                this.Formula();
                if (list_flag) {
                    if (current_system.truthTableConstructable()) {
                        Lister lister = new Lister(current_system, inputString, sentence_symbols_vector, parser);
                        if (lister.isSatisfiable()) {
                            PropositionalLogicParser.outputResult(current_system.getTrueValue());
                        } else {
                            PropositionalLogicParser.outputResult(current_system.getFalseValue());
                        }
                    } else {
                        System.out.println("`:satisfiable' command is disabled within this system since truth tables are not constructable within this system.");
                    }
                } else {
                    System.out.println("Some undeclared symbols found... You must declare all symbols in the sentence to use LIST.");
                }
                PropositionalLogicParser.normalizeListState();
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                list_flag = true;
                this.Formula();
                if (list_flag) {
                    if (current_system.truthTableConstructable()) {
                        Lister lister = new Lister(current_system, inputString, sentence_symbols_vector, parser);
                        if (lister.isValid()) {
                            PropositionalLogicParser.outputResult(current_system.getTrueValue());
                        } else {
                            PropositionalLogicParser.outputResult(current_system.getFalseValue());
                        }
                    } else {
                        System.out.println("`:satisfiable' command is disabled within this system since truth tables are not constructable within this system.");
                    }
                } else {
                    System.out.println("Some undeclared symbols found... You must declare all symbols in the sentence to use LIST.");
                }
                PropositionalLogicParser.normalizeListState();
                break;
            }
            case 15: {
                this.EntailmentExpression();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final BinaryTwoValuedRelation BinaryRelationalSet() throws ParseException {
        BinaryTwoValuedRelation binaryTwoValuedRelation = new BinaryTwoValuedRelation();
        this.jj_consume_token(15);
        if (this.jj_2_7(2)) {
            OrderedPair orderedPair = this.OrderedPairExpression();
            binaryTwoValuedRelation.add(orderedPair);
            block3: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(12);
                orderedPair = this.OrderedPairExpression();
                binaryTwoValuedRelation.add(orderedPair);
            }
        }
        this.jj_consume_token(16);
        return binaryTwoValuedRelation;
    }

    public final OrderedPair OrderedPairExpression() throws ParseException {
        Token token;
        this.jj_consume_token(14);
        Token token2 = this.jj_consume_token(47);
        this.jj_consume_token(12);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                token = this.jj_consume_token(7);
                break;
            }
            case 47: {
                token = this.jj_consume_token(47);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(13);
        OrderedPair orderedPair = new OrderedPair(token2.image, token.image);
        return orderedPair;
    }

    public final void EntailmentExpression() throws ParseException {
        String string = "";
        this.jj_consume_token(15);
        list_flag = true;
        this.Formula();
        string = "( " + inputString + " )";
        inputString = "";
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(12);
            this.Formula();
            string = string.concat(" & ( " + inputString + " )");
            inputString = "";
        }
        this.jj_consume_token(16);
        this.jj_consume_token(45);
        this.Formula();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        if (current_system.getSystemName().equals("CPL") || current_system.getSystemName().equals("K3") || current_system.getSystemName().equals("L3")) {
            String string2;
            Lister lister;
            if (!string.equals("")) {
                string = string.concat(" & (  ~( " + inputString + " )  )");
            }
            boolean bl = (lister = new Lister(current_system, string2 = this.replaceConstantSymbolsWithTheirValues(string), sentence_symbols_vector, parser)).models();
            PropositionalLogicParser.normalizeListState();
            if (bl) {
                PropositionalLogicParser.outputResult(current_system.getTrueValue());
            } else {
                PropositionalLogicParser.outputResult(current_system.getFalseValue());
            }
        } else {
            System.out.println("Currently, entailment operator ( |= ) is not supported in system `" + current_system.getSystemName() + "'.");
            PropositionalLogicParser.normalizeListState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, n);
        }
    }

    private final boolean jj_3R_24() {
        return this.jj_3R_26();
    }

    private final boolean jj_3_5() {
        return this.jj_3R_17();
    }

    private final boolean jj_3_3() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_14()) {
            this.jj_scanpos = token;
            if (this.jj_3R_15()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_19() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private final boolean jj_3R_34() {
        return this.jj_3R_36();
    }

    private final boolean jj_3R_28() {
        return this.jj_scan_token(40);
    }

    private final boolean jj_3R_26() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = token;
            if (this.jj_3R_29()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_29() {
        return this.jj_3R_30();
    }

    private final boolean jj_3_7() {
        return this.jj_3R_20();
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_3R_12();
    }

    private final boolean jj_3R_22() {
        Token token = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = token;
            if (this.jj_3_5()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_4() {
        return this.jj_3R_16();
    }

    private final boolean jj_3R_15() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private final boolean jj_3R_21() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_33() {
        return this.jj_scan_token(39);
    }

    private final boolean jj_3R_18() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private final boolean jj_3R_17() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_13() {
        return this.jj_3R_22();
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_24();
    }

    private final boolean jj_3R_12() {
        Token token = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = token;
            if (this.jj_3R_21()) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(11)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_2() {
        return this.jj_3R_13();
    }

    private final boolean jj_3R_36() {
        return this.jj_scan_token(47);
    }

    private final boolean jj_3R_32() {
        return this.jj_scan_token(38);
    }

    private final boolean jj_3_6() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = token;
            if (this.jj_3R_19()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_14() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private final boolean jj_3R_27() {
        return this.jj_3R_23();
    }

    private final boolean jj_3R_31() {
        return this.jj_scan_token(7);
    }

    private final boolean jj_3R_30() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = token;
            if (this.jj_3R_32()) {
                this.jj_scanpos = token;
                if (this.jj_3R_33()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_34()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_35()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_20() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        return this.jj_scan_token(47);
    }

    private final boolean jj_3R_25() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_35() {
        return this.jj_scan_token(52);
    }

    private final boolean jj_3R_16() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        return this.jj_scan_token(10);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{-7812736, 2048, -7812736, 2048, -7812735, 2048, 2176, 0, 4096, 0, 128, 128, 4096, 4096, 4096, 4096, -7815168, 4096, 128, 4096, 1};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0x1881FF, 0, 0x1881FF, 0, 0x1881FF, 0, 1081792, 6144, 0, 1536, 1081792, 1081536, 0, 0, 0, 0, 524351, 0, 32768, 0, 0};
    }

    public PropositionalLogicParser(InputStream inputStream) {
        int n;
        this.jj_input_stream = new JavaCharStream(inputStream, 1, 1);
        this.token_source = new PropositionalLogicParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 21; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        int n;
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 21; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public PropositionalLogicParser(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new PropositionalLogicParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 21; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 21; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public PropositionalLogicParser(PropositionalLogicParserTokenManager propositionalLogicParserTokenManager) {
        int n;
        this.token_source = propositionalLogicParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 21; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(PropositionalLogicParserTokenManager propositionalLogicParserTokenManager) {
        int n;
        this.token_source = propositionalLogicParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 21; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            int n3;
            this.jj_expentry = new int[this.jj_endpos];
            for (n3 = 0; n3 < this.jj_endpos; ++n3) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                n3 = 1;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] == this.jj_expentry[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
            }
            if (n3 == 0) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[54];
        for (n2 = 0; n2 < 54; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 21; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 54; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, PropositionalLogicParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 7; ++i) {
            JJCalls jJCalls = this.jj_2_rtns[i];
            do {
                if (jJCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        NUMBER_OF_TRUTH_VALUES = 2;
        table = new VariableTable();
        sentence_symbols_vector = new Vector();
        symbols_in_vector = new Hashtable();
        inputString = "";
        formulaDescription = "";
        nSentenceElements = 0;
        input_index = 0;
        list_flag = false;
        description_flag = false;
        file_input_to_interactive_mode_flag = false;
        verbose_output = true;
        if_flag = false;
        execute_p = true;
        logicalSystems = new LogicalSystems();
        logical_systems_table = logicalSystems.getLogicalSystemsTable();
        current_system = (LogicalSystem)logical_systems_table.get("CPL");
        current_relation = null;
        PropositionalLogicParser.jj_la1_0();
        PropositionalLogicParser.jj_la1_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

