/**
 * Last modified: 12 21 2003
 *
 * @author Takayuki Hoshi <hoshi103@chapman.edu>
 * File: BitMatrix.java
 * 
 *
 */
 
public class BitMatrix {

    public static final boolean DEBUG = false;
    private int nElements;

//     public BitMatrix(int size) {
//         nElements = size;
//     }

    public String[][] getPossibleValues(int size) {
        
        /* presupposition: nElements > 0 */
        if(size <= 0) {
            System.out.println("BitMatrix.class:getPossibleValues() : size must be bigger than 0." );
            System.exit(-1);
        }
        else 
            nElements = size;
        
        int limit = (int) Math.pow(2, nElements);
        String [][] elements = new String[limit][nElements];
        
        byte a = 0x0;
        for(int i = 0; i < limit; i++) {

            String bin_string = Integer.toBinaryString(a);
            int bin_string_length = bin_string.length();
            for(int j = nElements; j > 0; j--) {
                int index = nElements - j;
                if ( (bin_string_length - j) < 0 ) {
                    elements[i][index] = "0";
                }
                else {
                    /* !!! */
                    elements[i][index] =
                        bin_string.substring( bin_string_length - j, bin_string_length - j + 1);
//                         bin_string.charAt( bin_string_length - j ) - 48;		// char to number
                }
            }

            /* If you want to see what this function does, set DEBUG to true. */
            if(DEBUG) {
                System.out.println("Original: " + bin_string);
                System.out.print("Converted: " );
                for(int k = 0; k < nElements; k++) {
                    System.out.print(elements[i][k]);
                }
                System.out.println();
                System.out.println();
            }

            a += 0x0001;
        }

        return elements;
    }

    public static void main(String[] args) {
        int nElements = 3;
        String[][] possibilities = new String[ (int) Math.pow(2, nElements)][ nElements ];
         
        BitMatrix matrix = new BitMatrix();
        possibilities = matrix.getPossibleValues(nElements);

        /*
OUTPUT:

Original: 0
Converted: 000

Original: 1
Converted: 001

Original: 10
Converted: 010

Original: 11
Converted: 011

Original: 100
Converted: 100

Original: 101
Converted: 101

Original: 110
Converted: 110

Original: 111
Converted: 111
 */
    } // end of main()


}		// end of class `BitMatrix'
