/* Generated By:JavaCC: Do not edit this line. PropositionalLogicParser.java */
/*
  
This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

Author: Takayuki Hoshi <hoshi103@chapman.edu>

Project: plman
Version: 2.4.3
Last modified: 2004-11-19 [23:18]
copyright 2004 Takayuki Hoshi <hoshi103@chapman.edu>

*/

import java.io.*;
import java.util.*;
import org.apache.tools.ant.taskdefs.Execute;


public class PropositionalLogicParser implements PropositionalLogicParserConstants {

// 2004-11-07 [18:39]
//  **. Fields 

        private static BufferedReader br;

        private static final boolean DEBUG = false;
        private static int NUMBER_OF_TRUTH_VALUES = 2; //* 2 for standard, 3 for non-standard 3-valued system
        private static final String VERSION = "2.5.1" ;

        private static PropositionalLogicParser parser;
        private static VariableTable table = new VariableTable();
        private static java.util.Vector sentence_symbols_vector = new java.util.Vector();
        private static java.util.Hashtable symbols_in_vector  = new java.util.Hashtable();

        private static String inputString = "" ;
        private static String formulaDescription = "" ;
        private static int nSentenceElements = 0;
        private static int input_index = 0;

        private static boolean list_flag = false;
        private static boolean description_flag = false;
        private static boolean file_input_to_interactive_mode_flag = false;
        private static boolean verbose_output = true ;
        private static boolean if_flag = false;
        private static boolean execute_p = true;
// 	private static boolean then_flag = false;
// 	private static boolean else_flag = false;

// 	private static boolean current_relation_set = false ;

        /** A collection of logical systems. */
        private static LogicalSystems logicalSystems = new LogicalSystems( );
        private static Hashtable logical_systems_table = logicalSystems.getLogicalSystemsTable();

        /** current logical system underlying current inputs. It defaults to CPL (Classical Propositional Logic).*/
        private static LogicalSystem current_system = (LogicalSystem) logical_systems_table.get( "CPL" );
        private static BinaryTwoValuedRelation current_relation = null;


// 2004-11-07 [18:39]
//  **. Main 

        public static void main(String args[]) {

                /* interactive mode */
                if (args.length == 0) {
                        PropositionalLogicParser.runInteractiveMode();
                }
                /* read the input from file */
                else if (args.length == 1) {
                        PropositionalLogicParser.runFileInputMode(args[0]);
                }
                else {
                        System.out.println( "Usage: plman [ input_file ] " );
                }
        }               // end of main()


// 2004-11-07 [18:40]
//  **. Interactive mode

        private static void runInteractiveMode( ) {
                parser = new PropositionalLogicParser(System.in);

/*
 * display the instructive message if file_input_to_interactive_mode_flag is off.
 */
                if ( file_input_to_interactive_mode_flag )
                        file_input_to_interactive_mode_flag = false;
                else {
                        /* initial message */
                        System.out.println("\n=================================================================");
                        System.out.println("Propositional LogicMan (PLMan) by T. Hoshi -- version " + VERSION + "  " + "(Interactive mode)"  );
                        System.out.println("=================================================================\n");
                        displayInstruction();
                }


                while (true) {
                        try {
                                input_index++;
// 				System.out.print("plman[" + input_index + "]" + "> " );
                                System.out.print(insertPLManPrompt());
                                parser.Start();

                        } catch (ParseException e) {
                                System.out.println("SYNTAX ERROR: The input formula is ill-formed (i.e., doesn't follow the syntax).  Input ignored..." );
                                recoveryFromException();
                        } catch (TokenMgrError e2) {
                                System.out.println("SYNTAX ERROR: Illegal token encountered in the input sentence.  Input ignored..." );
                                recoveryFromException();
                        } catch (NumberFormatException e3) {
                                System.out.println("NUMBER ERROR: Illegal input number found (maybe the input number is too big). Numbers accepted are 0, 1, 2, ..., 2147483647. Input ignored..." );
                                recoveryFromException();
                        } catch (LookaheadSuccess e4) {
                                System.out.println("SYNTAX ERROR: The input formula is ill-formed (i.e., doesn't follow the syntax).  Input ignored..." );
                                recoveryFromException();
                        } catch (Exception ex) {
                                System.out.println("ERROR: Unexpected exception occurred during processing the input. Program exitting..." );
                                ex.printStackTrace();
                                System.exit(-1);
                        }

                        inputString = "" ;              // initialize it
                }
        }

// 2004-11-07 [18:42]
//  **. File input mode 

        private static void runFileInputMode(String filename) {

                System.out.println ();
                System.out.println( "------------------ PLMan: Reading input strings from file `" + filename + "'" );
                System.out.println();

                try {
                        parser = new PropositionalLogicParser(new java.io.FileInputStream(filename));           // init with the filename
                        /* input coding is auto-detected  */
                        br = new BufferedReader(new InputStreamReader(new FileInputStream(filename),  "JISAutoDetect") );
                        parser.FileInputModeStart();

                        // Here, unlike the interactive mode, we wanna see the errors.
                        // 2004-11-07 [18:44] - well, maybe not...
                } catch (java.io.FileNotFoundException e) {
                        System.out.println("PLMan Parser:  File " + filename + " not found.");
                        return;

                } catch (ParseException e) {
                        System.out.println("SYNTAX ERROR: The input formula is ill-formed (i.e., doesn't follow the syntax).  Input ignored..." );
                        e.printStackTrace();
// 					recoveryFromException();
                } catch (TokenMgrError e2) {
                        System.out.println("SYNTAX ERROR: Illegal token encountered in the input sentence.  Input ignored..." );
// 					recoveryFromException();
                } catch (NumberFormatException e3) {
                        System.out.println("NUMBER ERROR: Illegal input number found (maybe the input number is too big). Numbers accepted are 0, 1, 2, ..., 2147483647. Input ignored..." );
// 					recoveryFromException();
                } catch (LookaheadSuccess e4) {
                        System.out.println("SYNTAX ERROR: The input formula is ill-formed (i.e., doesn't follow the syntax).  Input ignored..." );
                        e4.printStackTrace();
// 					recoveryFromException();
                } catch (Exception ex) {
                        System.out.println("ERROR: Unexpected exception occurred during processing the input. Program exitting..." );
                        ex.printStackTrace();
                        System.exit(-1);
                }

        }

// 2004-11-09 [01:01]
//  **. recoveryFromException 

        private static void recoveryFromException () {
                /* RECOVER FROM THE EXCEPTION */
                java.io.StringReader reader = new java.io.StringReader( ""  );
                parser.ReInit(reader);          // REINITIALIZE THE PARSER
                parser.ReInit(System.in);               // REINITIALIZE THE PARSER
                description_flag = false;
                list_flag = false;
        }

// 2004-11-07 [18:45]
//  **. Instructions 

        private static void displayInstruction() {
                System.out.println("Negation symbol is either " + "`~', `NOT', or the NOT symbol in Unicode." );
                System.out.println("Conjunction symbol is either " + "`&', `AND', or the AND symbol in Unicode." );
                System.out.println("Disjunction symbol is either " + "`|', `OR', or the OR symbol in Unicode." );
                System.out.println("Conditional symbol is either " + "`=>', `IMPLIES', or the IMPLIES symbol in Unicode." );
                System.out.println("Biconditional symbol is either " + "`<=>', `IFF', or the IFF symbol in Unicode." );
                System.out.println("Truth symbol can be one of the following: " + "`1', `TRUE', or `T'." );
                System.out.println("False symbol can be one of the following: " + "`0', `FALSE', or `F'.\n" );

                System.out.println("Please send a bug report or suggestions to <hoshi103@chapman.edu>.");
                System.out.println("To exit the program, just input `:exit' at the prompt.\n");
        }


// 2004-11-07 [18:45]
//  **. replaceConstantSymbolsWithTheirValues 

/*
 * given a formula, replace sentence symbols within the formula with their
 * values, if available.
 */

        private String replaceConstantSymbolsWithTheirValues(String original_formula) {
                Object[] objects_of_keys = table.getValues();
                String[] keys = table.getKeys();
                Replacer replacer = new Replacer( keys.length );                // FIX: misleading.
                Object value;
                String changed_formula = original_formula;

                for (int i = 0; i < keys.length; i++ ) {
                        /* if the variable is not initialized, don't replace the symbol with its value (which is null). */
                        if (! ( ((VariableEntry) objects_of_keys[i]).isInitialized() ) ) {
                                continue;               // skip
                        }
                        /* if it is initialized (i.e., has value) */
                        else  {
// 				/* Object to int */
// 				integer_value = ((Integer) ((VariableEntry) table.get(keys[i])).getValue()).intValue();
// 				/* replace `keys[i]' with `integer_value'.  */
// 				changed_formula = replacer.replaceSingleSymbol(changed_formula, keys[i], String.valueOf( integer_value) );
// 2004-11-07 [21:57]
                                value =  ((VariableEntry) table.get(keys[i])).getValue();
                                /* replace `keys[i]' with `value'.  */
                                changed_formula = replacer.replaceSingleSymbol(changed_formula, keys[i], String.valueOf( value ) );
                        }
                }
                return changed_formula;
        }

// 2004-11-07 [18:45]
//  **. getPLManPath 

        private static String getPLManPath() {
                List osEnvironmentVariables = Execute.getProcEnvironment();
                String plman_path = "" ;

                for (Iterator it = osEnvironmentVariables.iterator(); it.hasNext();) {
                        String entry = (String)it.next();
                        int pos = entry.indexOf('=');
                        if (pos != -1) {
                                if( entry.substring(0, pos).equals("PLMAN_SCRIPT_PATH"))
                                        plman_path = entry.substring(pos + 1);
                        }
                }

                return plman_path;
        }

// 2004-11-07 [19:22]
//  **. logicalSystemExists 

        private static boolean logicalSystemExists( String system_name ) {
                if( logical_systems_table.containsKey( system_name ) )
                        return true;
                else return false;

// 		for( int i = 0 ; i < logical_systems.length; i++ ) {
// 			if( system_name.equals( logical_systems[i]  ) )
// 				return true;
// 		}
// 		return false;
        }

        public static String insertPLManPrompt () {
                String plman_prompt_string = "plman[" + input_index + "]" + "> " ;
                return plman_prompt_string;
        }


// 2004-11-09 [01:49]
//  **. outputResult

        public static void outputResult ( Object a ) {
                /* !!! FINAL OUTPUT */

                String output_prefix = "out[" + input_index + "]> ";
                System.out.print( output_prefix + ( current_system.trueOrFalse( a ) ? "True" : "False" )   );           // output True if the system says that it is the case.
                if( verbose_output )
                        System.out.println( "\u0009\u0009[ " + current_system.truthValueToEnglish( a ) + " ]"   );
                else
                        System.out.println(  );
        }

// 2004-11-13 [23:27]
//  **. getCurrentSystem 

        public LogicalSystem getCurrentSystem() {
                return current_system;
        }


// 2004-11-13 [21:16]
//  **. normalizeListState 

        private static void normalizeListState( ) {
                /* NORMALIZATION */
                        if(DEBUG) System.out.println("Setting list flag to false." );
                        list_flag = false;
                        if(DEBUG) System.out.println("Setting nSentenceElements to 0" );
                        nSentenceElements = 0;
                        if(DEBUG) System.out.println("Removing all elements in sentence_symbols_vector and symbols_in_vector." );
                        sentence_symbols_vector.removeAllElements();
                        symbols_in_vector.clear();
        }


// 2004-11-07 [19:37]
//  **. changeLogicalSystem 

        private static void changeLogicalSystem( String system_name ) {
                current_system = (LogicalSystem) logical_systems_table.get(  system_name );
        }

// TOKEN :
// {
//   < EMPTY_STRING: "">
// }

// 2004-11-07 [18:47]
//  *. Productions 


// 2004-11-07 [19:00]
//  **. FileInputModeStart 

/*
 * FileInputMode starts from this production
 */
// void FileInputModeStart() :{String line = ""; int input_index = 0;}
  final public void FileInputModeStart() throws ParseException {
                            String line = "";
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
      case EOL:
      case SEMICOLON:
      case LT:
      case LBRACE:
      case IMPLICIT_RELATION_REMOVE:
      case EXIT:
      case TRANSLATE:
      case LIST_COMMAND:
      case SET_SYSTEM:
      case CURRENT_SYSTEM:
      case VALID:
      case SATISFIABLE:
      case SWITCH_TO_INTERACTIVE_MODE:
      case INPUT_FILE:
      case CREATE_RELATION:
      case ADD_TO_RELATION:
      case REMOVE_FROM_RELATION:
      case SHOW_RELATION:
      case SET_RELATION:
      case SET_BORDERLINE:
      case TRUE:
      case FALSE:
      case NOT:
      case IDENTIFIER:
      case ECHO_STRING:
      case 52:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
      case SEMICOLON:
      case TRUE:
      case FALSE:
      case NOT:
      case IDENTIFIER:
      case 52:
                try {
                        line = br.readLine();
                        input_index++;
                } catch (IOException e) {
                        e.printStackTrace();
                } // end of try-catch

                inputString = "" ;              // initialize it

// 		System.out.println("plman[" + input_index + "]" + "> "  + line);
                System.out.println(insertPLManPrompt() + line);
        StatementList();
        jj_consume_token(EOL);
        break;
      case LT:
      case LBRACE:
      case IMPLICIT_RELATION_REMOVE:
      case EXIT:
      case TRANSLATE:
      case LIST_COMMAND:
      case SET_SYSTEM:
      case CURRENT_SYSTEM:
      case VALID:
      case SATISFIABLE:
      case SWITCH_TO_INTERACTIVE_MODE:
      case INPUT_FILE:
      case CREATE_RELATION:
      case ADD_TO_RELATION:
      case REMOVE_FROM_RELATION:
      case SHOW_RELATION:
      case SET_RELATION:
      case SET_BORDERLINE:
      case ECHO_STRING:
                try {
                        line = br.readLine();
                        input_index++;
                } catch (IOException e) {
                        e.printStackTrace();
                } // end of try-catch
                inputString = "" ;              // initialize it

// 		System.out.println("plman[" + input_index + "]" + "> "  + line);
                System.out.println(insertPLManPrompt() + line);
        Command();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          break;
        default:
          jj_la1[1] = jj_gen;
          ;
        }
        jj_consume_token(EOL);
        break;
      case EOL:
                try {
                        line = br.readLine();
                } catch (IOException e) {
                        e.printStackTrace();
                } // end of try-catch
                inputString = "" ;              // initialize it

        jj_consume_token(EOL);
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
                if ( file_input_to_interactive_mode_flag ) runInteractiveMode();
                else System.exit(0);
  }

// 2004-11-07 [19:01]
//  **. Start 

/*
 * Interactive mode starts from this production
 */
  final public void Start() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER:
    case SEMICOLON:
    case TRUE:
    case FALSE:
    case NOT:
    case IDENTIFIER:
    case 52:
      StatementList();
      jj_consume_token(EOL);
      break;
    case LT:
    case LBRACE:
    case IMPLICIT_RELATION_REMOVE:
    case EXIT:
    case TRANSLATE:
    case LIST_COMMAND:
    case SET_SYSTEM:
    case CURRENT_SYSTEM:
    case VALID:
    case SATISFIABLE:
    case SWITCH_TO_INTERACTIVE_MODE:
    case INPUT_FILE:
    case CREATE_RELATION:
    case ADD_TO_RELATION:
    case REMOVE_FROM_RELATION:
    case SHOW_RELATION:
    case SET_RELATION:
    case SET_BORDERLINE:
    case ECHO_STRING:
      Command();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[3] = jj_gen;
        ;
      }
      jj_consume_token(EOL);
      break;
    case EOL:
      jj_consume_token(EOL);
      break;
    case 0:
      jj_consume_token(0);
                 System.exit(0);
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// 2004-11-07 [19:01]
//  **. StatementList 
  final public void StatementList() throws ParseException {
    Statement();
    label_2:
    while (true) {
      if (jj_2_1(2)) {
        ;
      } else {
        break label_2;
      }
      jj_consume_token(SEMICOLON);
      Statement();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
  }

// // 2004-11-19 [21:40]
// //  **. if statement 

// void IfStatement() : {Object returned_value;  }
// /*
//  * The disambiguating algorithm of JavaCC automatically binds dangling
//  * else's to the innermost if statement.  The LOOKAHEAD specification
//  * is to tell JavaCC that we know what we are doing.
//  */
// {

// // if  inside-then   do the then part
// // if  inside-then    don't execute
// // if  inside-else  don't execute
// // if  inside-else   execute

// 	"if" "[" returned_value = PropositionalExpression() "]" {
// 		if ( current_system.trueOrFalse( returned_value ) ) if_flag = true; 
// 		else if_flag = false;
// 	}
// 	"then" "[" { if( if_flag) execute_p = true; else execute_p = false; }  StatementList() "]" { execute_p = true; }
// 	  [ LOOKAHEAD(1) "else" "[" { if( if_flag) execute_p = false; else execute_p = true; } StatementList() "]" { execute_p = true; } ]
// }





// 2004-11-07 [19:01]
//  **. Statement 
  final public void Statement() throws ParseException {
                    Object a;
    if (jj_2_2(2)) {
      AssignmentExpressionList();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
      case TRUE:
      case FALSE:
      case NOT:
      case IDENTIFIER:
      case 52:
        a = PropositionalExpression();
                        /* !!! FINAL OUTPUT */
                        outputResult( a );
// 			System.out.println( current_system.truthValueToEnglish( a ) );

        break;
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

// 2004-11-07 [19:01]
//  **. PropositionalExpression 
  final public Object PropositionalExpression() throws ParseException {
                                    Object a;
    a = Formula();
                        {if (true) return a;}
    throw new Error("Missing return statement in function");
  }

// 2004-11-07 [19:01]
//  **. Formula 
  final public Object Formula() throws ParseException {
                     Object a;
    a = AdditiveExpression();
                 {if (true) return a;}
    throw new Error("Missing return statement in function");
  }

// 2004-11-07 [19:02]
//  **. AdditiveExpression 

/*
 * => (IMPLIES) and <=> (IFF). Note that they both have lower precedence than
 * AND and OR.
 */
  final public Object AdditiveExpression() throws ParseException {
                              Object a; Object b; Token t;
    a = MultiplicativeExpression();
    label_3:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPLIES:
        t = jj_consume_token(IMPLIES);
                                        inputString = inputString.concat(t.image  + " ");
                                        if(description_flag) formulaDescription = formulaDescription.concat("implies" + " ");
        b = AdditiveExpression();
/*
 * Now evaluate `a => b' 
 */
                                        /* At this point, we already know that a is a natural
					 * number. We treat non-zero natural number to be true. It
					 * follows that  a => b is false iff a is non-zero and b is 0. */
                                        a = current_system.interpretImplies(a, b);
        break;
      case IFF:
        // or 
        
        // 2004-11-07 [21:44]
        //  ***. Iff 
        
        
                                        t = jj_consume_token(IFF);
                                        inputString = inputString.concat(t.image  + " " );
                                        if(description_flag) formulaDescription = formulaDescription.concat("if and only if" + " ");
        b = AdditiveExpression();
                                        a = current_system.interpretIff(a, b);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                  {if (true) return a;}
    throw new Error("Missing return statement in function");
  }

// 2004-11-07 [19:02]
//  **. AssignmentExpressionList 
  final public void AssignmentExpressionList() throws ParseException {
    AssignmentExpression();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      AssignmentExpression();
    }
  }

// 2004-11-07 [19:02]
//  **. AssignmentExpression 
  final public void AssignmentExpression() throws ParseException {
    if (jj_2_4(2)) {
      ValueAssignmentExpression();
    } else if (jj_2_5(2)) {
      DescriptionAssignmentExpression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// 2004-11-07 [19:02]
//  **. ValueAssignmentExpression 
  final public void ValueAssignmentExpression() throws ParseException {
                                    Token t; Object a;
    t = jj_consume_token(IDENTIFIER);
    jj_consume_token(VALUE_ASSIGN);
    a = Formula();
                /* If current_system is "FDE", then the following value assignment will
		 * take no effect, since FDE evaluates expression in terms of
		 * relational status, not by value. */
                if(! ((String) current_system.getSystemName()).equals( "FDE" ) ) {              // not FDE

                        /* insert <id> */
                        table.put( t.image , a);

                }
                else {          // FDE
                        /* do not insert <id>'s value */
                        System.out.println( "The input ignored..."   );
                        System.out.println( "( Current logical system `" + current_system.getSystemName() + "' evaluates expression in terms of 'relation', not by 'value'."   );
                        System.out.println( "In order to add an element to an existing relation, use the expression \":addR ExistingRelation <symbol, value>\" (e.g., :addR  R1 <a, 0>) instead. )"  );
                }
  }

// 2004-11-07 [19:02]
//  **. DescriptionAssignmentExpression 
  final public void DescriptionAssignmentExpression() throws ParseException {
                                          Token t; Token t2;
    t = jj_consume_token(IDENTIFIER);
    jj_consume_token(DESCRIPTION_ASSIGN);
    t2 = jj_consume_token(STRING_LITERAL);
                        String description = t2.image;
                        description = description.substring(1, description.length() - 1);
// eliminate '\', e.g. "some \"string\"" -> some "string"
                        description = description.replaceAll( "\\\\\"" , "\"" );

// 		   description = description.replaceAll( "\\n" , String.valueOf( '\n' ) );		
                        table.put( t.image, null, description);
  }

// 2004-11-07 [19:02]
//  **. MultiplicativeExpression 
  final public Object MultiplicativeExpression() throws ParseException {
                                     Object a; Object b; Token t;
    a = UnaryExpression();
    label_5:
    while (true) {
      if (jj_2_6(2)) {
        ;
      } else {
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        // 2004-11-07 [22:13]
        //  ***. And 
        
                                        t = jj_consume_token(AND);
                                        inputString = inputString.concat(t.image + " ");
                                        if(description_flag) formulaDescription = formulaDescription.concat("and" + " ");
        b = MultiplicativeExpression();
                                        a = (Object) current_system.interpretAnd(a, b);
        break;
      case OR:
        // 2004-11-07 [22:13]
        //  ***. Or 
        
                                        t = jj_consume_token(OR);
                                        inputString = inputString.concat(t.image + " ");
                                        if(description_flag) formulaDescription = formulaDescription.concat("or" + " ");
        b = MultiplicativeExpression();
                                        a = current_system.interpretOr(a, b);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                  {if (true) return a;}
    throw new Error("Missing return statement in function");
  }

// 2004-11-07 [19:02]
//  **. UnaryExpression 
  final public Object UnaryExpression() throws ParseException {
                            Object a; Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT:
      // 2004-11-07 [22:14]
      //  ***. Not 
      
              t = jj_consume_token(NOT);
                inputString = inputString.concat(t.image);
                if(description_flag) formulaDescription = formulaDescription.concat("it is not the case that" + " ");
      a = UnaryExpression();
                                  {if (true) return current_system.interpretNot(a);}
      break;
    case NUMBER:
    case TRUE:
    case FALSE:
    case IDENTIFIER:
    case 52:
      a = AtomicExpression();
          {if (true) return a;}
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// 2004-11-07 [19:02]
//  **. AtomicExpression 
  final public Object AtomicExpression() throws ParseException {
                             Token t; Token t2; Object a;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER:
      // 2004-11-09 [16:06]
      //  ***. Number 
      
      t = jj_consume_token(NUMBER);
                        inputString = inputString.concat(t.image  + " ");
                        if(description_flag) formulaDescription = formulaDescription.concat(t.image + " ");

                        {if (true) return current_system.getCorrespondingNumberFormat( t.toString() );}
      break;
    case TRUE:
      // 2004-11-09 [16:06]
      //  ***. True 
      
      t = jj_consume_token(TRUE);
                inputString = inputString.concat(t.image  + " ");
                if(description_flag) formulaDescription = formulaDescription.concat(t.image + " ");

                {if (true) return current_system.getTrueValue( );}
      break;
    case FALSE:
      // 2004-11-09 [16:06]
      //  ***. False 
      
      t = jj_consume_token(FALSE);
                inputString = inputString.concat(t.image  + " ");
                if(description_flag) formulaDescription = formulaDescription.concat(t.image + " ");

                {if (true) return current_system.getFalseValue( );}
      break;
    case IDENTIFIER:
      // 2004-11-09 [16:07]
      //  ***. Symbol 
      
      a = Symbol();
                  {if (true) return a;}
      break;
    case 52:
      t = jj_consume_token(52);
                inputString = inputString.concat(t.image + " ");
                if(description_flag) formulaDescription = formulaDescription.concat("["  + " ");                // `['   instead of `(' 

      a = Formula();
      t2 = jj_consume_token(53);
                inputString = inputString.concat(t2.image + " ");
                if(description_flag) formulaDescription = formulaDescription.concat("]"  + " ");                // `]'  instead of `)' 

          {if (true) return a;}
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// 2004-11-07 [19:02]
//  **. Symbol 
  final public Object Symbol() throws ParseException {
                   Token t; Object a;
    t = jj_consume_token(IDENTIFIER);
// 2004-11-09 [16:22]
//  ***. adding the description (or translation) of the symbol 

                        inputString = inputString.concat(t.image  + " ");

/*
 * if the command <DESCRIPTION> is entered, the following clause will be executed.
 */
                        if(description_flag) {
                                /* if the atom is declared and it's description is not equal to "", obtain its description.   */
                                if (table.exists(t.image)) {
                                        if( ! ((VariableEntry) table.get(t.image)).getDescription().equals( "" ) ) {
                                                formulaDescription = formulaDescription.concat( "\"" + ((VariableEntry) table.get(t.image)).getDescription() +"\"" + " " );
                                        }
                                        /* elsewise, just append the name of itself. */
                                        else {
                                                formulaDescription = formulaDescription.concat( "`" + t.image + "'"  + " " );
                                        }
                                }
                                /* just append the name of itself. */
                                else {
                                        formulaDescription = formulaDescription.concat( "`" + t.image + "'"  + " " );
                                }
                        }


// 2004-11-09 [16:22]
//  ***. when the symbol is declared already. 

                        if (table.exists(t.image)) {

                                /* DO NOT ADD THE SAME SYMBOL: E.g. If the sentence is p & q | r & p, don't add `p' twice.   */
                                if (list_flag == true) {
                                        if( ! symbols_in_vector.containsKey(t.image) ) {
                                                nSentenceElements++;
                                                symbols_in_vector.put( t.image, "");
                                                sentence_symbols_vector.add((VariableEntry) table.get(t.image));

                                                if(DEBUG) System.out.println("Adding VariableEntry `" + t.image + "' to sentence_symbols_vector." );
                                                if(DEBUG) System.out.println("Now the size of sentence_symbols_vector is: " + sentence_symbols_vector.size());
                                                if(DEBUG) System.out.println("Now number of nSentenceElements is: " + nSentenceElements);
                                        }
                                        else {
                                                if(DEBUG) System.out.println( "Variable " + t.image + " is already inside the vector. so NOT ADDED." );
                                        }
                                }

// 2004-11-09 [16:29]
//  ****. when the symbol is declared, but doesn't have its value 

                                /* if the atom is declared but not initialized, i.e. the atom
				 * has the description but has no value, then return `False'
				 * instead. */
                                if (! (((VariableEntry) table.get(t.image)).isInitialized() )) {

                                        /* if the list_flag is on, we don't want the user to see the message */
                                        if(description_flag == false || list_flag == true) {

                                                /* !!: FDE exception: if the system being evaluated is
						 * FDE, we'd just like to pass the symbol to FDE to see
						 * if it relates to some value. */
                                                if ( ! ((String) current_system.getSystemName()).equals( "FDE" ) ) {            // not FDE
                                                        System.out.println("Propositional atom `" + t.image + "' is uninitialized (i.e. declared, but doesn't have its value). Returning False ( value: " + (current_system.getFalseValue()).toString() + " ) instead... ");
                                                        {if (true) return current_system.getFalseValue( );}
                                                }
                                                else {          // FDE
                                                        {if (true) return ((LogicalSystems.SystemFDE) current_system).interpretSymbol( t.image );}
                                                }

                                        }

                                        /* !!: FDE exception: if the system being evaluated is
					 * FDE, we'd just like to pass the symbol to FDE to see
					 * if it relates to some value. */
                                        if ( ! ((String) current_system.getSystemName()).equals( "FDE" ) ) {            // not FDE
                                                {if (true) return current_system.getTrueValue( );}
                                        }
                                        else {          // FDE
                                                {if (true) return ((LogicalSystems.SystemFDE) current_system).interpretSymbol( t.image );}
                                        }

                                }
// 2004-11-09 [16:29]
//  ****. When the symbol is initialized: either it has its value but doesn't have its description, or it has both

                                else {

                                        /* !!: FDE exception: if the system being evaluated is
					 * FDE, we'd just like to pass the symbol to FDE to see
					 * if it relates to some value. */
                                        if ( ! ((String) current_system.getSystemName()).equals( "FDE" ) ) {            // not FDE
                                                a = ((VariableEntry) table.get(t.image)).getValue() ;
                                                {if (true) return a;}
                                        }
                                        else {          // FDE
                                                {if (true) return ((LogicalSystems.SystemFDE) current_system).interpretSymbol( t.image );}
                                        }

                                }
                        }

// 2004-11-09 [16:23]
//  ***. when the symbol is not declared 

                        else {
                                /* ALLOW nondeclared symbols for LISTING */
                                if (list_flag == true) {
                                        /* DO NOT ADD THE SAME SYMBOL: E.g. If the sentence is p & q | r & p, don't add `p' twice.   */
                                        if( ! symbols_in_vector.containsKey(t.image) ) {
                                                nSentenceElements++;
                                                symbols_in_vector.put( t.image, "");
                                                sentence_symbols_vector.add(new VariableEntry(t.image, null, 1, false));                // 	VariableEntry (String variableName, Object value, int level, boolean isInitialized) 

                                                if(DEBUG) System.out.println("Adding VariableEntry " + t.image + " to sentence_symbols_vector." );
                                                if(DEBUG) System.out.println("Now the size of sentence_symbols_vector is: " + sentence_symbols_vector.size());
                                                if(DEBUG) System.out.println("Now number of nSentenceElements is: " + nSentenceElements);
                                        }
                                        else {
                                                if(DEBUG) System.out.println( "Variable " + t.image + " is already inside the vector. so NOT ADDED." );
                                        }

                                }
                                else {
                                        if( description_flag == false ) {

                                                /* !!: FDE exception: if the system being evaluated is
						 * FDE, we'd just like to pass the symbol to FDE to see
						 * if it relates to some value. */
                                                if ( ! ((String) current_system.getSystemName()).equals( "FDE" ) ) {            // not FDE
                                                        System.out.println("Propositional atom `" + t.image + "' is undeclared. Returning False ( value: " + (current_system.getFalseValue()).toString() + " ) instead. ");
                                                        {if (true) return current_system.getFalseValue( );}
                                                }
                                                else {          // FDE
                                                        {if (true) return ((LogicalSystems.SystemFDE) current_system).interpretSymbol( t.image );}
                                                }

                                        }
                                }

                                /* !!: FDE exception: if the system being evaluated is
				 * FDE, we'd just like to pass the symbol to FDE to see
				 * if it relates to some value. */
                                if ( ! ((String) current_system.getSystemName()).equals( "FDE" ) ) {            // not FDE
                                        {if (true) return current_system.getFalseValue( );}
                                }
                                else {          // FDE
                                        {if (true) return ((LogicalSystems.SystemFDE) current_system).interpretSymbol( t.image );}
                                }

                        }
    throw new Error("Missing return statement in function");
  }

// 2004-11-07 [19:02]
//  **. Command 

/*
 * SOMEBODY. clean this code up for me!!
 */

// void ListCommand() : {}

// void Command() : {Object a; Token t;}
  final public void Command() throws ParseException {
                  Token t; BinaryTwoValuedRelation binaryRelation; Object object; OrderedPair pair;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXIT:
      jj_consume_token(EXIT);
                  System.exit(0);
      break;
    case ECHO_STRING:
      // 2004-11-12 [18:25]
      //  ***. echo
      
      t = jj_consume_token(ECHO_STRING);
        String echo = t.image;
        echo = echo.substring(2, echo.length());
        System.out.println(echo);
      break;
    case SWITCH_TO_INTERACTIVE_MODE:
      jj_consume_token(SWITCH_TO_INTERACTIVE_MODE);
                  file_input_to_interactive_mode_flag = true;
      break;
    case INPUT_FILE:
      jj_consume_token(INPUT_FILE);
      t = jj_consume_token(STRING_LITERAL);
                String plman_path = getPLManPath();
                String filename = t.image.substring(1, t.image.length() - 1);

                if ( plman_path.equals( "" ) )
                        System.out.println( "The environment variable `PLMAN_SCRIPT_PATH' isn't set correctly. " );
                else {
                        String full_filename = plman_path + System.getProperty("file.separator") + filename;
                        runFileInputMode( full_filename );
                }

                System.out.println( plman_path );
      break;
    case TRANSLATE:
      jj_consume_token(TRANSLATE);
                                 if(DEBUG) System.out.println( "Setting `description_flag' to `true'." );
                                 description_flag = true;
      Formula();
                        /* display the description of the formula. */
                        System.out.println(formulaDescription);

                        if(DEBUG) System.out.println( "Setting `description_flag' to `false'." );
                        description_flag = false;
                        formulaDescription = "" ;
      break;
    case LIST_COMMAND:
      jj_consume_token(LIST_COMMAND);
                list_flag = true; if(DEBUG) System.out.println( "Setting list flag to true.");
      Formula();
// 2004-11-07 [22:49]
                                /* !!!!!!! : put those into LogicalSystems */
                                if (list_flag ) {

                                        if ( current_system.truthTableConstructable() ) {
                                                Lister lister = new Lister( current_system, inputString , sentence_symbols_vector, parser);
                                                System.out.println();
                                                lister.listReversed();
                                        } else {
                                                System.out.println( "`:table' command is disabled within this system since truth tables are not constructable within this system."  );
                                        }

                                }
                                else {
                                        System.out.println("Some undeclared symbols found... You must declare all symbols in the sentence to use LIST." );
                                }

                                normalizeListState();
      break;
    case SET_SYSTEM:
      jj_consume_token(SET_SYSTEM);
      t = jj_consume_token(STRING_LITERAL);
                String system_name = t.image.substring(1, t.image.length() - 1);

                if( logicalSystemExists(system_name) ) {
                        current_relation = null ;               // !! make the current relation null. That is, we want it to be destroyed as soon as the system is changed to another.
                        changeLogicalSystem( system_name );
                }
                else {
                        System.out.println( "WARNING: Either logical system `" + system_name + "' doesn't exist or is not yet implemented."  );
                        System.out.println( "Current logical system `" + current_system.getSystemName() + "'  will be used continually." );
                }
      break;
    case CURRENT_SYSTEM:
      jj_consume_token(CURRENT_SYSTEM);
                        System.out.println( current_system.getSystemName() );
      break;
    case SET_RELATION:
      jj_consume_token(SET_RELATION);
      t = jj_consume_token(IDENTIFIER);
                        String relation_name = t.image;
                        if( table.exists( relation_name ) ) {
                                object = ((VariableEntry) table.get( relation_name)).getValue();
                                if( (object instanceof BinaryTwoValuedRelation ) && current_system.getSystemName().equals( "FDE" )  ) {

                                        /* set the relation and make it current */
                                        current_relation = (BinaryTwoValuedRelation) object ;
                                        ((LogicalSystems.SystemFDE) current_system).setRelation( current_relation );
                                        System.out.println( "Relation for the current system is now set to `" + relation_name + "'." );
                                }
                                else {
                                        System.out.println( "WARNING: Symbol `" + relation_name + "' is not an relation object. The attempt failed..."  );
                                }
                        }
                        else {
                                System.out.println( "WARNING: Symbol `" + relation_name + "' doesn't exist. The attempt failed..." );
                        }
      break;
    case CREATE_RELATION:
      jj_consume_token(CREATE_RELATION);
      t = jj_consume_token(IDENTIFIER);
      binaryRelation = BinaryRelationalSet();
                 table.put( t.image , binaryRelation );
                 System.out.println( "Relation `" + t.image + "' is now created."   );
      break;
    case SHOW_RELATION:
      jj_consume_token(SHOW_RELATION);
      t = jj_consume_token(IDENTIFIER);
                        if( table.exists( t.image ) ) {
                                Object R = ((VariableEntry) table.get( t.image)).getValue();
                                if( R instanceof BinaryTwoValuedRelation ) {
                                        ((BinaryTwoValuedRelation) R).printAllRelations() ;
                                }
                                else {
                                        System.out.println( "WARNING: Symbol `" + t.image + "' is not an relation object." );
                                }
                        }
                        else {
                                System.out.println( "WARNING: Symbol `" + t.image + "' doesn't exist." );
                        }
      break;
    case LT:
      // 2004-11-09 [21:15]
      //  ***. implicit add relational element
      
      // ex: 
      // <a,0>, <a,1>	 
      // <b,1>
      
               /* Implicitlly add an element to the current relation, only if the relation is set already.  */
               pair = OrderedPairExpression();
                 if ( current_relation != null ) {
                         if( current_relation.add( pair ) ) System.out.println( "Pair " + pair.toString() + " added to the current relation." );
                         else System.out.println( "WARNING: Pair " + pair.toString() + " could not be added." );
                 }
                 else System.out.println( "A relation for the system is not yet set. One can do so by inputting:\n:setR ExistingRelationSymbol\n\nIf no relation is available, one can make a creation of such an object by inputting:\n:createR NonExistingRelationSymbol"  );
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[12] = jj_gen;
          break label_6;
        }
        jj_consume_token(COMMA);
        pair = OrderedPairExpression();
                 if ( current_relation != null ) {
                         if( current_relation.add( pair ) ) System.out.println( "Pair " + pair.toString() + " added to the current relation." );
                         else System.out.println( "WARNING: Pair " + pair.toString() + " could not be added." );
                 }
                 else System.out.println( "A relation for the system is not yet set. One can do so by inputting:\n:setR ExistingRelationSymbol\n\nIf no relation is available, one can make a creation of such an object by inputting:\n:createR NonExistingRelationSymbol"  );
      }
      break;
    case IMPLICIT_RELATION_REMOVE:
      jj_consume_token(IMPLICIT_RELATION_REMOVE);
      /* Implicitlly remove an element to the current relation, only if the relation is set already.  */
               pair = OrderedPairExpression();
                 if ( current_relation != null ) {
                         if( current_relation.remove( pair ) ) System.out.println( "Pair " + pair.toString() + " removed from the current relation." );
                         else System.out.println( "WARNING: Pair " + pair.toString() + " could not be removed. " );
                 }
                 else System.out.println( "A relation for the system is not yet set. One can do so by inputting:\n:setR ExistingRelationSymbol\n\nIf no relation is available, one can make a creation of such an object by inputting:\n:createR NonExistingRelationSymbol"  );
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[13] = jj_gen;
          break label_7;
        }
        jj_consume_token(COMMA);
        pair = OrderedPairExpression();
                 if ( current_relation != null ) {
                         if( current_relation.remove( pair ) ) System.out.println( "Pair " + pair.toString() + " removed from the currently set relation." );
                         else System.out.println( "WARNING: Pair " + pair.toString() + " could not be removed." );
                 }
                 else System.out.println( "A relation for the system is not yet set. One can do so by inputting:\n:setR ExistingRelationSymbol\n\nIf no relation is available, one can make a creation of such an object by inputting:\n:createR NonExistingRelationSymbol"  );
      }
      break;
    case ADD_TO_RELATION:
      jj_consume_token(ADD_TO_RELATION);
      t = jj_consume_token(IDENTIFIER);
      // 	LOOKAHEAD(2) 
               pair = OrderedPairExpression();
                        if( table.exists( t.image ) ) {

                                object = ((VariableEntry) table.get( t.image)).getValue();
                                if( object instanceof BinaryTwoValuedRelation ) {
                                        if( ((BinaryTwoValuedRelation) object).add( pair ) ) System.out.println( "Pair " + pair.toString() + " added to the current relation." );
                                        else System.out.println( "WARNING: Pair " + pair.toString() + " could not be added." );
                                }
                                else {
                                        System.out.println( "WARNING: Symbol `" + t.image + "' is not an relation object. The ordered pair " + pair.toString() + " cannot be added."  );
                                }
                        }
                        else {
                                System.out.println( "WARNING: Symbol `" + t.image + "' doesn't exist.The ordered pair " + pair.toString() + " cannot be added." );
                        }
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[14] = jj_gen;
          break label_8;
        }
        jj_consume_token(COMMA);
        pair = OrderedPairExpression();
                if( table.exists( t.image ) ) {
                        object = ((VariableEntry) table.get( t.image)).getValue();
                        if( object instanceof BinaryTwoValuedRelation ) {
                                        if( ((BinaryTwoValuedRelation) object).add( pair ) ) System.out.println( "Pair " + pair.toString() + " added to the current relation." );
                                        else System.out.println( "WARNING: Pair " + pair.toString() + " could not be added." );
                        }
                        else {
                                System.out.println( "WARNING: Symbol `" + t.image + "' is not an relation object. The ordered pair " + pair.toString() + " cannot be added."  );
                        }
                }
                else {
                        System.out.println( "WARNING: Symbol `" + t.image + "' doesn't exist.The ordered pair " + pair.toString() + " cannot be added." );
                }
      }
      break;
    case REMOVE_FROM_RELATION:
      jj_consume_token(REMOVE_FROM_RELATION);
      t = jj_consume_token(IDENTIFIER);
      // 	LOOKAHEAD(2) 
               pair = OrderedPairExpression();
                        if( table.exists( t.image ) ) {
                                object = ((VariableEntry) table.get( t.image)).getValue();
                                if( object instanceof BinaryTwoValuedRelation ) {
                                        if( ((BinaryTwoValuedRelation) object).remove( pair ) ) System.out.println( "Pair " + pair.toString() + " removed from the current relation." );
                                        else System.out.println( "WARNING: Pair " + pair.toString() + " could not be removed. " );
// 					((BinaryTwoValuedRelation) object).remove( pair );
                                }
                                else {
                                        System.out.println( "WARNING: Symbol `" + t.image + "' is not an relation object. The ordered pair " + pair.toString() + " cannot be removed."  );
                                }
                        }
                        else {
                                System.out.println( "WARNING: Symbol `" + t.image + "' doesn't exist.The ordered pair " + pair.toString() + " cannot be removed." );
                        }
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[15] = jj_gen;
          break label_9;
        }
        jj_consume_token(COMMA);
        pair = OrderedPairExpression();
                if( table.exists( t.image ) ) {
                        object = ((VariableEntry) table.get( t.image)).getValue();
                        if( object instanceof BinaryTwoValuedRelation ) {
                                        if( ((BinaryTwoValuedRelation) object).remove( pair ) ) System.out.println( "Pair " + pair.toString() + " removed from the current relation." );
                                        else System.out.println( "WARNING: Pair " + pair.toString() + " could not be removed. " );

// 				((BinaryTwoValuedRelation) object).remove( pair );
                        }
                        else {
                                System.out.println( "WARNING: Symbol `" + t.image + "' is not an relation object. The ordered pair " + pair.toString() + " cannot be added."  );
                        }
                }
                else {
                        System.out.println( "WARNING: Symbol `" + t.image + "' doesn't exist.The ordered pair " + pair.toString() + " cannot be added." );
                }
      }
      break;
    case SET_BORDERLINE:
      jj_consume_token(SET_BORDERLINE);
      t = jj_consume_token(NUMBER);
                        if ( current_system.getSystemName().equals( "L" ) ) {
                                ((LogicalSystems.SystemL) current_system).setBorderLine( Double.parseDouble( t.image ) );
                        }
// 			else if ( current_system.getSystemName().equals( "LAleph" ) ) {
// 				((LogicalSystems.SystemLAleph) current_system).setBorderLine( Double.parseDouble( t.image ) );
// 			} 
                        else {
                                System.out.println( "There is not truth value border line in this system."  );
                                System.out.println( "Request rejected..."  );
                        }
      break;
    case SATISFIABLE:
      jj_consume_token(SATISFIABLE);
               list_flag = true; if(DEBUG) System.out.println( "Setting list flag to true.");
      Formula();
                        if (list_flag ) {

                                if ( current_system.truthTableConstructable() ) {
                                        Lister lister = new Lister( current_system, inputString , sentence_symbols_vector, parser);
// 					System.out.println( lister.isSatisfiable() ? "True" : "False" );

                                        if ( lister.isSatisfiable() )           // output with the  true value of the system if it is satisfiable.
                                                outputResult( current_system.getTrueValue() );
                                        else outputResult( current_system.getFalseValue() );
                                } else {
                                        System.out.println( "`:satisfiable' command is disabled within this system since truth tables are not constructable within this system."  );
                                }

                        }
                        else {
                                System.out.println("Some undeclared symbols found... You must declare all symbols in the sentence to use LIST." );
                        }

                        normalizeListState();
      break;
    case VALID:
      jj_consume_token(VALID);
         list_flag = true; if(DEBUG) System.out.println( "Setting list flag to true.");
      Formula();
// 2004-11-07 [22:49]
                        /* !!!!!!! : put those into LogicalSystems */
                        if (list_flag ) {

                                if ( current_system.truthTableConstructable() ) {
                                        Lister lister = new Lister( current_system, inputString , sentence_symbols_vector, parser);
// 					System.out.println( lister.isSatisfiable() ? "True" : "False" );

                                        if ( lister.isValid() )         // output with the  true value of the system if it is satisfiable.
                                                outputResult( current_system.getTrueValue() );
                                        else outputResult( current_system.getFalseValue() );
                                } else {
                                        System.out.println( "`:satisfiable' command is disabled within this system since truth tables are not constructable within this system."  );
                                }

                        }
                        else {
                                System.out.println("Some undeclared symbols found... You must declare all symbols in the sentence to use LIST." );
                        }

                        normalizeListState();
      break;
    case LBRACE:
      EntailmentExpression();
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

                // end of Command


// 2004-11-09 [20:31]
//  **. BinaryRelationalSet 
  final public BinaryTwoValuedRelation BinaryRelationalSet() throws ParseException {
                                                  OrderedPair pair; BinaryTwoValuedRelation R = new BinaryTwoValuedRelation();
    jj_consume_token(LBRACE);
    if (jj_2_7(2)) {
      pair = OrderedPairExpression();
                                          R.add( pair );
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_10;
        }
        jj_consume_token(COMMA);
        pair = OrderedPairExpression();
                                               R.add( pair );
      }
    } else {
      ;
    }
    jj_consume_token(RBRACE);
          {if (true) return R;}
    throw new Error("Missing return statement in function");
  }

// 2004-11-09 [20:31]
//  **. OrderedPairExpression 
  final public OrderedPair OrderedPairExpression() throws ParseException {
                                       Token t1; Token t2;
    jj_consume_token(LT);
    t1 = jj_consume_token(IDENTIFIER);
    jj_consume_token(COMMA);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMBER:
      t2 = jj_consume_token(NUMBER);
      break;
    case IDENTIFIER:
      t2 = jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(GT);
                OrderedPair pair = new OrderedPair( t1.image, t2.image );
                {if (true) return pair;}
    throw new Error("Missing return statement in function");
  }

// 2004-11-07 [19:02]
//  **. new EntailmentExpression 

// void EntailmentExpression() : { int a; String s1 = ""; String s2 = ""; Token t ; Lister lister; HashSet sigma; String formula_alpha; }
// {

// // { a, a => b } |= b
// // { } |= a | b
// /*
// 1. get the `truth yielding assignments' for each formula.

// 2. resolute the values in all sets and make resolutedAssignments

// 3. for some assignment a in resolutedAssignments, if a yeilds True to 
// the right hand side formula, then return true; false o.w.

// */

// 	"{" [ 
// 		Formula() {  
// 			concatenatedFormulas = " ( " + inputString + " ) " ;
// 			sigma.add( inputString );		// add the formula to the set of formulas.
// 			inputString = ""; 
// 		}
// 	( ","  
// 	  Formula() { 
// 		concatenatedFormulas = concatenatedFormulas + "&" + " ( " + inputString + " ) " ;
// 		sigma.add( inputString );		// add the formula to the set of formulas.
// 		inputString = ""; 
// 	})*
// 	 ] "}"


// // 	( <MODELS> | <PROVES> ) 
// <MODELS> 
// 		Formula() (<EOF>)?
// 		{ 
// 			formula_alpha = inputString;

// 			if(DEBUG) System.out.println( "Setting list flag to true.");
// 			list_flag = true;
// 			inputString = concatenatedFormulas ;		// change formula
// 			parser.Formula();		// set sentence_symbols_vector
// 			Lister lister = new Lister( current_system, inputString , sentence_symbols_vector, parser);

// 			if ( lister.entails( sigma,  formula_alpha ) )		// output with the  true value of the system if it is satisfiable.
// 				outputResult( current_system.getTrueValue() );
// 			else outputResult( current_system.getFalseValue() );

// 			normalizeListState();

// 		}


// }		// end













// 2004-11-13 [22:38]
//  **. old EntailmentExpression 


// Object EntailmentExpression() : { int a; String concatenatedFormulas; String s2; Token t;}
  final public void EntailmentExpression() throws ParseException {
                                int a; String concatenatedFormulas = ""; Token t;
    jj_consume_token(LBRACE);
                          list_flag = true; if(DEBUG) System.out.println( "Setting list flag to true.");
    Formula();
                            concatenatedFormulas = "( " + inputString + " )" ; inputString = "" ;
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_11;
      }
      jj_consume_token(COMMA);
      Formula();
                            concatenatedFormulas = concatenatedFormulas.concat( " & ( " + inputString + " )"); inputString = "";
    }
    jj_consume_token(RBRACE);
    jj_consume_token(MODELS);
    Formula();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 0:
      jj_consume_token(0);
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
                // support only those systems
                        if( current_system.getSystemName().equals( "CPL" ) ||
                                current_system.getSystemName().equals( "K3" ) ||
                                current_system.getSystemName().equals( "L3" ) ) {

                        if(DEBUG) System.out.println( "Setting list flag to true.");
                        /* is there IS some element in { }  */
                        if( ! concatenatedFormulas.equals( "" ) )
                                concatenatedFormulas = concatenatedFormulas.concat( " & " + "( " + " ~( " + inputString + " )  )" );
                        String formula = replaceConstantSymbolsWithTheirValues(concatenatedFormulas);
                        if(DEBUG) System.out.println("`EntailmentExpression': the formula to be evaluated is: " + formula);

                        Lister lister = new Lister( current_system, formula , sentence_symbols_vector, parser);
                        a = lister.models(  ) ? 1 : 0;

                        normalizeListState();

                        if ( a == 1 )           // output with the  true value of the system if it is satisfiable.
                                outputResult( current_system.getTrueValue() );
                        else outputResult( current_system.getFalseValue() );

                        } else {
                                System.out.println( "Currently, entailment operator ( |= ) is not supported in system `" + current_system.getSystemName() + "'."   );
                                normalizeListState();
                        }

// 			if ( a == 1 ) {
// 				return current_system.getTrueValue() ;
// 			}
// 			else return current_system.getFalseValue();

  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_3R_24() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_14()) {
    jj_scanpos = xsp;
    if (jj_3R_15()) return true;
    }
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    }
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_3R_30()) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_12()) return true;
    return false;
  }

  final private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3_5()) return true;
    }
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_scan_token(IFF)) return true;
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(DESCRIPTION_ASSIGN)) return true;
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3R_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) return true;
    }
    }
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_13()) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) return true;
    }
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(IMPLIES)) return true;
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(LT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(52)) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(VALUE_ASSIGN)) return true;
    return false;
  }

  public PropositionalLogicParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[21];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_0();
      jj_la1_1();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0xff88c980,0x800,0xff88c980,0x800,0xff88c981,0x800,0x880,0x0,0x1000,0x0,0x80,0x80,0x1000,0x1000,0x1000,0x1000,0xff88c000,0x1000,0x80,0x1000,0x1,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x1881ff,0x0,0x1881ff,0x0,0x1881ff,0x0,0x1081c0,0x1800,0x0,0x600,0x1081c0,0x1080c0,0x0,0x0,0x0,0x0,0x8003f,0x0,0x8000,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public PropositionalLogicParser(java.io.InputStream stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new PropositionalLogicParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PropositionalLogicParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new PropositionalLogicParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PropositionalLogicParser(PropositionalLogicParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(PropositionalLogicParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[54];
    for (int i = 0; i < 54; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 21; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 54; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
