/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.benchmark;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.BenchmarkReport;
import net.sourceforge.pmd.benchmark.BenchmarkResult;
import net.sourceforge.pmd.benchmark.RuleDuration;
import net.sourceforge.pmd.benchmark.StringBuilderCR;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextReport
implements BenchmarkReport {
    private static final int TIME_COLUMN = 48;
    private static final int NAME_COLUMN_WIDTH = 50;
    private static final int VALUE_COLUMN_WIDTH = 8;

    @Override
    public void generate(Set<RuleDuration> stressResults, PrintStream out) {
        out.println("=========================================================");
        out.println("Rule\t\t\t\t\t\tTime in ms");
        out.println("=========================================================");
        for (RuleDuration result : stressResults) {
            StringBuilder buffer = new StringBuilder(result.rule.getName());
            while (buffer.length() < 48) {
                buffer.append(' ');
            }
            buffer.append(result.time);
            out.println(out.toString());
        }
        out.println("=========================================================");
    }

    public void report(Map<String, BenchmarkResult> benchmarksByName) {
        this.generate(benchmarksByName, System.out);
    }

    @Override
    public void generate(Map<String, BenchmarkResult> benchmarksByName, PrintStream out) {
        ArrayList<BenchmarkResult> results = new ArrayList<BenchmarkResult>(benchmarksByName.values());
        long[] totalTime = new long[Benchmark.TotalPMD.index + 1];
        long[] totalCount = new long[Benchmark.TotalPMD.index + 1];
        for (BenchmarkResult benchmarkResult : results) {
            int n = benchmarkResult.type.index;
            totalTime[n] = totalTime[n] + benchmarkResult.getTime();
            int n2 = benchmarkResult.type.index;
            totalCount[n2] = totalCount[n2] + benchmarkResult.getCount();
            if (benchmarkResult.type.index >= Benchmark.MeasuredTotal.index) continue;
            int n3 = Benchmark.MeasuredTotal.index;
            totalTime[n3] = totalTime[n3] + benchmarkResult.getTime();
        }
        results.add(new BenchmarkResult(Benchmark.RuleTotal, totalTime[Benchmark.RuleTotal.index], 0L));
        results.add(new BenchmarkResult(Benchmark.RuleChainTotal, totalTime[Benchmark.RuleChainTotal.index], 0L));
        results.add(new BenchmarkResult(Benchmark.MeasuredTotal, totalTime[Benchmark.MeasuredTotal.index], 0L));
        results.add(new BenchmarkResult(Benchmark.NonMeasuredTotal, totalTime[Benchmark.TotalPMD.index] - totalTime[Benchmark.MeasuredTotal.index], 0L));
        Collections.sort(results);
        StringBuilderCR buf = new StringBuilderCR(PMD.EOL);
        boolean writeRuleHeader = true;
        boolean writeRuleChainRuleHeader = true;
        long ruleCount = 0L;
        long ruleChainCount = 0L;
        for (BenchmarkResult benchmarkResult : results) {
            StringBuilder buf2 = new StringBuilder(benchmarkResult.name);
            buf2.append(':');
            while (buf2.length() <= 50) {
                buf2.append(' ');
            }
            String result = MessageFormat.format("{0,number,0.000}", (double)benchmarkResult.getTime() / 1.0E9);
            buf2.append(StringUtil.lpad(result, 8));
            if (benchmarkResult.type.index <= Benchmark.RuleChainRule.index) {
                buf2.append(StringUtil.lpad(MessageFormat.format("{0,number,###,###,###,###,###}", benchmarkResult.getCount()), 20));
            }
            switch (benchmarkResult.type) {
                case Rule: {
                    if (writeRuleHeader) {
                        writeRuleHeader = false;
                        buf.appendLn(new String[0]);
                        buf.appendLn("---------------------------------<<< Rules >>>---------------------------------");
                        buf.appendLn("Rule name                                       Time (secs)    # of Evaluations");
                        buf.appendLn(new String[0]);
                    }
                    ++ruleCount;
                    break;
                }
                case RuleChainRule: {
                    if (writeRuleChainRuleHeader) {
                        writeRuleChainRuleHeader = false;
                        buf.appendLn(new String[0]);
                        buf.appendLn("----------------------------<<< RuleChain Rules >>>----------------------------");
                        buf.appendLn("Rule name                                       Time (secs)         # of Visits");
                        buf.appendLn(new String[0]);
                    }
                    ++ruleChainCount;
                    break;
                }
                case CollectFiles: {
                    buf.appendLn(new String[0]);
                    buf.appendLn("--------------------------------<<< Summary >>>--------------------------------");
                    buf.appendLn("Segment                                         Time (secs)");
                    buf.appendLn(new String[0]);
                    break;
                }
                case MeasuredTotal: {
                    String s = MessageFormat.format("{0,number,###,###,###,###,###}", ruleCount);
                    String t = MessageFormat.format("{0,number,0.000}", ruleCount == 0L ? 0.0 : TextReport.total(totalTime, Benchmark.Rule, ruleCount));
                    buf.appendLn("Rule Average (", s, " rules):", StringUtil.lpad(t, 37 - s.length()));
                    s = MessageFormat.format("{0,number,###,###,###,###,###}", ruleChainCount);
                    t = MessageFormat.format("{0,number,0.000}", ruleChainCount == 0L ? 0.0 : TextReport.total(totalTime, Benchmark.RuleChainRule, ruleChainCount));
                    buf.appendLn("RuleChain Average (", s, " rules):", StringUtil.lpad(t, 32 - s.length()));
                    buf.appendLn(new String[0]);
                    buf.appendLn("-----------------------------<<< Final Summary >>>-----------------------------");
                    buf.appendLn("Total                                           Time (secs)");
                    buf.appendLn(new String[0]);
                    break;
                }
            }
            buf.appendLn(buf2.toString());
        }
        out.print(buf.toString());
    }

    private static double total(long[] timeTotals, Benchmark index, long count) {
        return (double)timeTotals[index.index] / 1.0E9 / (double)count;
    }
}

