/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.ast;

import java.util.Arrays;

public class SourceCodePositioner {
    private int[] lineOffsets;

    public SourceCodePositioner(String sourceCode) {
        this.analyzeLineOffsets(sourceCode);
    }

    private void analyzeLineOffsets(String sourceCode) {
        String[] lines = sourceCode.split("\n");
        int startOffset = 0;
        int lineNumber = 0;
        this.lineOffsets = new int[lines.length];
        for (String line : lines) {
            this.lineOffsets[lineNumber] = startOffset;
            ++lineNumber;
            startOffset += line.length() + 1;
        }
    }

    public int lineNumberFromOffset(int offset) {
        int lineNumber;
        int search = Arrays.binarySearch(this.lineOffsets, offset);
        if (search >= 0) {
            lineNumber = search;
        } else {
            int insertionPoint = search;
            ++insertionPoint;
            lineNumber = (insertionPoint *= -1) - 1;
        }
        return lineNumber + 1;
    }

    public int columnFromOffset(int offset) {
        int lineNumber = this.lineNumberFromOffset(offset);
        int columnOffset = offset - this.lineOffsets[lineNumber - 1];
        return columnOffset + 1;
    }
}

