/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleContentConstructor;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class QuerySimpleContentConstructor
extends SimpleContentConstructor {
    boolean noNodeIfEmpty;

    public QuerySimpleContentConstructor(Expression select, Expression separator, boolean noNodeIfEmpty) {
        super(select, separator);
        this.noNodeIfEmpty = noNodeIfEmpty;
    }

    public boolean isNoNodeWhenEmpty() {
        return this.noNodeIfEmpty;
    }

    protected int computeCardinality() {
        if (this.noNodeIfEmpty) {
            return 24576;
        }
        return 16384;
    }

    public Expression copy() {
        return new QuerySimpleContentConstructor(this.select.copy(), this.separator.copy(), this.noNodeIfEmpty);
    }

    public CharSequence expandChildren(XPathContext context) throws XPathException {
        Item item = this.select.evaluateItem(context);
        if (item == null) {
            return this.noNodeIfEmpty ? null : "";
        }
        return item.getStringValueCS();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item;
        if (this.isSingleton && this.isAtomic) {
            Item item2 = this.select.evaluateItem(context);
            if (item2 == null) {
                if (this.noNodeIfEmpty) {
                    return null;
                }
                return StringValue.EMPTY_STRING;
            }
            if (item2 instanceof StringValue) {
                return item2;
            }
            return ((AtomicValue)item2).convert(BuiltInAtomicType.STRING, true, context).asAtomic();
        }
        SequenceIterator iter = this.select.iterate(context);
        if (!this.isAtomic) {
            iter = Atomizer.getAtomizingIterator(iter);
        }
        FastStringBuffer sb = new FastStringBuffer(1024);
        boolean first = true;
        String sep = " ";
        while ((item = iter.next()) != null) {
            if (!first) {
                sb.append(sep);
            }
            first = false;
            sb.append(item.getStringValueCS());
        }
        if (first && this.noNodeIfEmpty) {
            return null;
        }
        return StringValue.makeStringValue(sb.condense());
    }
}

