/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.util.ResourceLoader;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSetReferenceId {
    private final boolean external;
    private final String ruleSetFileName;
    private final boolean allRules;
    private final String ruleName;
    private final RuleSetReferenceId externalRuleSetReferenceId;

    public RuleSetReferenceId(String id) {
        this(id, null);
    }

    public RuleSetReferenceId(String id, RuleSetReferenceId externalRuleSetReferenceId) {
        if (externalRuleSetReferenceId != null && !externalRuleSetReferenceId.isExternal()) {
            throw new IllegalArgumentException("Cannot pair with non-external <" + externalRuleSetReferenceId + ">.");
        }
        if (id != null && id.indexOf(44) >= 0) {
            throw new IllegalArgumentException("A single RuleSetReferenceId cannot contain ',' (comma) characters: " + id);
        }
        if (RuleSetReferenceId.isFullRuleSetName(id)) {
            this.external = true;
            this.ruleSetFileName = id;
            this.allRules = true;
            this.ruleName = null;
        } else {
            String tempRuleSetFileName;
            String tempRuleName = this.getRuleName(id);
            String string = tempRuleSetFileName = tempRuleName != null && id != null ? id.substring(0, id.length() - tempRuleName.length() - 1) : id;
            if (RuleSetReferenceId.isFullRuleSetName(tempRuleSetFileName)) {
                this.external = true;
                this.ruleSetFileName = tempRuleSetFileName;
                this.ruleName = tempRuleName;
                this.allRules = tempRuleName == null;
            } else {
                String builtinRuleSet = this.resolveBuiltInRuleset(tempRuleSetFileName);
                if (this.checkRulesetExists(builtinRuleSet)) {
                    this.external = true;
                    this.ruleSetFileName = builtinRuleSet;
                    this.ruleName = tempRuleName;
                    this.allRules = tempRuleName == null;
                } else if (tempRuleSetFileName == null || tempRuleSetFileName.contains(File.separator)) {
                    this.external = true;
                    this.ruleSetFileName = id;
                    this.ruleName = null;
                    this.allRules = true;
                } else {
                    this.external = externalRuleSetReferenceId != null ? externalRuleSetReferenceId.isExternal() : false;
                    this.ruleSetFileName = externalRuleSetReferenceId != null ? externalRuleSetReferenceId.getRuleSetFileName() : null;
                    this.ruleName = id;
                    this.allRules = false;
                }
            }
        }
        if (this.external && this.ruleName != null && !this.ruleName.equals(id) && externalRuleSetReferenceId != null) {
            throw new IllegalArgumentException("Cannot pair external <" + this + "> with external <" + externalRuleSetReferenceId + ">.");
        }
        this.externalRuleSetReferenceId = externalRuleSetReferenceId;
    }

    private boolean checkRulesetExists(String name) {
        boolean resourceFound = false;
        if (name != null) {
            try {
                InputStream resource = ResourceLoader.loadResourceAsStream(name, RuleSetReferenceId.class.getClassLoader());
                if (resource != null) {
                    resourceFound = true;
                    IOUtils.closeQuietly((InputStream)resource);
                }
            }
            catch (RuleSetNotFoundException e) {
                resourceFound = false;
            }
        }
        return resourceFound;
    }

    private String resolveBuiltInRuleset(String name) {
        String result = null;
        if (name != null) {
            int index = name.indexOf(45);
            result = index >= 0 ? "rulesets/" + name.substring(0, index) + "/" + name.substring(index + 1) + ".xml" : (name.matches("[0-9]+.*") ? "rulesets/releases/" + name + ".xml" : name);
        }
        return result;
    }

    private String getRuleName(String rulesetName) {
        int separatorIndex;
        String result = null;
        if (rulesetName != null && (separatorIndex = Math.max(rulesetName.lastIndexOf(47), rulesetName.lastIndexOf(92))) >= 0 && separatorIndex != rulesetName.length() - 1) {
            result = rulesetName.substring(separatorIndex + 1);
        }
        return result;
    }

    private static boolean isFullRuleSetName(String name) {
        return name != null && name.endsWith(".xml");
    }

    public static List<RuleSetReferenceId> parse(String referenceString) {
        ArrayList<RuleSetReferenceId> references = new ArrayList<RuleSetReferenceId>();
        if (referenceString.indexOf(44) == -1) {
            references.add(new RuleSetReferenceId(referenceString));
        } else {
            for (String name : referenceString.split(",")) {
                references.add(new RuleSetReferenceId(name));
            }
        }
        return references;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isAllRules() {
        return this.allRules;
    }

    public String getRuleSetFileName() {
        return this.ruleSetFileName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public InputStream getInputStream(ClassLoader classLoader) throws RuleSetNotFoundException {
        if (this.externalRuleSetReferenceId == null) {
            InputStream in;
            InputStream inputStream = in = StringUtil.isEmpty(this.ruleSetFileName) ? null : ResourceLoader.loadResourceAsStream(this.ruleSetFileName, classLoader);
            if (in == null) {
                throw new RuleSetNotFoundException("Can't find resource " + this.ruleSetFileName + ".  Make sure the resource is a valid file or URL and is on the CLASSPATH. " + "Here's the current classpath: " + System.getProperty("java.class.path"));
            }
            return in;
        }
        return this.externalRuleSetReferenceId.getInputStream(classLoader);
    }

    public String toString() {
        if (this.ruleSetFileName != null) {
            if (this.allRules) {
                return this.ruleSetFileName;
            }
            return this.ruleSetFileName + "/" + this.ruleName;
        }
        if (this.allRules) {
            return "anonymous all Rule";
        }
        return this.ruleName;
    }
}

