/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.controversial;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.VariableAccess;
import net.sourceforge.pmd.lang.dfa.pathfinder.CurrentPath;
import net.sourceforge.pmd.lang.dfa.pathfinder.DAAPathFinder;
import net.sourceforge.pmd.lang.dfa.pathfinder.Executable;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.controversial.DaaRuleViolation;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;

public class DataflowAnomalyAnalysisRule
extends AbstractJavaRule
implements Executable {
    private RuleContext rc;
    private List<DaaRuleViolation> daaRuleViolations;
    private int maxRuleViolations;
    private int currentRuleViolationCount;
    private static final IntegerProperty MAX_PATH_DESCRIPTOR = new IntegerProperty("maxPaths", "Maximum number of checked paths per method. A lower value will increase the performance of the rule but may decrease anomalies found.", 100, 8000, 1000, 1.0f);
    private static final IntegerProperty MAX_VIOLATIONS_DESCRIPTOR = new IntegerProperty("maxViolations", "Maximum number of anomalies per class", 1, 2000, 100, 2.0f);

    public DataflowAnomalyAnalysisRule() {
        this.definePropertyDescriptor(MAX_PATH_DESCRIPTOR);
        this.definePropertyDescriptor(MAX_VIOLATIONS_DESCRIPTOR);
    }

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.maxRuleViolations = this.getProperty(MAX_VIOLATIONS_DESCRIPTOR);
        this.currentRuleViolationCount = 0;
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclaration methodDeclaration, Object data) {
        this.rc = (RuleContext)data;
        this.daaRuleViolations = new ArrayList<DaaRuleViolation>();
        DataFlowNode node = methodDeclaration.getDataFlowNode().getFlow().get(0);
        DAAPathFinder pathFinder = new DAAPathFinder(node, this, this.getProperty(MAX_PATH_DESCRIPTOR));
        pathFinder.run();
        super.visit(methodDeclaration, data);
        return data;
    }

    public void execute(CurrentPath path) {
        if (this.maxNumberOfViolationsReached()) {
            return;
        }
        HashMap<String, Usage> usagesByVarName = new HashMap<String, Usage>();
        Iterator<DataFlowNode> pathIterator = path.iterator();
        while (pathIterator.hasNext()) {
            DataFlowNode inode = pathIterator.next();
            if (inode.getVariableAccess() == null) continue;
            for (VariableAccess va : inode.getVariableAccess()) {
                Usage lastUsage = (Usage)usagesByVarName.get(va.getVariableName());
                if (lastUsage != null) {
                    this.checkVariableAccess(inode, va, lastUsage);
                }
                Usage newUsage = new Usage(va.getAccessType(), inode);
                usagesByVarName.put(va.getVariableName(), newUsage);
            }
        }
    }

    private void checkVariableAccess(DataFlowNode inode, VariableAccess va, Usage u) {
        int startLine = u.node.getLine();
        int endLine = inode.getLine();
        Node lastNode = inode.getNode();
        Node firstNode = u.node.getNode();
        if (va.accessTypeMatches(u.accessType) && va.isDefinition()) {
            this.addDaaViolation(this.rc, lastNode, "DD", va.getVariableName(), startLine, endLine);
        } else if (u.accessType == 2 && va.isReference()) {
            this.addDaaViolation(this.rc, lastNode, "UR", va.getVariableName(), startLine, endLine);
        } else if (u.accessType == 0 && va.isUndefinition()) {
            this.addDaaViolation(this.rc, firstNode, "DU", va.getVariableName(), startLine, endLine);
        }
    }

    private final void addDaaViolation(Object data, Node node, String type, String var, int startLine, int endLine) {
        if (!this.maxNumberOfViolationsReached() && !this.violationAlreadyExists(type, var, startLine, endLine) && node != null) {
            RuleContext ctx = (RuleContext)data;
            String msg = type;
            if (this.getMessage() != null) {
                msg = MessageFormat.format(this.getMessage(), type, var, startLine, endLine);
            }
            DaaRuleViolation violation = new DaaRuleViolation(this, ctx, node, type, msg, var, startLine, endLine);
            ctx.getReport().addRuleViolation(violation);
            this.daaRuleViolations.add(violation);
            ++this.currentRuleViolationCount;
        }
    }

    private boolean maxNumberOfViolationsReached() {
        return this.currentRuleViolationCount >= this.maxRuleViolations;
    }

    private boolean violationAlreadyExists(String type, String var, int startLine, int endLine) {
        for (DaaRuleViolation violation : this.daaRuleViolations) {
            if (violation.getBeginLine() != startLine || violation.getEndLine() != endLine || !violation.getType().equals(type) || !violation.getVariableName().equals(var)) continue;
            return true;
        }
        return false;
    }

    private static class Usage {
        public int accessType;
        public DataFlowNode node;

        public Usage(int accessType, DataFlowNode node) {
            this.accessType = accessType;
            this.node = node;
        }

        public String toString() {
            return "accessType = " + this.accessType + ", line = " + this.node.getLine();
        }
    }
}

