/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractMultiNumericProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerMultiProperty
extends AbstractMultiNumericProperty<Integer[]> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<IntegerMultiProperty>(Integer[].class, numberFieldTypesByKey){

        public IntegerMultiProperty createWith(Map<String, String> valuesById) {
            String[] minMax = 1.minMaxFrom(valuesById);
            Integer[] defaultValues = 1.integersIn(this.defaultValueIn(valuesById));
            return new IntegerMultiProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), Integer.parseInt(minMax[0]), Integer.parseInt(minMax[1]), defaultValues, 0.0f);
        }
    };

    public IntegerMultiProperty(String theName, String theDescription, Integer min, Integer max, Integer[] theDefaults, float theUIOrder) {
        super(theName, theDescription, min, max, theDefaults, theUIOrder);
    }

    @Override
    public Class<Integer[]> type() {
        return Integer[].class;
    }

    @Override
    protected Object createFrom(String value) {
        return Integer.valueOf(value);
    }

    @Override
    protected Object[] arrayFor(int size) {
        return new Integer[size];
    }
}

