/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.processor;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.datasource.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdRunnable
extends PMD
implements Callable<Report> {
    private static final Logger LOG = Logger.getLogger(PmdRunnable.class.getName());
    private final ExecutorService executor;
    private final DataSource dataSource;
    private final String fileName;
    private final List<Renderer> renderers;

    public PmdRunnable(ExecutorService executor, PMDConfiguration configuration, DataSource dataSource, String fileName, List<Renderer> renderers) {
        super(configuration);
        this.executor = executor;
        this.dataSource = dataSource;
        this.fileName = fileName;
        this.renderers = renderers;
    }

    private static void addError(Report report, Exception ex, String fileName) {
        report.addError(new Report.ProcessingError(ex.getMessage(), fileName));
    }

    private void addErrorAndShutdown(Report report, Exception e, String errorMessage) {
        LOG.log(Level.FINE, errorMessage, e);
        PmdRunnable.addError(report, e, this.fileName);
        this.executor.shutdownNow();
    }

    @Override
    public Report call() {
        PmdThread thread = (PmdThread)Thread.currentThread();
        RuleContext ctx = thread.getRuleContext();
        RuleSets rs = thread.getRuleSets(this.configuration.getRuleSets());
        Report report = PmdRunnable.setupReport(rs, ctx, this.fileName);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Processing " + ctx.getSourceCodeFilename());
        }
        for (Renderer r : this.renderers) {
            r.startFileAnalysis(this.dataSource);
        }
        try {
            BufferedInputStream stream = new BufferedInputStream(this.dataSource.getInputStream());
            ctx.setLanguageVersion(null);
            this.getSourceCodeProcessor().processSourceCode(stream, rs, ctx);
        }
        catch (PMDException pmde) {
            LOG.log(Level.FINE, "Error while processing file", pmde.getCause());
            PmdRunnable.addError(report, pmde, this.fileName);
        }
        catch (IOException ioe) {
            this.addErrorAndShutdown(report, ioe, "IOException during processing");
        }
        catch (RuntimeException re) {
            this.addErrorAndShutdown(report, re, "RuntimeException during processing");
        }
        return report;
    }

    public static Thread createThread(int id, Runnable r, RuleSetFactory ruleSetFactory, RuleContext ctx) {
        return new PmdThread(id, r, ruleSetFactory, ctx);
    }

    private static class PmdThread
    extends Thread {
        private final int id;
        private RuleContext context;
        private RuleSets rulesets;
        private final RuleSetFactory ruleSetFactory;

        public PmdThread(int id, Runnable r, RuleSetFactory ruleSetFactory, RuleContext ctx) {
            super(r, "PmdThread " + id);
            this.id = id;
            this.context = new RuleContext(ctx);
            this.ruleSetFactory = ruleSetFactory;
        }

        public RuleContext getRuleContext() {
            return this.context;
        }

        public RuleSets getRuleSets(String rsList) {
            if (this.rulesets == null) {
                try {
                    this.rulesets = this.ruleSetFactory.createRuleSets(rsList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.rulesets;
        }

        public String toString() {
            return "PmdThread " + this.id;
        }
    }
}

