/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.pmd.DataSource;

public class FileDataSource
implements DataSource {
    private File file;

    public FileDataSource(File file) {
        this.file = file;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String getNiceFileName(boolean shortNames, String inputFileName) {
        return this.glomName(shortNames, inputFileName, this.file);
    }

    private String glomName(boolean shortNames, String inputFileName, File file) {
        if (shortNames && inputFileName.indexOf(44) == -1) {
            if (new File(inputFileName).isDirectory()) {
                return this.trimAnyPathSep(file.getAbsolutePath().substring(inputFileName.length()));
            }
            if (inputFileName.indexOf(System.getProperty("file.separator").charAt(0)) == -1) {
                return inputFileName;
            }
            return this.trimAnyPathSep(inputFileName.substring(inputFileName.lastIndexOf(System.getProperty("file.separator"))));
        }
        return file.getAbsolutePath();
    }

    private String trimAnyPathSep(String name) {
        if (name.startsWith(System.getProperty("file.separator"))) {
            return name.substring(1);
        }
        return name;
    }
}

