/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.pmd.CommandLineOptions;
import net.sourceforge.pmd.DataSource;
import net.sourceforge.pmd.ExcludeLines;
import net.sourceforge.pmd.FileDataSource;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceFileSelector;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.SourceTypeDiscoverer;
import net.sourceforge.pmd.SourceTypeToRuleLanguageMapper;
import net.sourceforge.pmd.TargetJDK1_3;
import net.sourceforge.pmd.TargetJDK1_5;
import net.sourceforge.pmd.TargetJDKVersion;
import net.sourceforge.pmd.ZipDataSource;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.cpd.FileFinder;
import net.sourceforge.pmd.cpd.SourceFileOrDirectoryFilter;
import net.sourceforge.pmd.parsers.Parser;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.sourcetypehandlers.SourceTypeHandler;
import net.sourceforge.pmd.sourcetypehandlers.SourceTypeHandlerBroker;

public class PMD {
    public static final String EOL = System.getProperty("line.separator", "\n");
    public static final String VERSION = "3.7";
    private String excludeMarker = "NOPMD";
    private SourceTypeDiscoverer sourceTypeDiscoverer = new SourceTypeDiscoverer();
    private SourceTypeHandlerBroker sourceTypeHandlerBroker = new SourceTypeHandlerBroker();

    public PMD() {
    }

    public PMD(TargetJDKVersion targetJDKVersion) {
        if (targetJDKVersion instanceof TargetJDK1_3) {
            this.setJavaVersion(SourceType.JAVA_13);
        } else if (targetJDKVersion instanceof TargetJDK1_5) {
            this.setJavaVersion(SourceType.JAVA_15);
        }
    }

    public void processFile(Reader reader, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        SourceType sourceType = this.getSourceTypeOfFile(ctx.getSourceCodeFilename());
        this.processFile(reader, ruleSets, ctx, sourceType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processFile(Reader reader, RuleSets ruleSets, RuleContext ctx, SourceType sourceType) throws PMDException {
        try {
            try {
                SourceTypeHandler sourceTypeHandler = this.sourceTypeHandlerBroker.getVisitorsFactoryForSourceType(sourceType);
                ExcludeLines excluder = new ExcludeLines(reader, this.excludeMarker);
                ctx.excludeLines(excluder.getLinesToExclude());
                Parser parser = sourceTypeHandler.getParser();
                Object rootNode = parser.parse(excluder.getCopyReader());
                Thread.yield();
                sourceTypeHandler.getSymbolFacade().start(rootNode);
                Language language = SourceTypeToRuleLanguageMapper.getMappedLanguage(sourceType);
                if (ruleSets.usesDFA(language)) {
                    sourceTypeHandler.getDataFlowFacade().start(rootNode);
                }
                ArrayList<Object> acus = new ArrayList<Object>();
                acus.add(rootNode);
                ruleSets.apply(acus, ctx, language);
            }
            catch (ParseException pe) {
                throw new PMDException("Error while parsing " + ctx.getSourceCodeFilename(), pe);
            }
            catch (Exception e) {
                throw new PMDException("Error while processing " + ctx.getSourceCodeFilename(), e);
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new PMDException("Error while closing " + ctx.getSourceCodeFilename(), e);
            }
        }
        try {}
        catch (IOException e) {
            throw new PMDException("Error while closing " + ctx.getSourceCodeFilename(), e);
        }
        reader.close();
    }

    private SourceType getSourceTypeOfFile(String fileName) {
        SourceType sourceType = this.sourceTypeDiscoverer.getSourceTypeOfFile(fileName);
        if (sourceType == null) {
            sourceType = this.sourceTypeDiscoverer.getSourceTypeOfJavaFiles();
        }
        return sourceType;
    }

    public void processFile(Reader reader, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        this.processFile(reader, new RuleSets(ruleSet), ctx);
    }

    public void processFile(InputStream fileContents, String encoding, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        try {
            this.processFile((Reader)new InputStreamReader(fileContents, encoding), ruleSet, ctx);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PMDException("Unsupported encoding exception: " + uee.getMessage());
        }
    }

    public void processFile(InputStream fileContents, String encoding, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        try {
            this.processFile((Reader)new InputStreamReader(fileContents, encoding), ruleSets, ctx);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PMDException("Unsupported encoding exception: " + uee.getMessage());
        }
    }

    public void processFile(InputStream fileContents, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        this.processFile(fileContents, System.getProperty("file.encoding"), ruleSet, ctx);
    }

    public void setExcludeMarker(String marker) {
        this.excludeMarker = marker;
    }

    public void setJavaVersion(SourceType javaVersion) {
        this.sourceTypeDiscoverer.setSourceTypeOfJavaFiles(javaVersion);
    }

    public static void main(String[] args) {
        block13: {
            CommandLineOptions opts = new CommandLineOptions(args);
            SourceFileSelector fileSelector = new SourceFileSelector();
            fileSelector.setSelectJavaFiles(opts.isCheckJavaFiles());
            fileSelector.setSelectJspFiles(opts.isCheckJspFiles());
            List files = opts.containsCommaSeparatedFileList() ? PMD.collectFromCommaDelimitedString(opts.getInputPath(), fileSelector) : PMD.collectFilesFromOneName(opts.getInputPath(), fileSelector);
            PMD pmd = new PMD();
            if (opts.getTargetJDK().equals("1.3")) {
                if (opts.debugEnabled()) {
                    System.out.println("In JDK 1.3 mode");
                }
                pmd.setJavaVersion(SourceType.JAVA_13);
            } else if (opts.getTargetJDK().equals("1.5")) {
                if (opts.debugEnabled()) {
                    System.out.println("In JDK 1.5 mode");
                }
                pmd.setJavaVersion(SourceType.JAVA_15);
            } else {
                if (opts.debugEnabled()) {
                    System.out.println("In JDK 1.4 mode");
                }
                pmd.setJavaVersion(SourceType.JAVA_14);
            }
            pmd.setExcludeMarker(opts.getExcludeMarker());
            RuleContext ctx = new RuleContext();
            Report report = new Report();
            ctx.setReport(report);
            report.start();
            try {
                RuleSetFactory ruleSetFactory = new RuleSetFactory();
                RuleSets rulesets = ruleSetFactory.createRuleSets(opts.getRulesets());
                PMD.printRuleNamesInDebug(opts.debugEnabled(), rulesets);
                pmd.processFiles(files, ctx, rulesets, opts.debugEnabled(), opts.shortNamesEnabled(), opts.getInputPath(), opts.getEncoding());
            }
            catch (FileNotFoundException fnfe) {
                System.out.println(opts.usage());
                fnfe.printStackTrace();
            }
            catch (RuleSetNotFoundException rsnfe) {
                System.out.println(opts.usage());
                rsnfe.printStackTrace();
            }
            catch (IOException ioe) {
                System.out.println(opts.usage());
                ioe.printStackTrace();
            }
            report.end();
            try {
                Renderer r = opts.createRenderer();
                System.out.println(r.render(ctx.getReport()));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(opts.usage());
                if (!opts.debugEnabled()) break block13;
                e.printStackTrace();
            }
        }
    }

    public void processFiles(List files, RuleContext ctx, RuleSets rulesets, boolean debugEnabled, boolean shortNamesEnabled, String inputPath, String encoding) throws IOException {
        Iterator i = files.iterator();
        while (i.hasNext()) {
            DataSource dataSource = (DataSource)i.next();
            String niceFileName = dataSource.getNiceFileName(shortNamesEnabled, inputPath);
            ctx.setSourceCodeFilename(niceFileName);
            if (debugEnabled) {
                System.out.println("Processing " + ctx.getSourceCodeFilename());
            }
            try {
                BufferedInputStream stream = new BufferedInputStream(dataSource.getInputStream());
                this.processFile((InputStream)stream, encoding, rulesets, ctx);
            }
            catch (PMDException pmde) {
                if (debugEnabled) {
                    pmde.getReason().printStackTrace();
                }
                ctx.getReport().addError(new Report.ProcessingError(pmde.getMessage(), niceFileName));
            }
        }
    }

    private static void printRuleNamesInDebug(boolean debugEnabled, RuleSets rulesets) {
        if (debugEnabled) {
            Iterator i = rulesets.getAllRules().iterator();
            while (i.hasNext()) {
                Rule r = (Rule)i.next();
                System.out.println("Loaded rule " + r.getName());
            }
        }
    }

    private static List collectFilesFromOneName(String inputFileName, SourceFileSelector fileSelector) {
        return PMD.collect(inputFileName, fileSelector);
    }

    private static List collectFromCommaDelimitedString(String fileList, SourceFileSelector fileSelector) {
        ArrayList files = new ArrayList();
        StringTokenizer st = new StringTokenizer(fileList, ",");
        while (st.hasMoreTokens()) {
            files.addAll(PMD.collect(st.nextToken(), fileSelector));
        }
        return files;
    }

    private static List collect(String filename, SourceFileSelector fileSelector) {
        File inputFile = new File(filename);
        if (!inputFile.exists()) {
            throw new RuntimeException("File " + inputFile.getName() + " doesn't exist");
        }
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        if (!inputFile.isDirectory()) {
            if (filename.endsWith(".zip") || filename.endsWith(".jar")) {
                try {
                    ZipFile zipFile = new ZipFile(inputFile);
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry zipEntry = e.nextElement();
                        if (!fileSelector.isWantedFile(zipEntry.getName())) continue;
                        dataSources.add(new ZipDataSource(zipFile, zipEntry));
                    }
                }
                catch (IOException ze) {
                    throw new RuntimeException("Zip file " + inputFile.getName() + " can't be opened");
                }
            } else {
                dataSources.add(new FileDataSource(inputFile));
            }
        } else {
            FileFinder finder = new FileFinder();
            List files = finder.findFilesFrom(inputFile.getAbsolutePath(), new SourceFileOrDirectoryFilter(fileSelector), true);
            Iterator i = files.iterator();
            while (i.hasNext()) {
                dataSources.add(new FileDataSource((File)i.next()));
            }
        }
        return dataSources;
    }
}

