/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.ReportListener;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.dfa.report.ReportTree;
import net.sourceforge.pmd.stat.Metric;

public class Report {
    private ReportTree violationTree = new ReportTree();
    private Set violations = new TreeSet(new RuleViolation.RuleViolationComparator());
    private Set metrics = new HashSet();
    private List listeners = new ArrayList();
    private List errors = new ArrayList();
    private Set linesToExclude = new HashSet();
    private long start;
    private long end;
    private List suppressedRuleViolations = new ArrayList();

    public void exclude(Set lines) {
        this.linesToExclude = lines;
    }

    public Map getCountSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        Iterator iter = this.violationTree.iterator();
        while (iter.hasNext()) {
            Integer value;
            IRuleViolation rv = (IRuleViolation)iter.next();
            String key = (rv.getPackageName() == "" ? "" : rv.getPackageName() + ".") + rv.getClassName();
            Object o = summary.get(key);
            if (o == null) {
                value = new Integer(1);
                summary.put(key, value);
                continue;
            }
            value = (Integer)o;
            summary.put(key, new Integer(value + 1));
        }
        return summary;
    }

    public ReportTree getViolationTree() {
        return this.violationTree;
    }

    public Map getSummary() {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        Iterator i = this.violations.iterator();
        while (i.hasNext()) {
            IRuleViolation rv = (IRuleViolation)i.next();
            if (!summary.containsKey(rv.getRule().getName())) {
                summary.put(rv.getRule().getName(), new Integer(0));
            }
            Integer count = (Integer)summary.get(rv.getRule().getName());
            count = new Integer(count + 1);
            summary.put(rv.getRule().getName(), count);
        }
        return summary;
    }

    public void addListener(ReportListener listener) {
        this.listeners.add(listener);
    }

    public List getSuppressedRuleViolations() {
        return this.suppressedRuleViolations;
    }

    public void addRuleViolation(IRuleViolation violation) {
        if (this.linesToExclude.contains(new Integer(violation.getBeginLine()))) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, true));
            return;
        }
        if (violation.isSuppressed()) {
            this.suppressedRuleViolations.add(new SuppressedViolation(violation, false));
            return;
        }
        this.violations.add(violation);
        this.violationTree.addRuleViolation(violation);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ReportListener listener = (ReportListener)i.next();
            listener.ruleViolationAdded(violation);
        }
    }

    public void addMetric(Metric metric) {
        this.metrics.add(metric);
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ReportListener listener = (ReportListener)i.next();
            listener.metricAdded(metric);
        }
    }

    public void addError(ProcessingError error) {
        this.errors.add(error);
    }

    public boolean hasMetrics() {
        return !this.metrics.isEmpty();
    }

    public Iterator metrics() {
        return this.metrics.iterator();
    }

    public boolean isEmpty() {
        return !this.violations.iterator().hasNext() && this.errors.isEmpty();
    }

    public boolean treeIsEmpty() {
        return !this.violationTree.iterator().hasNext();
    }

    public Iterator treeIterator() {
        return this.violationTree.iterator();
    }

    public Iterator iterator() {
        return this.violations.iterator();
    }

    public Iterator errors() {
        return this.errors.iterator();
    }

    public int treeSize() {
        return this.violationTree.size();
    }

    public int size() {
        return this.violations.size();
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void end() {
        this.end = System.currentTimeMillis();
    }

    public long getElapsedTimeInMillis() {
        return this.end - this.start;
    }

    public static class SuppressedViolation {
        private IRuleViolation rv;
        private boolean isNOPMD;

        public SuppressedViolation(IRuleViolation rv, boolean isNOPMD) {
            this.isNOPMD = isNOPMD;
            this.rv = rv;
        }

        public boolean suppressedByNOPMD() {
            return this.isNOPMD;
        }

        public boolean suppressedByAnnotation() {
            return !this.isNOPMD;
        }

        public IRuleViolation getRuleViolation() {
            return this.rv;
        }
    }

    public static class ProcessingError {
        private String msg;
        private String file;

        public ProcessingError(String msg, String file) {
            this.msg = msg;
            this.file = file;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class ReadableDuration {
        private long duration;

        public ReadableDuration(long duration) {
            this.duration = duration;
        }

        public String getTime() {
            long seconds = 0L;
            long minutes = 0L;
            long hours = 0L;
            if (this.duration > 1000L) {
                seconds = this.duration / 1000L;
            }
            if (seconds > 60L) {
                minutes = seconds / 60L;
                seconds %= 60L;
            }
            if (minutes > 60L) {
                hours = minutes / 60L;
                minutes %= 60L;
            }
            StringBuffer res = new StringBuffer();
            if (hours > 0L) {
                res.append(hours + "h ");
            }
            if (hours > 0L || minutes > 0L) {
                res.append(minutes + "m ");
            }
            res.append(seconds + "s");
            return res.toString();
        }
    }
}

