/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SimpleRuleSetNameMapper;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.ant.Formatter;
import net.sourceforge.pmd.ant.RuleSetWrapper;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class PMDTask
extends Task {
    private Path classpath;
    private List formatters = new ArrayList();
    private List filesets = new ArrayList();
    private int minPriority = 5;
    private boolean shortFilenames;
    private String ruleSetFiles;
    private String encoding = System.getProperty("file.encoding");
    private boolean failOnError;
    private boolean failOnRuleViolation;
    private String targetJDK = "1.4";
    private String failuresPropertyName;
    private String excludeMarker;
    private final Collection nestedRules = new ArrayList();

    public void setShortFilenames(boolean value) {
        this.shortFilenames = value;
    }

    public void setTargetJDK(String value) {
        this.targetJDK = value;
    }

    public void setExcludeMarker(String value) {
        this.excludeMarker = value;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setFailOnRuleViolation(boolean fail) {
        this.failOnRuleViolation = fail;
    }

    public void setRuleSetFiles(String ruleSetFiles) {
        this.ruleSetFiles = ruleSetFiles;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFailuresPropertyName(String failuresPropertyName) {
        this.failuresPropertyName = failuresPropertyName;
    }

    public void setMinimumPriority(int minPriority) {
        this.minPriority = minPriority;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addFormatter(Formatter f) {
        this.formatters.add(f);
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createLongClasspath().setRefid(r);
    }

    public void execute() throws BuildException {
        PMD pmd;
        RuleSets rules;
        this.validate();
        this.ruleSetFiles = new SimpleRuleSetNameMapper(this.ruleSetFiles).getRuleSets();
        try {
            RuleSetFactory ruleSetFactory = new RuleSetFactory();
            ruleSetFactory.setMinimumPriority(this.minPriority);
            if (this.classpath == null) {
                this.log("Using the normal ClassLoader", 3);
                rules = ruleSetFactory.createRuleSets(this.ruleSetFiles);
            } else {
                this.log("Using the AntClassLoader", 3);
                rules = ruleSetFactory.createRuleSets(this.ruleSetFiles, (ClassLoader)new AntClassLoader(this.getProject(), this.classpath));
            }
        }
        catch (RuleSetNotFoundException e) {
            throw new BuildException(e.getMessage());
        }
        this.logRulesUsed(rules);
        if (this.targetJDK.equals("1.3")) {
            this.log("Targeting Java language version 1.3", 3);
            pmd = new PMD();
            pmd.setJavaVersion(SourceType.JAVA_13);
        } else if (this.targetJDK.equals("1.5")) {
            this.log("Targeting Java language version 1.5", 3);
            pmd = new PMD();
            pmd.setJavaVersion(SourceType.JAVA_15);
        } else if (this.targetJDK.equals("jsp")) {
            this.log("Targeting JSP", 3);
            pmd = new PMD();
            pmd.setJavaVersion(SourceType.JSP);
        } else {
            this.log("Targeting Java language version 1.4", 3);
            pmd = new PMD();
        }
        if (this.excludeMarker != null) {
            this.log("Setting exclude marker to be " + this.excludeMarker, 3);
            pmd.setExcludeMarker(this.excludeMarker);
        }
        RuleContext ctx = new RuleContext();
        Report report = new Report();
        ctx.setReport(report);
        report.start();
        Iterator i = this.filesets.iterator();
        while (i.hasNext()) {
            FileSet fs = (FileSet)i.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            for (int j = 0; j < srcFiles.length; ++j) {
                File file = new File(ds.getBasedir() + System.getProperty("file.separator") + srcFiles[j]);
                this.log("Processing file " + file.getAbsoluteFile().toString(), 3);
                ctx.setSourceCodeFilename(this.shortFilenames ? srcFiles[j] : file.getAbsolutePath());
                try {
                    pmd.processFile((InputStream)new BufferedInputStream(new FileInputStream(file)), this.encoding, rules, ctx);
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    if (!this.failOnError) continue;
                    throw new BuildException((Throwable)fnfe);
                }
                catch (PMDException pmde) {
                    this.log(pmde.toString(), 3);
                    if (pmde.getReason() != null) {
                        StringWriter strWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(strWriter);
                        pmde.getReason().printStackTrace(printWriter);
                        this.log(strWriter.toString(), 3);
                    }
                    if (pmde.getReason() != null && pmde.getReason().getMessage() != null) {
                        this.log(pmde.getReason().getMessage(), 3);
                    }
                    if (this.failOnError) {
                        throw new BuildException((Throwable)pmde);
                    }
                    ctx.getReport().addError(new Report.ProcessingError(pmde.getMessage(), ctx.getSourceCodeFilename()));
                }
            }
        }
        report.end();
        this.log(ctx.getReport().size() + " problems found", 3);
        i = this.formatters.iterator();
        while (i.hasNext()) {
            Formatter formatter = (Formatter)i.next();
            this.log("Sending a report to " + formatter, 3);
            formatter.outputReport(ctx.getReport(), this.getProject().getBaseDir().toString());
        }
        if (this.failuresPropertyName != null && ctx.getReport().size() > 0) {
            this.getProject().setProperty(this.failuresPropertyName, String.valueOf(ctx.getReport().size()));
            this.log("Setting property " + this.failuresPropertyName + " to " + String.valueOf(ctx.getReport().size()), 3);
        }
        if (this.failOnRuleViolation && ctx.getReport().size() > 0) {
            throw new BuildException("Stopping build since PMD found " + ctx.getReport().size() + " rule violations in the code");
        }
    }

    private void logRulesUsed(RuleSets rules) {
        this.log("Using these rulesets: " + this.ruleSetFiles, 3);
        RuleSet[] ruleSets = rules.getAllRuleSets();
        for (int j = 0; j < ruleSets.length; ++j) {
            RuleSet ruleSet = ruleSets[j];
            Iterator i = ruleSet.getRules().iterator();
            while (i.hasNext()) {
                Rule rule = (Rule)i.next();
                this.log("Using rule " + rule.getName(), 3);
            }
        }
    }

    private void validate() throws BuildException {
        Iterator i = this.formatters.iterator();
        while (i.hasNext()) {
            Formatter f = (Formatter)i.next();
            if (!f.isNoOutputSupplied()) continue;
            throw new BuildException("toFile or toConsole needs to be specified in Formatter");
        }
        if (this.ruleSetFiles == null) {
            if (this.nestedRules.isEmpty()) {
                throw new BuildException("No rulesets specified");
            }
            this.ruleSetFiles = this.getNestedRuleSetFiles();
        }
        if (!(this.targetJDK.equals("1.3") || this.targetJDK.equals("1.4") || this.targetJDK.equals("1.5") || this.targetJDK.equals("jsp"))) {
            throw new BuildException("The targetjdk attribute, if used, must be set to either '1.3', '1.4', or '1.5', or 'jsp'");
        }
    }

    private String getNestedRuleSetFiles() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.nestedRules.iterator();
        while (it.hasNext()) {
            RuleSetWrapper rs = (RuleSetWrapper)it.next();
            sb.append(rs.getFile());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private Path createLongClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void addRuleset(RuleSetWrapper r) {
        this.nestedRules.add(r);
    }
}

