/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.jaxen.Attribute;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import net.sourceforge.pmd.symboltable.Scope;
import org.apache.xerces.dom.DocumentImpl;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    private String image;
    protected int beginLine = -1;
    protected int endLine;
    protected int beginColumn = -1;
    protected int endColumn;
    private Scope scope;
    private boolean discardable;
    private IDataFlowNode dataFlowNode;

    public IDataFlowNode getDataFlowNode() {
        if (this.dataFlowNode == null) {
            if (this.parent != null) {
                return ((SimpleNode)this.parent).getDataFlowNode();
            }
            return null;
        }
        return this.dataFlowNode;
    }

    public void discardIfNecessary() {
        if (this.discardable) {
            SimpleNode parent = (SimpleNode)this.jjtGetParent();
            SimpleNode kid = (SimpleNode)this.jjtGetChild(0);
            kid.jjtSetParent(parent);
            parent.jjtReplaceChild(this, kid);
        }
    }

    public void setDataFlowNode(IDataFlowNode dataFlowNode) {
        this.dataFlowNode = dataFlowNode;
    }

    public void setDiscardable() {
        this.discardable = true;
    }

    public void setUnDiscardable() {
        this.discardable = false;
    }

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(JavaParser p, int i) {
        this(i);
        this.parser = p;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        if (this.scope == null) {
            return ((SimpleNode)this.parent).getScope();
        }
        return this.scope;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void testingOnly__setBeginLine(int i) {
        this.beginLine = i;
    }

    public void testingOnly__setBeginColumn(int i) {
        this.beginColumn = i;
    }

    public int getBeginColumn() {
        if (this.beginColumn != -1) {
            return this.beginColumn;
        }
        if (this.children != null && this.children.length > 0) {
            return ((SimpleNode)this.children[0]).getBeginColumn();
        }
        throw new RuntimeException("Unable to determine begining line of Node.");
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public Node getNthParent(int n) {
        Node result = null;
        for (int i = 0; i < n; ++i) {
            result = result == null ? this.jjtGetParent() : result.jjtGetParent();
        }
        return result;
    }

    public Node getFirstParentOfType(Class parentType) {
        Node parentNode;
        for (parentNode = this.jjtGetParent(); parentNode != null && parentNode.getClass() != parentType; parentNode = parentNode.jjtGetParent()) {
        }
        return parentNode;
    }

    public List getParentsOfType(Class parentType) {
        ArrayList<Node> parents = new ArrayList<Node>();
        for (Node parentNode = this.jjtGetParent(); parentNode != null; parentNode = parentNode.jjtGetParent()) {
            if (parentNode.getClass() != parentType) continue;
            parents.add(parentNode);
        }
        return parents;
    }

    public List findChildrenOfType(Class targetType) {
        ArrayList list = new ArrayList();
        this.findChildrenOfType(targetType, list);
        return list;
    }

    public void findChildrenOfType(Class targetType, List results) {
        this.findChildrenOfType(this, targetType, results, true);
    }

    public void findChildrenOfType(Class targetType, List results, boolean descendIntoNestedClasses) {
        this.findChildrenOfType(this, targetType, results, descendIntoNestedClasses);
    }

    private void findChildrenOfType(Node node, Class targetType, List results, boolean descendIntoNestedClasses) {
        if (node.getClass().equals(targetType)) {
            results.add(node);
        }
        if (!descendIntoNestedClasses) {
            if (node instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)node).isNested()) {
                return;
            }
            if (node instanceof ASTClassOrInterfaceBodyDeclaration && ((ASTClassOrInterfaceBodyDeclaration)node).isAnonymousInnerClass()) {
                return;
            }
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node child = node.jjtGetChild(i);
            if (child.jjtGetNumChildren() > 0) {
                this.findChildrenOfType(child, targetType, results, descendIntoNestedClasses);
                continue;
            }
            if (!child.getClass().equals(targetType)) continue;
            results.add(child);
        }
    }

    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtReplaceChild(Node old, Node newNode) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != old) continue;
            this.children[i] = newNode;
            return;
        }
        throw new RuntimeException("PMD INTERNAL ERROR: SimpleNode.jjtReplaceChild called to replace a node, but couldn't find the old node");
    }

    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public Document asXml() {
        DocumentImpl document = new DocumentImpl();
        this.appendElement((org.w3c.dom.Node)document);
        return document;
    }

    protected void appendElement(org.w3c.dom.Node parentNode) {
        DocumentNavigator docNav = new DocumentNavigator();
        Document ownerDocument = parentNode.getOwnerDocument();
        if (ownerDocument == null) {
            ownerDocument = (Document)parentNode;
        }
        String elementName = docNav.getElementName(this);
        Element element = ownerDocument.createElement(elementName);
        parentNode.appendChild(element);
        Iterator iter = docNav.getAttributeAxisIterator(this);
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            element.setAttribute(attr.getName(), attr.getValue());
        }
        iter = docNav.getChildAxisIterator(this);
        while (iter.hasNext()) {
            SimpleNode child = (SimpleNode)iter.next();
            child.appendElement(element);
        }
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix) + (this.image == null ? "" : ":" + this.image));
        this.dumpChildren(prefix);
    }

    protected void dumpChildren(String prefix) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public Node getFirstChildOfType(Class childType) {
        return this.getFirstChildOfType(childType, this);
    }

    private Node getFirstChildOfType(Class childType, Node node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node n = node.jjtGetChild(i);
            if (n == null) continue;
            if (n.getClass().equals(childType)) {
                return n;
            }
            Node n2 = this.getFirstChildOfType(childType, n);
            if (n2 == null) continue;
            return n2;
        }
        return null;
    }

    public final boolean containsChildOfType(Class type) {
        return !this.findChildrenOfType(type).isEmpty();
    }

    public List findChildNodesWithXPath(String xpathString) throws JaxenException {
        return new BaseXPath(xpathString, new DocumentNavigator()).selectNodes(this);
    }
}

