/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.dfa.report.AbstractReportNode;
import net.sourceforge.pmd.dfa.report.ClassNode;
import net.sourceforge.pmd.dfa.report.PackageNode;
import net.sourceforge.pmd.dfa.report.ReportVisitor;
import net.sourceforge.pmd.dfa.report.ViolationNode;

public class ReportHTMLPrintVisitor
extends ReportVisitor {
    private StringBuffer packageBuf = new StringBuffer();
    private StringBuffer classBuf = new StringBuffer();
    private int length;

    private void write(String filename, StringBuffer buf) throws IOException {
        String fs = System.getProperty("file.separator");
        String baseDir = ".." + fs;
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(baseDir + fs + filename)));
        bw.write(buf.toString(), 0, buf.length());
        bw.close();
    }

    private String displayRuleViolation(IRuleViolation vio) {
        String ret = "<table border=\"0\">";
        ret = ret + "<tr><td><b>Rule:</b></td><td>" + vio.getRule().getName() + "</td></tr>";
        ret = ret + "<tr><td><b>Description:</b></td><td>" + vio.getDescription() + "</td></tr>";
        if (vio.getVariableName().length() > 0) {
            ret = ret + "<tr><td><b>Variable:</b></td><td>" + vio.getVariableName() + "</td></tr>";
        }
        ret = vio.getEndLine() > 0 ? ret + "<tr><td><b>Line:</b></td><td>" + vio.getEndLine() + " and " + vio.getBeginLine() + "</td></tr>" : ret + "<tr><td><b>Line:</b></td><td>" + vio.getBeginLine() + "</td></tr>";
        ret = ret + "</table>";
        return ret;
    }

    public void visit(AbstractReportNode node) {
        String str;
        if (node.getParent() == null) {
            this.packageBuf.insert(0, "<html> <head>   <title>PMD</title> </head> <body>" + PMD.EOL + "" + "<h2>Package View</h2>" + "<table border=\"1\" align=\"center\" cellspacing=\"0\" cellpadding=\"3\">" + " <tr>" + PMD.EOL + "" + "<th>Package</th>" + "<th>Class</th>" + "<th>#</th>" + " </tr>" + PMD.EOL);
            this.length = this.packageBuf.length();
        }
        super.visit(node);
        if (node instanceof ViolationNode) {
            ViolationNode vnode = (ViolationNode)node;
            vnode.getParent().addNumberOfViolation(1);
            IRuleViolation vio = vnode.getRuleViolation();
            this.classBuf.append("<tr> <td>" + vio.getMethodName() + "</td>" + " <td>" + this.displayRuleViolation(vio) + "</td>" + "</tr>");
        }
        if (node instanceof ClassNode) {
            ClassNode cnode = (ClassNode)node;
            str = cnode.getClassName();
            this.classBuf.insert(0, "<html><head><title>PMD - " + str + "</title></head><body>" + PMD.EOL + "" + "<h2>Class View</h2>" + "<h3 align=\"center\">Class: " + str + "</h3>" + "<table border=\"\" align=\"center\" cellspacing=\"0\" cellpadding=\"3\">" + " <tr>" + PMD.EOL + "" + "<th>Method</th>" + "<th>Violation</th>" + " </tr>" + PMD.EOL);
            this.classBuf.append("</table> </body></html>");
            try {
                this.write(str + ".html", this.classBuf);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while writing HTML report: " + e.getMessage());
            }
            this.classBuf = new StringBuffer();
            this.packageBuf.insert(this.length, "<tr> <td>-</td> <td><a href=\"" + str + ".html\">" + str + "</a></td>" + " <td>" + node.getNumberOfViolations() + "</td>" + "</tr>" + PMD.EOL);
            node.getParent().addNumberOfViolation(node.getNumberOfViolations());
        }
        if (node instanceof PackageNode) {
            PackageNode pnode = (PackageNode)node;
            if (node.getParent() == null) {
                str = "Aggregate";
            } else {
                str = pnode.getPackageName();
                node.getParent().addNumberOfViolation(node.getNumberOfViolations());
            }
            this.packageBuf.insert(this.length, "<tr><td><b>" + str + "</b></td>" + " <td>-</td>" + " <td>" + node.getNumberOfViolations() + "</td>" + "</tr>" + PMD.EOL);
        }
        if (node.getParent() == null) {
            this.packageBuf.append("</table> </body></html>");
            try {
                this.write("index.html", this.packageBuf);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while writing HTML report: " + e.getMessage());
            }
        }
    }
}

