/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.jaxen;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.jaxen.Attribute;

public class AttributeAxisIterator
implements Iterator {
    private Object currObj;
    private MethodWrapper[] methodWrappers;
    private int position;
    private Node node;
    private static Map methodCache = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public AttributeAxisIterator(Node contextNode) {
        this.node = contextNode;
        if (!methodCache.containsKey(contextNode.getClass())) {
            Method[] preFilter = contextNode.getClass().getMethods();
            ArrayList<MethodWrapper> postFilter = new ArrayList<MethodWrapper>();
            for (int i = 0; i < preFilter.length; ++i) {
                if (!this.isAttribute(preFilter[i])) continue;
                postFilter.add(new MethodWrapper(preFilter[i]));
            }
            methodCache.put(contextNode.getClass(), postFilter.toArray(new MethodWrapper[postFilter.size()]));
        }
        this.methodWrappers = (MethodWrapper[])methodCache.get(contextNode.getClass());
        this.position = 0;
        this.currObj = this.getNextAttribute();
    }

    public Object next() {
        if (this.currObj == null) {
            throw new IndexOutOfBoundsException();
        }
        Object ret = this.currObj;
        this.currObj = this.getNextAttribute();
        return ret;
    }

    public boolean hasNext() {
        return this.currObj != null;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Attribute getNextAttribute() {
        if (this.position == this.methodWrappers.length) {
            return null;
        }
        MethodWrapper m = this.methodWrappers[this.position];
        ++this.position;
        return new Attribute(this.node, m.name, m.method);
    }

    protected boolean isAttribute(Method method) {
        return (Integer.TYPE == method.getReturnType() || Boolean.TYPE == method.getReturnType() || (class$java$lang$String == null ? (class$java$lang$String = AttributeAxisIterator.class$("java.lang.String")) : class$java$lang$String) == method.getReturnType()) && method.getParameterTypes().length == 0 && Void.TYPE != method.getReturnType() && !method.getName().startsWith("jjt") && !method.getName().equals("toString") && !method.getName().equals("getScope") && !method.getName().equals("getClass") && !method.getName().equals("getTypeNameNode") && !method.getName().equals("getImportedNameNode") && !method.getName().equals("hashCode");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MethodWrapper {
        public Method method;
        public String name;

        public MethodWrapper(Method m) {
            this.method = m;
            this.name = this.truncateMethodName(m.getName());
        }

        private String truncateMethodName(String n) {
            if (n.startsWith("get")) {
                n = n.substring("get".length());
            } else if (n.startsWith("is")) {
                n = n.substring("is".length());
            } else if (n.startsWith("has")) {
                n = n.substring("has".length());
            } else if (n.startsWith("uses")) {
                n = n.substring("uses".length());
            }
            return n;
        }
    }
}

