/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.ast.ASTAllocationExpression;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.SimpleNode;

public class UnnecessaryConversionTemporary
extends AbstractRule
implements Rule {
    private boolean inPrimaryExpressionContext;
    private boolean usingPrimitiveWrapperAllocation;
    private Set primitiveWrappers = new HashSet();

    public UnnecessaryConversionTemporary() {
        this.primitiveWrappers.add("Integer");
        this.primitiveWrappers.add("Boolean");
        this.primitiveWrappers.add("Double");
        this.primitiveWrappers.add("Long");
        this.primitiveWrappers.add("Short");
        this.primitiveWrappers.add("Byte");
        this.primitiveWrappers.add("Float");
    }

    public Object visit(ASTPrimaryExpression node, Object data) {
        if (node.jjtGetNumChildren() == 0 || node.jjtGetChild(0).jjtGetNumChildren() == 0 || !(node.jjtGetChild(0).jjtGetChild(0) instanceof ASTAllocationExpression)) {
            return super.visit(node, data);
        }
        this.inPrimaryExpressionContext = true;
        super.visit(node, data);
        this.inPrimaryExpressionContext = false;
        this.usingPrimitiveWrapperAllocation = false;
        return data;
    }

    public Object visit(ASTAllocationExpression node, Object data) {
        if (!this.inPrimaryExpressionContext || !(node.jjtGetChild(0) instanceof ASTClassOrInterfaceType)) {
            return super.visit(node, data);
        }
        if (!this.primitiveWrappers.contains(((SimpleNode)node.jjtGetChild(0)).getImage())) {
            return super.visit(node, data);
        }
        this.usingPrimitiveWrapperAllocation = true;
        return super.visit(node, data);
    }

    public Object visit(ASTPrimarySuffix node, Object data) {
        if (!this.inPrimaryExpressionContext || !this.usingPrimitiveWrapperAllocation) {
            return super.visit(node, data);
        }
        if (node.getImage() != null && node.getImage().equals("toString")) {
            this.addViolation(data, node);
        }
        return super.visit(node, data);
    }
}

