/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.optimization;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.rules.optimization.AbstractOptimizationRule;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.Scope;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class MethodArgumentCouldBeFinal
extends AbstractOptimizationRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclaration meth, Object data) {
        if (meth.isNative() || meth.isAbstract()) {
            return data;
        }
        Scope s = meth.getScope();
        Map decls = s.getVariableDeclarations();
        Iterator i = decls.keySet().iterator();
        while (i.hasNext()) {
            VariableNameDeclaration var = (VariableNameDeclaration)i.next();
            if (var.getAccessNodeParent().isFinal() || !(var.getAccessNodeParent() instanceof ASTFormalParameter) || this.assigned((List)decls.get(var))) continue;
            this.addViolation(data, var.getAccessNodeParent(), var.getImage());
        }
        return data;
    }

    private boolean assigned(List usages) {
        Iterator j = usages.iterator();
        while (j.hasNext()) {
            NameOccurrence occ = (NameOccurrence)j.next();
            if (!occ.isOnLeftHandSide() && !occ.isSelfAssignment()) continue;
            return true;
        }
        return false;
    }
}

