/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTEqualityExpression;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTPrimitiveType;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class InefficientEmptyStringCheck
extends AbstractRule {
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTEqualityExpression;

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        SimpleNode nameNode = node.getTypeNameNode();
        if (nameNode instanceof ASTPrimitiveType) {
            return data;
        }
        if (!"String".equals(node.getNameDeclaration().getTypeImage())) {
            return data;
        }
        List declars = node.getUsages();
        Iterator i = declars.iterator();
        while (i.hasNext()) {
            ASTEqualityExpression equality;
            NameOccurrence occ = (NameOccurrence)i.next();
            if (!this.isStringLength(occ) || (equality = (ASTEqualityExpression)occ.getLocation().getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTEqualityExpression == null ? InefficientEmptyStringCheck.class$("net.sourceforge.pmd.ast.ASTEqualityExpression") : class$net$sourceforge$pmd$ast$ASTEqualityExpression)) == null || !this.isCompareZero(equality)) continue;
            this.addViolation(data, occ.getLocation());
        }
        return data;
    }

    private boolean isCompareZero(ASTEqualityExpression equality) {
        return this.checkComparison(equality, 0) || this.checkComparison(equality, 1);
    }

    private boolean isStringLength(NameOccurrence occ) {
        Node pExpression;
        return occ.getNameForWhichThisIsAQualifier() != null && occ.getNameForWhichThisIsAQualifier().getImage().indexOf("trim") != -1 && (pExpression = occ.getLocation().jjtGetParent().jjtGetParent()).jjtGetNumChildren() >= 3 && "length".equals(((SimpleNode)pExpression.jjtGetChild(2)).getImage());
    }

    private boolean checkComparison(ASTEqualityExpression equality, int i) {
        return equality.jjtGetChild(i).jjtGetChild(0).jjtGetChild(0) instanceof ASTLiteral && "0".equals(((SimpleNode)equality.jjtGetChild(i).jjtGetChild(0).jjtGetChild(0)).getImage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

