/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;

public class Appendix {
    public static void main(String[] args) throws Exception {
        RuleSetFactory rsf = new RuleSetFactory();
        Iterator i = rsf.getRegisteredRuleSets();
        StringBuffer sb = new StringBuffer();
        while (i.hasNext()) {
            RuleSet rs = (RuleSet)i.next();
            if (rs.getName().toLowerCase().indexOf(args[0]) == -1) continue;
            sb.append("====================================================================" + PMD.EOL);
            sb.append(rs.getName() + PMD.EOL);
            sb.append(rs.getDescription() + PMD.EOL);
            sb.append("--------------------------------------------------------------------" + PMD.EOL);
            Collection rules = rs.getRules();
            Iterator j = rules.iterator();
            while (j.hasNext()) {
                Rule r = (Rule)j.next();
                sb.append(r.getName() + ": " + Appendix.trimCRs(r.getDescription()) + PMD.EOL);
                sb.append("Example: " + PMD.EOL + Appendix.trimCRs(r.getExample()) + PMD.EOL);
                if (r.hasProperty("xpath")) {
                    sb.append("XPath expression:" + PMD.EOL);
                    sb.append(Appendix.trimCRs(r.getProperties().getProperty("xpath")));
                }
                Set<Object> keys = r.getProperties().keySet();
                boolean header = false;
                Iterator<Object> k = keys.iterator();
                while (k.hasNext()) {
                    String key = (String)k.next();
                    String value = r.getProperties().getProperty(key);
                    if (key.equals("xpath")) continue;
                    if (!header) {
                        sb.append(PMD.EOL + "Properties:" + PMD.EOL);
                        header = true;
                    }
                    sb.append("Name = '" + key + "', value = '" + value + "'" + PMD.EOL);
                }
                sb.append(PMD.EOL + "Notes: " + PMD.EOL);
                sb.append(PMD.EOL + "--------------------------------------------------------------------" + PMD.EOL);
            }
        }
        System.out.println(sb.toString());
    }

    private static String trimCRs(String str) {
        while (str.startsWith(PMD.EOL)) {
            str = str.substring(1);
        }
        while (str.endsWith(PMD.EOL)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

