/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

public class StringUtil {
    private static final String[] ENTITIES = new String[130];

    public static String replaceString(String d, char oldChar, String newString) {
        String fixedNew = newString;
        if (fixedNew == null) {
            fixedNew = "";
        }
        StringBuffer desc = new StringBuffer();
        int index = d.indexOf(oldChar);
        int last = 0;
        while (index != -1) {
            desc.append(d.substring(last, index));
            desc.append(fixedNew);
            last = index + 1;
            index = d.indexOf(oldChar, last);
        }
        desc.append(d.substring(last));
        return desc.toString();
    }

    public static String replaceString(String inputString, String oldString, String newString) {
        String fixedNew = newString;
        if (fixedNew == null) {
            fixedNew = "";
        }
        StringBuffer desc = new StringBuffer();
        int index = inputString.indexOf(oldString);
        int last = 0;
        while (index != -1) {
            desc.append(inputString.substring(last, index));
            desc.append(fixedNew);
            last = index + oldString.length();
            index = inputString.indexOf(oldString, last);
        }
        desc.append(inputString.substring(last));
        return desc.toString();
    }

    public static void appendXmlEscaped(StringBuffer buf, String src) {
        StringUtil.appendXmlEscaped(buf, src, System.getProperty("net.sourceforge.pmd.supportUTF8", "no").equals("yes"));
    }

    private static void appendXmlEscaped(StringBuffer buf, String src, boolean supportUTF8) {
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c > '~') {
                if (!supportUTF8) {
                    if (c <= '\u00ff') {
                        buf.append(ENTITIES[c - 126]);
                        continue;
                    }
                    buf.append("&u").append(Integer.toHexString(c)).append(';');
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == '&') {
                buf.append("&amp;");
                continue;
            }
            if (c == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (c == '>') {
                buf.append("&gt;");
                continue;
            }
            buf.append(c);
        }
    }

    static {
        for (int i = 126; i <= 255; ++i) {
            StringUtil.ENTITIES[i - 126] = "&#" + i + ';';
        }
    }
}

