/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.testframework;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SimpleRuleSetNameMapper;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.SourceTypeToRuleLanguageMapper;
import net.sourceforge.pmd.TargetJDKVersion;

public class RuleTst
extends TestCase {
    public static final SourceType DEFAULT_SOURCE_TYPE = SourceType.JAVA_14;

    public void runTestFromString(String code, int expectedResults, Rule rule) throws Throwable {
        this.runTestFromString(code, expectedResults, rule, DEFAULT_SOURCE_TYPE);
    }

    public Rule findRule(String rs, String r) {
        try {
            Rule rule = new RuleSetFactory().createRuleSets(new SimpleRuleSetNameMapper(rs).getRuleSets()).getRuleByName(r);
            if (rule == null) {
                RuleTst.fail((String)("Rule " + r + " not found in ruleset " + rs));
            }
            return rule;
        }
        catch (RuleSetNotFoundException e) {
            e.printStackTrace();
            RuleTst.fail((String)("Couldn't find ruleset " + rs));
            return null;
        }
    }

    public void runTestFromString(String code, int expectedResults, Rule rule, SourceType sourceType) throws Throwable {
        int res = this.processUsingStringReader(code, rule, sourceType).size();
        RuleTst.assertEquals((String)("Expected " + expectedResults + " failures, got " + res + "."), (int)expectedResults, (int)res);
    }

    private Report processUsingStringReader(String code, Rule rule, SourceType sourceType) throws Throwable {
        Report report = new Report();
        this.runTestFromString(code, rule, report, sourceType);
        return report;
    }

    public void runTestFromString(String code, Rule rule, Report report, SourceType sourceType) throws Throwable {
        PMD p = new PMD();
        RuleContext ctx = new RuleContext();
        ctx.setReport(report);
        ctx.setSourceCodeFilename("n/a");
        RuleSet rules = new RuleSet();
        rules.addRule(rule);
        rules.setLanguage(SourceTypeToRuleLanguageMapper.getMappedLanguage(sourceType));
        p.processFile(new StringReader(code), new RuleSets(rules), ctx, sourceType);
    }

    public void runTestFromString(String code, Rule rule, Report report) throws Throwable {
        this.runTestFromString(code, rule, report, DEFAULT_SOURCE_TYPE);
    }

    public void runTestFromString15(String code, Rule rule, Report report) throws Throwable {
        this.runTestFromString(code, rule, report, SourceType.JAVA_15);
    }

    public void runTestFromString13(String code, Rule rule, Report report) throws Throwable {
        this.runTestFromString(code, rule, report, SourceType.JAVA_13);
    }

    public void runTestFromString(String code, Rule rule, Report report, TargetJDKVersion jdk) throws Throwable {
        PMD p = new PMD(jdk);
        RuleContext ctx = new RuleContext();
        ctx.setReport(report);
        ctx.setSourceCodeFilename("n/a");
        RuleSet rules = new RuleSet();
        rules.addRule(rule);
        p.processFile((Reader)new StringReader(code), rules, ctx);
    }
}

