/**
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */
package test.net.sourceforge.pmd.rules;

import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSetNotFoundException;
import test.net.sourceforge.pmd.testframework.SimpleAggregatorTst;
import test.net.sourceforge.pmd.testframework.TestDescriptor;

public class EmptySwitchStmtRuleTest extends SimpleAggregatorTst {

    private Rule rule;

    public void setUp() throws RuleSetNotFoundException {
        rule = findRule("basic", "EmptySwitchStatements");
    }

    public void testAll() {
        runTests(new TestDescriptor[]{
            new TestDescriptor(TEST1, "bad", 1, rule),
            new TestDescriptor(TEST2, "ok", 0, rule),
        });
    }

    private static final String TEST1 =
            "public class EmptySwitchStmt1 {" + PMD.EOL +
            " public void bar() {" + PMD.EOL +
            "  int x = 2;" + PMD.EOL +
            "  switch (x) {}" + PMD.EOL +
            " }" + PMD.EOL +
            "}";

    private static final String TEST2 =
            "public class EmptySwitchStmt2 {" + PMD.EOL +
            " public void bar() {" + PMD.EOL +
            "  int x = 2;" + PMD.EOL +
            "  switch (x) {" + PMD.EOL +
            "   case 2: int y=4;" + PMD.EOL +
            "  }" + PMD.EOL +
            " }" + PMD.EOL +
            "}";


}
