/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.Driver;
import org.postgresql.PGConnection;

public class DriverWrapper
extends Driver {
    protected static final Logger logger = Logger.getLogger("org.postgis.DriverWrapper");
    public static final String POSTGRES_PROTOCOL = "jdbc:postgresql:";
    public static final String POSTGIS_PROTOCOL = "jdbc:postgresql_postGIS:";
    public static final String REVISION = "$Revision: 2570 $";
    protected static TypesAdder ta72 = null;
    protected static TypesAdder ta74 = null;
    protected static TypesAdder ta80 = null;
    protected TypesAdder typesAdder = DriverWrapper.getTypesAdder(this);
    static /* synthetic */ Class class$org$postgis$PGgeometry;
    static /* synthetic */ Class class$org$postgis$PGbox3d;
    static /* synthetic */ Class class$org$postgis$PGbox2d;
    static /* synthetic */ Class class$org$postgis$PGgeometryLW;

    public DriverWrapper() throws SQLException {
        if (super.getMajorVersion() > 8 || super.getMinorVersion() > 1) {
            logger.fine(((Object)((Object)this)).getClass().getName() + " loaded TypesAdder: " + this.typesAdder.getClass().getName());
        }
    }

    protected static TypesAdder getTypesAdder(Driver driver) throws SQLException {
        if (driver.getMajorVersion() == 7) {
            if (driver.getMinorVersion() >= 3) {
                if (ta74 == null) {
                    ta74 = DriverWrapper.loadTypesAdder("74");
                }
                return ta74;
            }
            if (ta72 == null) {
                ta72 = DriverWrapper.loadTypesAdder("72");
            }
            return ta72;
        }
        if (ta80 == null) {
            ta80 = DriverWrapper.loadTypesAdder("80");
        }
        return ta80;
    }

    private static TypesAdder loadTypesAdder(String string) throws SQLException {
        try {
            Class<?> clazz = Class.forName("org.postgis.DriverWrapper$TypesAdder" + string);
            return (TypesAdder)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new SQLException("Cannot create TypesAdder instance! " + exception.getMessage());
        }
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        string = this.mangleURL(string);
        Connection connection = super.connect(string, properties);
        this.typesAdder.addGT(connection, this.useLW(connection));
        return connection;
    }

    protected boolean useLW(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("null is no valid parameter");
        }
        return false;
    }

    public boolean acceptsURL(String string) throws SQLException {
        try {
            string = this.mangleURL(string);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return super.acceptsURL(string);
    }

    public static String getVersion() {
        return "PostGisWrapper $Revision: 2570 $, wrapping " + Driver.getVersion();
    }

    public static void addGISTypes(PGConnection pGConnection) throws SQLException {
        DriverWrapper.loadTypesAdder("74").addGT((Connection)pGConnection, false);
    }

    public static void addGISTypes80(PGConnection pGConnection) throws SQLException {
        DriverWrapper.loadTypesAdder("80").addGT((Connection)pGConnection, false);
    }

    public static void addGISTypes72(org.postgresql.Connection connection) throws SQLException {
        DriverWrapper.loadTypesAdder("72").addGT((Connection)connection, false);
    }

    protected String mangleURL(String string) throws SQLException {
        String string2 = this.getProtoString();
        if (string.startsWith(string2)) {
            return POSTGRES_PROTOCOL + string.substring(string2.length());
        }
        throw new SQLException("Unknown protocol or subprotocol in url " + string);
    }

    protected String getProtoString() {
        return POSTGIS_PROTOCOL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver((java.sql.Driver)((Object)new DriverWrapper()));
        }
        catch (SQLException sQLException) {
            logger.log(Level.WARNING, "Error registering PostGIS Wrapper Driver", sQLException);
        }
    }

    protected static class TypesAdder80
    extends TypesAdder {
        protected TypesAdder80() {
        }

        public void addGeometries(Connection connection) throws SQLException {
            PGConnection pGConnection = (PGConnection)connection;
            pGConnection.addDataType("geometry", class$org$postgis$PGgeometry == null ? (class$org$postgis$PGgeometry = DriverWrapper.class$("org.postgis.PGgeometry")) : class$org$postgis$PGgeometry);
        }

        public void addBoxen(Connection connection) throws SQLException {
            PGConnection pGConnection = (PGConnection)connection;
            pGConnection.addDataType("box3d", class$org$postgis$PGbox3d == null ? (class$org$postgis$PGbox3d = DriverWrapper.class$("org.postgis.PGbox3d")) : class$org$postgis$PGbox3d);
            pGConnection.addDataType("box2d", class$org$postgis$PGbox2d == null ? (class$org$postgis$PGbox2d = DriverWrapper.class$("org.postgis.PGbox2d")) : class$org$postgis$PGbox2d);
        }

        public void addBinaryGeometries(Connection connection) throws SQLException {
            PGConnection pGConnection = (PGConnection)connection;
            pGConnection.addDataType("geometry", class$org$postgis$PGgeometryLW == null ? (class$org$postgis$PGgeometryLW = DriverWrapper.class$("org.postgis.PGgeometryLW")) : class$org$postgis$PGgeometryLW);
        }
    }

    protected static class TypesAdder72
    extends TypesAdder {
        protected TypesAdder72() {
        }

        public void addGeometries(Connection connection) {
            org.postgresql.Connection connection2 = (org.postgresql.Connection)connection;
            connection2.addDataType("geometry", "org.postgis.PGgeometry");
        }

        public void addBoxen(Connection connection) {
            org.postgresql.Connection connection2 = (org.postgresql.Connection)connection;
            connection2.addDataType("box3d", "org.postgis.PGbox3d");
            connection2.addDataType("box2d", "org.postgis.PGbox2d");
        }

        public void addBinaryGeometries(Connection connection) {
            org.postgresql.Connection connection2 = (org.postgresql.Connection)connection;
            connection2.addDataType("geometry", "org.postgis.PGgeometryLW");
        }
    }

    protected static final class TypesAdder74
    extends TypesAdder {
        protected TypesAdder74() {
        }

        public void addGeometries(Connection connection) {
            PGConnection pGConnection = (PGConnection)connection;
            pGConnection.addDataType("geometry", "org.postgis.PGgeometry");
        }

        public void addBoxen(Connection connection) {
            PGConnection pGConnection = (PGConnection)connection;
            pGConnection.addDataType("box3d", "org.postgis.PGbox3d");
            pGConnection.addDataType("box2d", "org.postgis.PGbox2d");
        }

        public void addBinaryGeometries(Connection connection) {
            PGConnection pGConnection = (PGConnection)connection;
            pGConnection.addDataType("geometry", "org.postgis.PGgeometryLW");
        }
    }

    protected static abstract class TypesAdder {
        protected TypesAdder() {
        }

        public final void addGT(Connection connection, boolean bl) throws SQLException {
            if (bl) {
                this.addBinaryGeometries(connection);
            } else {
                this.addGeometries(connection);
            }
            this.addBoxen(connection);
        }

        public abstract void addGeometries(Connection var1) throws SQLException;

        public abstract void addBoxen(Connection var1) throws SQLException;

        public abstract void addBinaryGeometries(Connection var1) throws SQLException;
    }
}

